/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;

import com.sapportals.wcm.util.resource.ResourceBundles;
import java.util.*;

/**
 * An abstract base class for <code>IAclPermission</code> implementations. <br>
 *
 */
public abstract class AclPermissionImpl implements IAclPermission {
  private static Hashtable s_sortIndices = new Hashtable(20);

  static {
    s_sortIndices.put(ACL_PERMISSION_FULL_CONTROL, new Integer(0));

    s_sortIndices.put(ACL_PERMISSION_READWRITE, new Integer(1));
    s_sortIndices.put(ACL_PERMISSION_READ, new Integer(2));
    s_sortIndices.put(ACL_PERMISSION_WRITE, new Integer(3));
    s_sortIndices.put(ACL_PERMISSION_DELETE, new Integer(4));

    s_sortIndices.put(ACL_PERMISSION_CHANGE_APPROVER, new Integer(1));
    s_sortIndices.put(ACL_PERMISSION_SUBSCRIPTION_UNSUBSCRIBE, new Integer(2));
    s_sortIndices.put(ACL_PERMISSION_SUBSCRIPTION_ACTIVE, new Integer(3));
    s_sortIndices.put(ACL_PERMISSION_SUBSCRIPTION_PASSIVE, new Integer(4));
    s_sortIndices.put(ACL_PERMISSION_SUBSCRIPTION_FOLDER, new Integer(5));

  }

  public final String getDescription()
    throws AclPersistenceException {
    try {
      return ResourceBundles.getBundle(IAclPermission.class.getName()).getString(getName());
    }
    catch (AclPersistenceException e) {
      throw e;
    }
    catch (Exception e) {
            //$JL-EXC$      
      return getName();
    }
  }

  public final String getDescription(Locale locale)
    throws AclPersistenceException {
    try {
      return ResourceBundles.getBundle(IAclPermission.class.getName()).getString(getName(), locale);
    }
    catch (AclPersistenceException e) {
      throw e;
    }
    catch (Exception e) {
            //$JL-EXC$      
      return getName();
    }
  }

  public final int getSortIndex()
    throws AclPersistenceException {
    Integer index = (Integer)s_sortIndices.get(getName());
    if (index == null) {
      return 0;
    }
    return index.intValue();
  }
}
