/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;

import java.util.*;

/**
 * Default implementation of an <code>IAclEntryListIterator</code> , an iterator
 * for <code>IAclEntryList</code> s. <br>
 *
 */
public final class AclEntryListIterator implements IAclEntryListIterator {

  private final Iterator m_iterator;

  public AclEntryListIterator(Iterator iterator) {
    this.m_iterator = iterator;
  }

  public boolean hasNext() {
    return m_iterator.hasNext();
  }

  public IAclEntry next() {
    return (IAclEntry)m_iterator.next();
  }
}
