/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.acl;

import java.util.*;

/**
 * Default implementation of an <code>IAclEntryList</code> , a list of <code>
 * IAclEntry</code> s. <br>
 *
 */
public final class AclEntryList implements IAclEntryList {

  private final List list;
  private boolean containsRaw = false;

  public AclEntryList() {
    this.list = new ArrayList(10);
    this.containsRaw = false;
  }

  public void add(IAclEntry aclEntry) {
    this.list.add(aclEntry);
    if(   ( this.containsRaw == false )
       && ( aclEntry instanceof IAclEntryRaw )
      ) {
      this.containsRaw = true; 
    }
  }

  public boolean containsRawEntries() {
    return this.containsRaw;
  }

  public IAclEntryListIterator iterator() {
    return new AclEntryListIterator(this.list.iterator());
  }

}
