/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm;

import com.sap.tc.logging.Location;
import com.sapportals.wcm.util.logging.LoggingFormatter;

/**
 * TBD: Description of the class.
 */
public class WcmException extends Exception {

  private final static Location log = Location.getLocation(com.sapportals.wcm.WcmException.class);

  protected Throwable ex;
  private boolean logged;

  public boolean isLogged() {
    return this.logged;
  }

  public WcmException() {
    this(true);
  }

  public WcmException(boolean log) {
    super();

    if (log) {
      WcmException.log.errorT("WcmException(43)", LoggingFormatter.extractCallstack(this));
      this.logged = true;
    }
    else {
      if (WcmException.log.beDebug()) {
        WcmException.log.debugT("WcmException(48)", LoggingFormatter.extractCallstack(this));
        this.logged = true;
      }
    }
  }

  public WcmException(String msg) {
    this(msg, true);
  }

  public WcmException(String msg, boolean log) {
    super(msg);

    if (log) {
      WcmException.log.errorT("WcmException(62)", msg + " " + LoggingFormatter.extractCallstack(this));
      this.logged = true;
    }
    else {
      if (WcmException.log.beDebug()) {
        WcmException.log.debugT("WcmException(67)", msg + " " + LoggingFormatter.extractCallstack(this));
        this.logged = true;
      }
    }
  }

  public WcmException(String msg, Throwable ex) {
    this(msg, ex, true);
  }

  public WcmException(String msg, Throwable ex, boolean log) {
    super(msg);

    if (ex instanceof WcmException) {
      this.ex = ((WcmException)ex).getContainedException();
      if (this.ex == null) {
        this.ex = ex;
      }
    }
    else {
      this.ex = ex;

      if (log) {
        WcmException.log.errorT("WcmException(90)", msg + " " + LoggingFormatter.extractCallstack(ex));
        this.logged = true;
      }
      else {
        if (WcmException.log.beDebug()) {
          WcmException.log.debugT("WcmException(95)", msg + " " + LoggingFormatter.extractCallstack(ex));
          this.logged = true;
        }
      }
    }
  }

  public WcmException(Throwable ex) {
    this(ex, true);
  }

  public WcmException(Throwable ex, boolean log) {
    super(ex.getMessage());
    if (ex instanceof WcmException) {
      this.ex = ((WcmException)ex).getContainedException();
      if (this.ex == null) {
        this.ex = ex;
      }
    }
    else {
      this.ex = ex;

      if (log) {
        WcmException.log.errorT("WcmException(118)", ex.getMessage() + " " + LoggingFormatter.extractCallstack(ex));
        this.logged = true;
      }
      else {
        if (WcmException.log.beDebug()) {
          WcmException.log.debugT("WcmException(123)", ex.getMessage() + " " + LoggingFormatter.extractCallstack(ex));
          this.logged = true;
        }
      }
    }
  }
  
  /**
   * Retrieves the contained exception.
   * @return The contained exception or <code>null</code> if no exception is contained.
   */
  public Throwable getContainedException() {
    return this.ex;
  }
}
