/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */
package com.sapportals.wcm;

import com.sapportals.htmlb.enum.CellHAlign;


/**
 * Public constants for property names, repository service types, etc. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/IWcmConst.java#43
 *      $
 */
public interface IWcmConst {
  public final static String SAP_WCM_NAMESPACE = "http://sapportals.com/xmlns/cm";
  public final static String NAMESPACE_SEPARATOR = "/";
  public final static String RESOURCE_CONTEXT = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "resourcecontext";
  public final static String HTTP_SERVLET_REQUEST = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "httpservletrequest";
  public final static String PRIMARY_LOCALE = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "primarylocale";
  public final static String REQUEST_URI = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "requesturi";
  public final static String EXTERNAL_PARAMETERS = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "externalparameters";
  public final static String SAP_WCM_NAMESPACE_ACCSTAT = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "acc_stat";
  public final static String SAP_WCM_NAMESPACE_COLLABORATION = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "collaboration";
  public final static String SAP_WCM_NAMESPACE_RATING = SAP_WCM_NAMESPACE_COLLABORATION;
  public final static String SAP_WCM_NAMESPACE_RENDERING = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "rendering";
	public final static String SAP_WCM_NAMESPACE_EDIT = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "edit";
	
  public final static String VIRTUAL_ROOT_PREFIX = "/";

  /** is Collection property name */
  public static final String PROP_COLLECTION = "collection";

  /** LinkType property name */
  public static final String PROP_LINKTYPE = "linktype";

  /** Extension property name */
  public static final String PROP_EXTENSION = "extension";

  /**
   * Hidden property name
   */
  public final static String PROP_HIDDEN = "hidden";

  /**
   * Readonly property name
   */
  public final static String PROP_READONLY = "readonly";

  /**
   * Creationdate property name
   */
  public final static String PROP_CREATIONDATE = "created";

  /**
   * Lastmodified property name
   */
  public final static String PROP_LASTMODIFIED = "modified";

  /**
   * Description property name
   */
  public final static String PROP_DESCRIPTION = "description";

  /**
   * Displayname property name
   */
  public final static String PROP_DISPLAYNAME = "displayname";
  public final static String PROP_CREATEDBY = "createdby";
  public final static String PROP_LASTMODIFIEDBY = "modifiedby";

  /**
   * Contenttype property name
   */
  public final static String PROP_CONTENTTYPE = "contenttype";

  /**
   * Contentlength property name
   */
  public final static String PROP_CONTENTLENGTH = "contentlength";

  /**
   * ETag property name
   */
  public final static String PROP_ETAG = "etag";

  /**
   * Versioned property name
   */
  public final static String PROP_VERSIONED = "versioned";

  /**
   * Enhanced collection switch property name
   */
  public final static String PROP_ENHANCED_COLLECTION = "enhancedcollection";

  /**
   * Content language
   */
  public final static String PROP_CONTENT_LANGUAGE = "contentlanguage";

  /**
   * property name for embedded links
   */
  public final static String PROP_EMBEDDED_LINKS = "embedded-links";

  /**
   * property name for restricted links
   */
  public final static String PROP_RESTRICTED_LINKS = "restricted-links";

  /**
   * property name for indexing of resource content
   */
  public final static String PROP_INDEX_CONTENT = "index-content";

  /**
   * property name for embedded keywords
   */
  public final static String PROP_EMBEDDED_KEYWORDS = "embedded-keywords";

  /**
   * property name for resource type
   */
  public final static String PROP_RESOURCE_TYPE = "resourcetype";

  /**
   * property name for attachments
   */
  public final static String PROP_ATTACHMENT = "attachment";

  /**
   * property name for rating
   */
  public final static String PROP_RATING = "rating";

  /** property name for rating */
  public static final String PROP_RATING_AMOUNT_RATING = "ratingvoteamount";

  /** property name for rating */
  public static final String PROP_RATING_AMOUNT_USER = "ratinguseramount";

  /** property name for rating */
  public static final String PROP_RATING_USER = "ratinguser";

  /**
   * property name for accstat - readbyme
   */
  public final static String PROP_READBYME = "readbyme";

  /**
   * property name for accstat - lastreaddate
   */
  public final static String PROP_LASTREADDATE = "lastreaddate";

  /**
   * property name for comment - Number of Comments
   */
  public final static String PROP_COMMENT_COUNT = "commentcount";

  /**
   * property name for feedback - Number of Feedbacks
   */
  public final static String PROP_FEEDBACK_COUNT = "feedbackcount";

  /**
   * property name for personalnotecount - NUmber of Personal Notes
   */
  public final static String PROP_PERSNOTE_COUNT = "personalnotecount";

  /**
   * property name for discussioncount - Number of Threads
   */
  public final static String PROP_DISCUSSION_COUNT = "discussioncount";

  /**
   * property name for discussioncount - Number of Topics
   */
  public final static String PROP_DISCUSSION_TOPICS_COUNT = "discussion_topic_count";

  /**
   * property name for rank value - Rank Value of search result
   */
  public final static String PROP_RANK_VALUE = "rankvalue";

  /**
   * property name for feedback - Number of Feedbacks
   */
  public final static String PROP_DOC_ABSTRACT = "documentabstract";

  /**
   * property name for feedback - Number of Feedbacks
   */
  public final static String PROP_CATEGORIES = "categories";

  /**
   * property name for resource rendering - URL of content
   */
  public final static String PROP_CONTENTLINK = "contentlink";

  /**
   * property name for feedback - Number of Feedbacks
   */
  public final static String PROP_HIGHLIGHTED_CONTENTLINK = "highlighted_contentlink";

  /**
   * additional meta tag name for user property
   */
  public final static String PROP_ADD_METATAG_NAME_EP60PRINCIPAL = "isEP60Principal";

  // --- Repository Service types ---

  /**
   * meta info service for property configuration
   */
  public final static String PROPERTY_CONFIG_SERVICE = "PropertyConfigurationService";

  /**
   * identifier for Subscription-Service
   */
  public final static String SUBSCRIPTION_SERVICE = "SubscriptionRepositoryService";

  /**
   * identifier for Timebased Publish-Service
   */
  public final static String TIMEBASED_PUBLISH_SERVICE = "TimebasedPublishRepositoryService";

  /**
   * identifier for Retrieval-Service
   */

  //  public static final String RETRIEVAL_SERVICE = "retrieval";

  /**
   * identifier for Retrieval-Service
   *
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for TextMining-Service
   *
   */

  //  public static final String TEXTMINING_SERVICE = "textmining";

  /**
   * identifier for Retrieval-Service
   *
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for TextMining-Service
   *
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for TextMining-Service
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for TextMining-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for Retrieval-Service
   * identifier for TextMining-Service identifier for Retrieval-Service
   * identifier for Retrieval-Service identifier for TextMining-Service
   * identifier for Retrieval-Service identifier for TextMining-Service
   * identifier for Statemanagement-Service
   *
   */
  public final static String STATEMANAGEMENT_SERVICE = "StatemanagementRepositoryService";

  /**
   * identifier for read application-defined properties service
   */
  public final static String APP_PROPERTIES_SERVICE = "AppPropertiesRepositoryService";

  /**
   * identifier for event logging service
   */
  public final static String EVENTLOG_SERVICE = "EventLogRepositoryService";

  /**
   * identifier for discussion service
   */
  public final static String DISCUSSION_SERVICE = "DiscussionRepositoryService";

  /**
   * identifier for rating service
   */
  public final static String RATING_SERVICE = "RatingRepositoryService";

  /**
   * identifier for comment service
   */
  public final static String COMMENT_SERVICE = "CommentRepositoryService";

  /**
   * identifier for personal note service
   */
  public final static String PERSONALNOTE_SERVICE = "PersonalNoteRepositoryService";

  /**
   * identifier for feedback service
   */
  public final static String FEEDBACK_SERVICE = "FeedbackRepositoryService";

  /**
   * identifier for shared space service
   */
  public final static String SHAREDSPACE_SERVICE = "sharedspace";

  /**
   * identifier for access statistic service
   */
  public final static String ACCESSSTATISTIC_SERVICE = "AccessStatisticRepositoryService";

  /**
   * identifier for info service
   */

  //  public static final String INFO_SERVICE = "info";

  /**
   * identifier for info service
   *
   * identifier for info service identifier for info service identifier for info
   * service identifier for info service identifier for info service identifier
   * for ACL service
   *
   */
  public final static String ACL_SERVICE = "ServiceAclRepositoryService";

  /**
   * identifier for attachment service
   */
  public final static String ATTACHMENT_SERVICE = "attachment";

  /**
   * identifier for layout service
   */
  public final static String LAYOUT_SERVICE = "LayoutRepositoryService";

  /**
   * CONSTANTS FOR SERVICE_SERVLET ************************** ** identifiers for
   * XML-FILE the ServiceServlet
   */
  public final static String SERVICE_SERVLET_PARAMETER_XML_FILE = "ConfigFileName";

  /**
   * default for XML-FILE for the ServiceServlet
   */
  public final static String SERVICE_SERVLET_VALUE_XML_FILE = "Service.xml";

  /**
   * XML-FILE for the SubscriptionAdministration
   */
  public final static String SERVICE_SERVLET_SUBSCRIPTIONADMINISTRATION_XML_FILE = "SubscriptionAdministration.xml";
  public final static String SERVICE_SERVLET_SUBSCRIPTIONADMINISTRATION_STARTPAGE = "SubscriptionAdministrationPage";

  /**
   * default for XML-FILE for the ServiceServlet
   */
  public final static String SERVICE_SERVLET_PARAMETER_STARTPAGE = "StartPage";

  /**
   * default for XML-FILE for the ServiceServlet
   */
  public final static String SERVICE_SERVLET_VALUE_STARTPAGE = "SimplePage";

  /**
   * default for XML-FILE for the ServiceServlet
   */
  public final static String SERVICE_SERVLET_PARAMETER_STRING_ONE = "StringOne";

  /**
   * default for XML-FILE for the ServiceServlet
   */
  public final static String SERVICE_SERVLET_PARAMETER_STRING_TWO = "StringTwo";
  public final static String SERVICE_SERVLET_PARAMETER_SERVICE_TYPE = "ServiceType";
  public final static String SERVICE_SERVLET_PARAMETER_SERVICE_ID = "ServiceID";
  public final static String SERVICE_SERVLET_PARAMETER_ACTION = "Action";
  public final static String SERVICE_SERVLET_PARAMETER_RESOURCE = "Uri";
  public final static String SERVICE_SERVLET_PARAMETER_REPOSITORY = "Repository";
  public final static String SERVICE_SERVLET_PARAMETER_IS_GLOBAL = "isGlobal";
  public final static String SERVICE_SERVLET_PARAMETER_LOCATION = "Location"; //the folder the caller url is coming from
  public final static String SERVICE_SERVLET_PARAMETER_POPUP = "Popup";
  public final static String SERVICE_SERVLET_PARAMETER_PREFIX = "_";
  public final static String SERVICE_SERVLET_VALUE_TRUE = "true";
  public final static String SERVICE_SERVLET_VALUE_FALSE = "false";

  /**
   * identifiers for actions triggered through the ServiceServlet
   */
  public final static String SERVICE_SERVLET_ACTION_DELETE = "delete";

  /**
   * additional parameter tags for the service servlet to transport values
   * unique to services
   */
  public final static String SERVICE_SERVLET_PARAMETER_SUBSCRIPTIONID = "subscriptionID";

  /**
   * CONSTANTS FOR SENDTO_SERVLET *************************
   */
  /**
   * CONSTANTS FOR SENDTO_SERVLET *************************
   *
   * CONSTANTS FOR SENDTO_SERVLET ************************* CONSTANTS FOR
   * SENDTO_SERVLET ************************* CONSTANTS FOR SENDTO_SERVLET
   * ************************* CONSTANTS FOR SENDTO_SERVLET
   * ************************* CONSTANTS FOR SENDTO_SERVLET
   * ************************* identifiers for XML-FILE the SendToServlet
   *
   */
  public final static String SENDTO_SERVLET_PARAMETER_XML_FILE = "ConfigFileName";

  /**
   * default for XML-FILE for the SendToServlet
   */
  public final static String SENDTO_SERVLET_VALUE_XML_FILE = "SendTo.xml";

  /**
   * default for XML-FILE for the SendToServlet
   */
  public final static String SENDTO_SERVLET_PARAMETER_STARTPAGE = "StartPage";

  /**
   * default for XML-FILE for the SendToServlet
   */
  public final static String SENDTO_SERVLET_VALUE_STARTPAGE = "SimplePage";
  public final static String SENDTO_SERVLET_PARAMETER_TO = "PersistentTo";
  public final static String SENDTO_SERVLET_PARAMETER_SUBJECT = "PersistentSubject";
  public final static String SENDTO_SERVLET_PARAMETER_DESCRIPTION = "PersistentDescription";
  public final static String SENDTO_SERVLET_PARAMETER_RESOURCE = "Uri";
  public final static String SENDTO_SERVLET_PARAMETER_SENDASLINK = "PersistentSendAsLink";
  public final static String SENDTO_SERVLET_PARAM_DESCRIPTION_URI = "DescriptionResourceUri";
  public final static String SENDTO_SERVLET_VALUE_TRUE = "true";
  public final static String SENDTO_SERVLET_VALUE_FALSE = "false";

  /**
   * CONSTANTS FOR PROPERTIES_SERVLET *************************
   */
  public final static String PROPERTIES_SERVLET_PARAMETER_RESOURCE = "Uri";
  public final static String PROPERTIES_SERVLET_VALUE_XML_FILE = "Properties.xml";
  public final static String PROPERTIES_SERVLET_PARAMETER_XML_FILE = "ConfigFileName";
  public final static String PROPERTIES_SERVLET_PARAMETER_STARTPAGE = "StartPage";

  /**
   * CONSTANTS FOR COMMENT_SERVLET *************************
   */
  public final static String COMMENT_SERVLET_PARAMETER_STARTPAGE = "Comment";
  public final static String COMMENT_SERVLET_PARAMETER_XMLFILE = "Comment.xml";
  public final static String COMMENT_SERVLET_PARAM_DESCRIPTION_URI = "TextUri";

  /**
   * CONSTANTS FOR FEEDBACK_SERVLET *************************
   */
  public final static String FEEDBACK_SERVLET_PARAMETER_STARTPAGE = "Feedback";
  public final static String FEEDBACK_SERVLET_PARAMETER_XMLFILE = "Feedback.xml";
  public final static String FEEDBACK_SERVLET_PARAM_DESCRIPTION_URI = "TextUri";

  /**
   * CONSTANTS FOR INDEX_TAXONOMY_BROWSER_SERVLET ***********
   */
  public final static String INDEX_TAXONOMY_BROWSER_STARTPAGE = "IndexTaxonomyBrowserPage";

  //***************************************************************************

  /**
   * attribute names for property definitions
   */
  public final static String PROP_DEF_ATTR_APPLICATION = "application";

  /**
   * Instance type of a component in the WCM Framework: A new instance is
   * created for each request
   */
  public final static int INSTANCE_TYPE_MULTI = 1;

  /**
   * Instance type of a component in the WCM Framework: One instance per ID in
   * the configuration
   */
  public final static int INSTANCE_TYPE_ID = 2;

  /**
   * Instance type of a component in the WCM Framework: Component is a singleton
   */
  public final static int INSTANCE_TYPE_SINGLETON = 3;

  /**
   * Parameter to be appended to URL during usermapping redirection operation
   */
  public final static String USER_MAPPING_REDIRECT = "UserMappingRedirect";

  /**
   * CONSTANTS FOR SORTINGORDER ************************
   */
  /**
   * CONSTANTS FOR SORTINGORDER ************************
   *
   * CONSTANTS FOR SORTINGORDER ************************ CONSTANTS FOR
   * SORTINGORDER ************************ CONSTANTS FOR SORTINGORDER
   * ************************ CONSTANTS FOR SORTINGORDER
   * ************************ CONSTANTS FOR SORTINGORDER
   * ************************ key for sort ascending
   *
   */
  public static String SORTORDERASCENDING = "0";

  /**
   * key for sort descending
   */
  public static String SORTORDERDESCENDING = "1";

  /**
   * Constants for security manager ********************
   */
  public final static String SECURITY_MANAGER_TYPE_ACL = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "acl";
  public final static String SECURITY_MANAGER_TYPE_ATTACHMENT = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "attachment";
  public final static String SECURITY_MANAGER_TYPE_COLLABORATION = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "collaboration";
  public final static String SECURITY_MANAGER_TYPE_W2K = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "w2k";

  /**
   * Constants for controls instructions display ********************
   */
  public final static String CONTROLS_INSTRUCTION_SUMMARY = "summary";
  public final static String CONTROLS_INSTRUCTION_NONE = "none";

  /**
   * extension for discussion master resources
   */
  public final static String DISCUSSION_EXTENSION = "dsc";

  /**
   * Resource Context Properties *****
   */
  public final static String CACHE_MAX_DOCUMENT_AGE = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "cache_max_document_age";

  /**
   * Optional {@link java.lang.Long} in IResourceContext, telling that caller does not
   * accept resource lookups lasting longer than the given time in milliseconds.
   */
  public final static String CACHE_MAX_LOOKUP_TIME_MS = SAP_WCM_NAMESPACE + NAMESPACE_SEPARATOR + "cache_max_lookup_time_ms";
  public final static CellHAlign WCM_HORIZONTAL_ALIGN_RIGHT = CellHAlign.ENDOFLINE;

  /** Resource type for Portal Page in Favorites app*/
  public final static String RESOURCE_TYPE_PORTAL_PAGE = RESOURCE_TYPE_NAMESPACE.APPLICATIONS + NAMESPACE_SEPARATOR + "portalpage";

  /** Prefix for content link for Portal Navigation link */
  public final static String CONTENT_LINK_PORTAL_NAVIGATION = "<PORTAL_NAVIGATION>";
  
  /** Prefix for content link for Portal Navigation link */
  public final static String CONTENT_LINK_PREFIX_NAVIGATION = "portalNavigation:";
  
  /** Prefix for content link which ponits to a km item */
  public final static String CONTENT_LINK_PREFIX_RID = "rid:";
   
  /** Prefix for content link which points to a room page*/
   public final static String CONTENT_LINK_PREFIX_ROOM = "room:"; 

  /**
   * Resourcetype namespaces **********
   */
  public interface RESOURCE_TYPE_NAMESPACE {
    public final static String FRAMEWORK = "http://sap.com/xmlns/cm/framework";
    public final static String APPLICATIONS = "http://sap.com/xmlns/cm/app";
    public final static String COLLABORATION = APPLICATIONS + NAMESPACE_SEPARATOR + "collaboration";
  }

  /**
   * Resourcetypes **********
   */
  public interface RESOURCE_TYPES {
    /**
     * collaboration discussion resources ***************
     */
    public final static String DISCUSSION_MASTERCOLLECTION = RESOURCE_TYPE_NAMESPACE.COLLABORATION + NAMESPACE_SEPARATOR + "discussionmastercollection";
    public final static String DISCUSSION_MASTERRESOURCE = RESOURCE_TYPE_NAMESPACE.COLLABORATION + NAMESPACE_SEPARATOR + "discussionmasterresource";
    public final static String DISCUSSION_COLLECTION = RESOURCE_TYPE_NAMESPACE.COLLABORATION + NAMESPACE_SEPARATOR + "discussioncollection";
    public final static String DISCUSSION_TOPIC = RESOURCE_TYPE_NAMESPACE.COLLABORATION + NAMESPACE_SEPARATOR + "discussiontopic";
    public final static String DISCUSSION_POST = RESOURCE_TYPE_NAMESPACE.COLLABORATION + NAMESPACE_SEPARATOR + "discussionpost";
    public final static String DISCUSSION_TOPIC_REPLIES = RESOURCE_TYPE_NAMESPACE.COLLABORATION + NAMESPACE_SEPARATOR + "discussiontopicreplycollection";
    public final static String DISCUSSION_POST_REPLIES = RESOURCE_TYPE_NAMESPACE.COLLABORATION + NAMESPACE_SEPARATOR + "discussionpostreplycollection";
  }
}
