<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">

	<!-- template scheme may be tranferred to the 'match' base -->
	
	<xsl:import href="functions.xslt"/>
	
	<xsl:param name="prj-exception-class"/>
	<xsl:variable name="prj-exception-name">
		<xsl:call-template name="substring-after-last">
			<xsl:with-param name="string" select="$prj-exception-class"/>
			<xsl:with-param name="substring" select="'.'"/>
		</xsl:call-template>
	</xsl:variable>
	
	<xsl:variable name="class-intro">
		<xsl:text>/*
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
</xsl:text>
	</xsl:variable>

	<xsl:template name="class-intro">
		<xsl:value-of select="$class-intro"/>
	</xsl:template>

	<xsl:variable name="class-comments">
		<xsl:text>/**
 * @generated by XSLT engine
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
 
</xsl:text>
	</xsl:variable>

	<xsl:template name="class-comments">
		<xsl:value-of select="$class-comments"/>
	</xsl:template>

	<xsl:template name="xapp-package">
		<xsl:for-each select="ancestor-or-self::coolservice">
			<xsl:call-template name="revert">
				<xsl:with-param name="path" select="application/@provider"/>
			</xsl:call-template>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="application/@id"/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="class-package">
		<xsl:apply-templates	select="ancestor-or-self::coolservice" mode="services-package"/>
	</xsl:template>
	
	<xsl:template match="coolservice" mode="services-package">
		<xsl:call-template name="xapp-package"/>
		<xsl:value-of select="concat('.services.',translate(@name,$upper-case,$lower-case))"/>
	</xsl:template>
	
	<xsl:template name="bos-package">
		<xsl:for-each select="ancestor-or-self::coolservice">
			<xsl:call-template name="xapp-package"/>
			<xsl:value-of select="concat('.bos.',translate(@name,$upper-case,$lower-case))"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="property" mode="default-value">
		<xsl:call-template name="java-const">
			<xsl:with-param name="value" select="@SG:default"/>
			<xsl:with-param name="type">
				<xsl:choose>
					<xsl:when test="@SG:enumeration"><xsl:value-of select="@SG:enumeration"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
</xsl:stylesheet>
