<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:param name="project-package"/>
	<xsl:variable name="package-prefix" select="translate($project-package,'/\','..')"/>

	<xsl:variable name="lower-case" select="'abcdefghijklmnopqrstuvwxyz'"/>
	<xsl:variable name="upper-case" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
	<xsl:variable name="crlf">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text>	</xsl:text>
	</xsl:variable>
	<xsl:template name="java-id">
		<xsl:param name="id"/>
		<xsl:if test="string-length($id)&gt;0">
			<xsl:value-of select="translate(substring($id,1,1),$upper-case,$lower-case)"/>
		</xsl:if>
		<xsl:if test="string-length($id)&gt;1">
			<xsl:value-of select="substring($id,2,string-length($id)-1)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="title-case">
		<xsl:param name="string"/>
		<xsl:if test="string-length($string)&gt;0">
			<xsl:value-of select="translate(substring($string,1,1),$lower-case,$upper-case)"/>
		</xsl:if>
		<xsl:if test="string-length($string)&gt;1">
			<xsl:value-of select="substring($string,2,string-length($string)-1)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="const-id">
		<xsl:param name="id"/>
		<xsl:value-of select="translate($id,$lower-case,$upper-case)"/>
	</xsl:template>
	<xsl:template name="revert">
		<xsl:param name="path"/>
		<xsl:choose>
			<xsl:when test="contains($path,'.')">
				<xsl:call-template name="revert">
					<xsl:with-param name="path" select="substring-after($path,'.')"/>
				</xsl:call-template>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="substring-before($path,'.')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$path"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="substring-after-last">
		<xsl:param name="string"/>
		<xsl:param name="substring"/>
		<xsl:choose>
			<xsl:when test="contains($string,$substring)">
				<xsl:call-template name="substring-after-last">
					<xsl:with-param name="string" select="substring-after($string,$substring)"/>
					<xsl:with-param name="substring" select="$substring"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="string-replace">
		<xsl:param name="string"/>
		<xsl:param name="old-pattern"/>
		<xsl:param name="new-pattern"/>
		<xsl:choose>
			<xsl:when test="contains($string,$old-pattern)">
				<xsl:value-of select="substring-before($string,$old-pattern)"/>
				<xsl:value-of select="$new-pattern"/>
				<xsl:call-template name="string-replace">
					<xsl:with-param name="string" select="substring-after($string,$old-pattern)"/>
					<xsl:with-param name="old-pattern" select="$old-pattern"/>
					<xsl:with-param name="new-pattern" select="$new-pattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$string"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
