<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="../functions.xslt"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="dictionary|MetaData/SG:dictionary">
		<format>
			<xsl:for-each select="simple-type[@gen-consts and enumeration/option]">
				<item param.active-type-name="{@name}" slot.package="{$project-package}ui/dictionary" param.package="{$package-prefix}ui.dictionary" param.use-ui-types="true">
					<xsl:attribute name="slot.type">
						<xsl:value-of select="concat(substring(@name,1,1),translate(substring(@name,2,string-length(@name)-1),$upper-case,$lower-case))"/>
					</xsl:attribute>
				</item>
			</xsl:for-each>
		</format>
	</xsl:template>

</xsl:stylesheet>
