<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="../functions.xslt"/>
	<xsl:import href="common.xslt"/>

	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="MetaData">
		<format>
			<xsl:for-each select="//action[not(@SG:wrapper-specific)]">
				<item slot.service="{../../@name}" slot.aspect="{../@name}" param.active-service-name="{../../@name}" param.active-aspect-name="{../@name}" param.active-action-name="{@name}">
					<xsl:attribute name="slot.package">
						<xsl:apply-templates select="../.." mode="package"/>
					</xsl:attribute>
					<xsl:attribute name="slot.action">
						<xsl:call-template name="title-case">
							<xsl:with-param name="string" select="@name"/>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="slot.subaspect">
						<xsl:if test="not(../@primary)">
							<xsl:value-of select="../@name"/>
						</xsl:if>
					</xsl:attribute>
					<xsl:attribute name="slot.primary-aspect">
						<xsl:value-of select="../../aspect[@primary='true']/@name"/>
					</xsl:attribute>
				</item>
			</xsl:for-each>
		</format>
	</xsl:template>

</xsl:stylesheet>
