<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSPY v5 rel. 3 U (http://www.xmlspy.com) by shikh (spin) -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xalan="http://xml.apache.org/xalan" xmlns:UML="UML-NS">

	<xsl:import href="XMITemplate.xslt"/>

	<xsl:include href="XMI-simplify.xslt"/>
	<xsl:include href="XMIToDictionary-s.xslt"/>
	
	<xsl:template match="dictionary">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<xsl:template match="XMI">
		<xsl:variable name="xmi-simplified"><xsl:apply-templates select="." mode="simplify"/></xsl:variable>
		<xsl:apply-templates select="xalan:nodeset($xmi-simplified)/XMI.Simplified"/>
	</xsl:template>
	
	<xsl:template match="XMI1">
		<dictionary>
			<xsl:for-each select="$allclasses[key('stereo-type',@xmi.id)/../@name='type']">
				<xsl:if test="not(key('tagged-value',@xmi.id)[@tag='predefined'])">
					<xsl:apply-templates select="." mode="simple-type"/>
				</xsl:if>
			</xsl:for-each>
		</dictionary>
	</xsl:template>

	<xsl:template match="UML:Class" mode="original-type">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'originaltype'"/>
			</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="UML:Class" mode="simple-type">
		<xsl:variable name="class-id" select="@xmi.id"/>
		<xsl:variable name="format">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'format'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="maxlength">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'maxlength'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="dbDefault">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'dbDefault'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="minInclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'mininclusive'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="maxInclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'maxinclusive'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="minExclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'minexclusive'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="maxExclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'maxexclusive'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="location">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'location'"/>
			</xsl:call-template>
		</xsl:variable>
		<simple-type name="{@name}">
			<xsl:attribute name="base-type">
				<xsl:apply-templates select="." mode="original-type"/>
			</xsl:attribute>
			<xsl:attribute name="package">
				<xsl:call-template name="package"/>
			</xsl:attribute>
			<xsl:attribute name="notNull">
				<xsl:choose>
					<xsl:when test="key('tagged-value',$class-id)[@tag='notNull']">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:if test="key('tagged-value',$class-id)[@tag='genConsts']">
				<xsl:attribute name="gen-consts"/>
			</xsl:if>
			<xsl:if test="$dbDefault!=''">
				<xsl:attribute name="dbDefault"><xsl:value-of select="$dbDefault"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$minInclusive!=''">
				<xsl:attribute name="minInclusive"><xsl:value-of select="$minInclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$maxInclusive!=''">
				<xsl:attribute name="maxInclusive"><xsl:value-of select="$maxInclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$minExclusive!=''">
				<xsl:attribute name="minExclusive"><xsl:value-of select="$minExclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$maxExclusive!=''">
				<xsl:attribute name="maxExclusive"><xsl:value-of select="$maxExclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$format!=''">
				<xsl:attribute name="format"><xsl:value-of select="$format"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$maxlength!=''">
				<xsl:attribute name="maxlength"><xsl:value-of select="$maxlength"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$location!=''">
				<xsl:attribute name="location"><xsl:value-of select="$location"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="key('tagged-value',$class-id)[@tag='enumaration']">
				<xsl:attribute name="enum">true</xsl:attribute>
			</xsl:if>
			<xsl:if test="key('tagged-value',$class-id)[@tag='option']">
				<enumeration>
					<xsl:for-each select="key('tagged-value',$class-id)[@tag='option']">
						<option>
							<xsl:call-template name="option-value"/>
						</option>
					</xsl:for-each>
				</enumeration>
			</xsl:if>
			<xsl:if test="key('tagged-value',$class-id)[@tag='dboption']">
				<dbvalues>
					<xsl:for-each select="key('tagged-value',$class-id)[@tag='dboption']">
						<option>
							<xsl:call-template name="option-value"/>
						</option>
					</xsl:for-each>
				</dbvalues>
			</xsl:if>
		</simple-type>
	</xsl:template>

	<xsl:template name="option-value">
		<xsl:choose>
			<xsl:when test="contains(@value,';')">
				<xsl:attribute name="key">
					<xsl:value-of select="substring-before(@value,';')"/>
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="substring-after(@value,';')"/>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="key">
					<xsl:value-of select="@value"/>
				</xsl:attribute>
				<xsl:attribute name="value">
					<xsl:value-of select="@value"/>
				</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
