<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSPY v5 rel. 3 U (http://www.xmlspy.com) by shikh (spin) -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:UML="UML-NS">
	
	<xsl:template match="XMI.Simplified">
		<dictionary>
			<xsl:apply-templates select="XMI.content/UML:Model/Classes/UML:Class[@stereotype='type' and not(UML:TaggedValue[@tag='predefined'])]" mode="s-simple-type"/>
		</dictionary>
	</xsl:template>

	<xsl:template match="UML:Class" mode="s-simple-type">
		<xsl:variable name="format" select="UML:TaggedValue[@tag='format']"/>
		<xsl:variable name="maxlength" select="UML:TaggedValue[@tag='maxlength']"/>
		<xsl:variable name="dbDefault" select="UML:TaggedValue[@tag='dbDefault']"/>
		<xsl:variable name="minInclusive" select="UML:TaggedValue[@tag='mininclusive']"/>
		<xsl:variable name="maxInclusive" select="UML:TaggedValue[@tag='maxinclusive']"/>
		<xsl:variable name="minExclusive" select="UML:TaggedValue[@tag='minexclusive']"/>
		<xsl:variable name="maxExclusive" select="UML:TaggedValue[@tag='maxexclusive']"/>
		<xsl:variable name="location" select="UML:TaggedValue[@tag='location']"/>
		<simple-type name="{@name}" base-type="{UML:TaggedValue[@tag='originaltype']}" package="{@package}">
			<xsl:attribute name="notNull">
				<xsl:choose>
					<xsl:when test="UML:TaggedValue[@tag='notNull']">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:if test="UML:TaggedValue[@tag='genConsts']"><xsl:attribute name="gen-consts"/></xsl:if>
			<xsl:if test="$dbDefault!=''">
				<xsl:attribute name="dbDefault"><xsl:value-of select="$dbDefault"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$minInclusive!=''">
				<xsl:attribute name="minInclusive"><xsl:value-of select="$minInclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$maxInclusive!=''">
				<xsl:attribute name="maxInclusive"><xsl:value-of select="$maxInclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$minExclusive!=''">
				<xsl:attribute name="minExclusive"><xsl:value-of select="$minExclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$maxExclusive!=''">
				<xsl:attribute name="maxExclusive"><xsl:value-of select="$maxExclusive"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$format!=''">
				<xsl:attribute name="format"><xsl:value-of select="$format"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$maxlength!=''">
				<xsl:attribute name="maxlength"><xsl:value-of select="$maxlength"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$location!=''">
				<xsl:attribute name="location"><xsl:value-of select="$location"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="UML:TaggedValue[@tag='enumaration']">
				<xsl:attribute name="enum">true</xsl:attribute>
			</xsl:if>
			<xsl:if test="UML:TaggedValue[@tag='option']">
				<enumeration>
					<xsl:apply-templates select="UML:TaggedValue[@tag='option']" mode="s-option-value"/>
				</enumeration>
			</xsl:if>
			<xsl:if test="UML:TaggedValue[@tag='dboption']">
				<dbvalues>
					<xsl:apply-templates select="UML:TaggedValue[@tag='dboption']" mode="s-option-value"/>
				</dbvalues>
			</xsl:if>
		</simple-type>
	</xsl:template>

	<xsl:template match="UML:TaggedValue" mode="s-option-value">
		<option>
			<xsl:choose>
				<xsl:when test="contains(.,';')">
					<xsl:attribute name="key"><xsl:value-of select="substring-before(.,';')"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="substring-after(.,';')"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="key"><xsl:value-of select="."/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</option>
	</xsl:template>
	
</xsl:stylesheet>
