<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSPY v5 rel. 3 U (http://www.xmlspy.com) by shikh (spin) -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:UML="UML-NS" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="functions.xslt"/>

	<xsl:param name="primitive-type-wrappers" select="'#String#Date#Integer#Boolean#Double#'"/>
	<xsl:param name="diagram-name" select="''"/>

	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

	<xsl:key name="tagged-value" match="/XMI/XMI.content/UML:TaggedValue" use="UML:TaggedValue.modelElement/Foundation.Core.ModelElement/@xmi.idref"/>
	<xsl:key name="stereo-type" match="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype/UML:Stereotype.extendedElement" use="Foundation.Core.ModelElement/@xmi.idref"/>
	<xsl:key name="data-type" match="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:DataType" use="@xmi.id"/>
	<xsl:key name="class" match="UML:Class" use="@xmi.id"/>
	<xsl:key name="class-by-name" match="UML:Class" use="@name"/>
	<xsl:key name="generalizations" match="UML:Generalization" use="UML:Generalization.parent/Foundation.Core.GeneralizableElement/@xmi.idref"/>
	<xsl:key name="associations-by-source" match="UML:Association" use="UML:Association.connection/UML:AssociationEnd[1]/UML:AssociationEnd.type/Foundation.Core.Classifier/@xmi.idref"/>
	<xsl:key name="associations-by-target" match="UML:Association" use="UML:Association.connection/UML:AssociationEnd[2]/UML:AssociationEnd.type/Foundation.Core.Classifier/@xmi.idref"/>

	<xsl:variable name="model" select="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement"/>
	<xsl:variable name="diagram" select="/XMI/XMI.content/UML:Diagram[@name=$diagram-name and @diagramType='ClassDiagram']"/>
	<xsl:variable name="class-names">
		<xsl:text>#</xsl:text>
		<xsl:for-each select="//UML:Class">
			<xsl:variable name="class-id" select="@xmi.id"/>
			<xsl:if test="$diagram-name='' or not($diagram) or $diagram/UML:Diagram.element/UML:DiagramElement[UML:PresentationElement.subject/Foundation.Core.ModelElement/@xmi.idref=$class-id]">
				<xsl:value-of select="@xmi.id"/>
				<xsl:text>#</xsl:text>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="allclasses" select="//UML:Class[contains($class-names,concat('#',@xmi.id,'#'))]"/>
	<!--xsl:variable name="typeclasses" select="//UML:Class[key('stereo-type',@xmi.id)]"/-->
	
	<xsl:template name="tagged-value">
		<xsl:param name="element-id" select="@xmi.id"/>
		<xsl:param name="tag"/>
		<xsl:value-of select="key('tagged-value',$element-id)[@tag=$tag]/@value"/>
	</xsl:template>
	
	<xsl:template name="stereo-type">
		<xsl:param name="element-id" select="@xmi.id"/>
		<xsl:value-of select="key('stereo-type',$element-id)/../@name"/>
	</xsl:template>

	<xsl:template name="package">
		<xsl:for-each select="ancestor::UML:Package">
			<xsl:sort order="descending"/>
			<xsl:value-of select="@name"/>
			<xsl:if test="position()!=last()">.</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>
