<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:UML="UML-NS" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:variable name="model" select="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement"/>
	<xsl:key name="tagged-value" match="/XMI/XMI.content/UML:TaggedValue" use="UML:TaggedValue.modelElement/Foundation.Core.ModelElement/@xmi.idref"/>
	<xsl:key name="stereo-type" match="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:Stereotype/UML:Stereotype.extendedElement" use="Foundation.Core.ModelElement/@xmi.idref"/>
	<xsl:key name="data-type" match="/XMI/XMI.content/UML:Model/UML:Namespace.ownedElement/UML:DataType" use="@xmi.id"/>
	
	<xsl:template match="XMI">
		<xsl:apply-templates select="." mode="simplify"/>
	</xsl:template>
	
	<xsl:template match="XMI" mode="simplify">
		<XMI.Simplified>
			<xsl:call-template name="copy-attrs"/>
			<xsl:copy-of select="XMI.header"/>
			<XMI.content>
				<UML:Model>
					<xsl:call-template name="copy-attrs"/>
					<Classes>
						<xsl:for-each select="$model/UML:Class">
							<xsl:call-template name="class"/>
						</xsl:for-each>
						<xsl:for-each select="$model/UML:Package">
							<xsl:call-template name="package-content"/>
						</xsl:for-each>
					</Classes>
					<Associations>
						<xsl:for-each select="/XMI/XMI.content/UML:Model">
							<xsl:call-template name="associations"/>
						</xsl:for-each>
					</Associations>
				</UML:Model>
				<xsl:copy-of select="XMI.content/UML:Diagram"/>
			</XMI.content>
		</XMI.Simplified>
	</xsl:template>
	
	<xsl:template name="package-content">
		<xsl:param name="super-name" select="''"/>
		<xsl:variable name="name">
			<xsl:value-of select="$super-name"/>
			<xsl:if test="$super-name!=''">.</xsl:if>
			<xsl:value-of select="@name"/>
		</xsl:variable>
		<xsl:for-each select="UML:Namespace.ownedElement/UML:Class">
			<xsl:call-template name="class">
				<xsl:with-param name="package-name" select="$name"/>
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="UML:Namespace.ownedElement/UML:Package">
			<xsl:call-template name="package-content">
				<xsl:with-param name="super-name" select="$name"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="class">
		<xsl:param name="package-name" select="''"/>
		<UML:Class package="{$package-name}">
			<xsl:attribute name="full-name">
				<xsl:value-of select="$package-name"/>
				<xsl:if test="$package-name!=''">.</xsl:if>
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:call-template name="copy-attrs"/>
			<xsl:call-template name="s-stereo-type"/>
			<xsl:for-each select="UML:Namespace.ownedElement[UML:Generalization]">
				<xsl:attribute name="parent"><xsl:value-of select="UML:Generalization/UML:Generalization.parent/Foundation.Core.GeneralizableElement/@xmi.idref"/></xsl:attribute>
			</xsl:for-each>
			<xsl:call-template name="tagged-values"/>
			<xsl:for-each select="UML:Classifier.feature/UML:Operation">
				<UML:Operation>
					<xsl:call-template name="copy-attrs"/>
					<xsl:call-template name="s-stereo-type"/>
					<xsl:attribute name="return">
						<xsl:choose>
							<xsl:when test="UML:BehavioralFeature.parameter/UML:Parameter[@kind='return']">
								<xsl:value-of select="key('data-type',UML:BehavioralFeature.parameter/UML:Parameter[@kind='return']/UML:Parameter.type/Foundation.Core.Classifier/@xmi.idref)/@name"/>
							</xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<xsl:call-template name="tagged-values"/>
					<xsl:for-each select="UML:BehavioralFeature.parameter/UML:Parameter[@kind!='return']">
						<UML:Parameter>
							<xsl:attribute name="type">
								<xsl:value-of select="key('data-type',UML:Parameter.type/Foundation.Core.Classifier/@xmi.idref)/@name"/>
							</xsl:attribute>
							<xsl:attribute name="type-id">
								<xsl:value-of select="UML:Parameter.type/Foundation.Core.Classifier/@xmi.idref"/>
							</xsl:attribute>
							<xsl:call-template name="copy-attrs"/>
							<xsl:call-template name="s-stereo-type"/>
							<xsl:call-template name="tagged-values"/>
						</UML:Parameter>
					</xsl:for-each>
				</UML:Operation>
			</xsl:for-each>
			<xsl:for-each select="UML:Classifier.feature/UML:Attribute">
				<UML:Attribute>
					<xsl:call-template name="copy-attrs"/>
					<xsl:call-template name="s-stereo-type"/>
					<xsl:attribute name="type">
						<xsl:value-of select="key('data-type',UML:StructuralFeature.type/Foundation.Core.Classifier/@xmi.idref)/@name"/>
					</xsl:attribute>
					<xsl:call-template name="tagged-values"/>
				</UML:Attribute>
			</xsl:for-each>
		</UML:Class>
	</xsl:template>
	
	<xsl:template name="associations">
		<xsl:for-each select="UML:Namespace.ownedElement/UML:Association">
			<UML:Association source="{UML:Association.connection/UML:AssociationEnd[1]/UML:AssociationEnd.type/Foundation.Core.Classifier/@xmi.idref}" target="{UML:Association.connection/UML:AssociationEnd[2]/UML:AssociationEnd.type/Foundation.Core.Classifier/@xmi.idref}">
				<xsl:call-template name="copy-attrs"/>
				<xsl:call-template name="s-stereo-type"/>
				<xsl:call-template name="tagged-values"/>
			</UML:Association>
		</xsl:for-each>
		<xsl:for-each select="UML:Namespace.ownedElement/UML:Package">
			<xsl:call-template name="associations"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="copy-attrs">
		<xsl:for-each select="@*">
			<xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
		</xsl:for-each>
	</xsl:template>

	<!--xsl:template name="tagged-values">
		<xsl:param name="element-id" select="@xmi.id"/>
		<xsl:for-each select="/XMI/XMI.content/UML:TaggedValue[UML:TaggedValue.modelElement/Foundation.Core.ModelElement/@xmi.idref=$element-id]">
			<UML:TaggedValue tag="{@tag}"><xsl:value-of select="@value"/></UML:TaggedValue>
		</xsl:for-each>
	</xsl:template-->
	
	<xsl:template name="tagged-values">
		<xsl:param name="element-id" select="@xmi.id"/>
		<xsl:for-each select="key('tagged-value',$element-id)">
			<UML:TaggedValue tag="{@tag}"><xsl:value-of select="@value"/></UML:TaggedValue>
		</xsl:for-each>
	</xsl:template>
	
	<!--xsl:template name="stereo-type">
		<xsl:param name="element-id" select="@xmi.id"/>
		<xsl:attribute name="UML:Stereotype">
			<xsl:value-of select="$model/UML:Stereotype[UML:Stereotype.extendedElement[Foundation.Core.ModelElement/@xmi.idref=$element-id]]/@name"/>
		</xsl:attribute>
	</xsl:template-->

	<xsl:template name="s-stereo-type">
		<xsl:param name="element-id" select="@xmi.id"/>
		<xsl:variable name="stereo-type" select="key('stereo-type',$element-id)/../@name"/>
		<xsl:if test="$stereo-type!=''">
			<xsl:attribute name="stereotype">
				<xsl:value-of select="$stereo-type"/>
			</xsl:attribute>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
