<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:param name="model-name"/>
	<xsl:param name="collection-classes" select="'#Collection#ArrayList#Set#SortedSet#SortedList#List#Vector#'"/>
	<xsl:param name="simple-types" select="'#STRING#DATE#INTEGER#BOOLEAN#DOUBLE#DECIMAL#TIME#TIMESTAMP#'"/>
	<xsl:param name="readonly-props" select="'#guid#createdAt#lastChangedAt#createdBy#lastChangedBy#'"/>

	<xsl:template name="class-package">
		<xsl:apply-templates select="." mode="package"/>
	</xsl:template>
	
	<xsl:template match="aspect" mode="package">
		<xsl:call-template name="revert">
			<xsl:with-param name="path" select="../application/@provider"/>
		</xsl:call-template>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="../application/@id"/>
		<xsl:text>.services.</xsl:text>
		<xsl:value-of select="translate($model-name,$upper-case,$lower-case)"/>
		<xsl:text>.</xsl:text>
		<xsl:if test="not(@primary='true')">
			<xsl:value-of select="concat(translate(../aspect[@primary='true']/@name,$upper-case,$lower-case),'.')"/>
		</xsl:if>
		<xsl:value-of select="translate(@name,$upper-case,$lower-case)"/>
	</xsl:template>
	
	<xsl:template match="query" mode="package">
		<xsl:variable name="aspect" select="@aspect"/>
		<xsl:choose>
			<xsl:when test="../aspect[@name=$aspect]">
				<xsl:apply-templates select="../aspect[@name=$aspect]" mode="package"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="../aspect[@primary='true']" mode="package"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="action" mode="package">
		<xsl:apply-templates select=".." mode="package"/>
	</xsl:template>

	<xsl:template name="modelclass-parent">
		<ModelClass.Parent>
			<Core.Reference package="{$package-prefix}services.{translate($model-name,$upper-case,$lower-case)}" name="{$model-name}" type="Model"/>
		</ModelClass.Parent>
	</xsl:template>
	
	<xsl:template match="aspect" mode="modelclass-aspect">
		<xsl:value-of select="concat('A',@name)"/>
	</xsl:template>
	
	<xsl:template match="query" mode="modelclass-query">
		<xsl:text>Q</xsl:text>
		<xsl:value-of select="../@name"/>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="@name"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="query" mode="modelclass-queryIP">
		<xsl:text>P</xsl:text>
		<xsl:value-of select="../@name"/>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="@name"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="action" mode="modelclass-action">
		<xsl:text>C</xsl:text>
		<xsl:value-of select="../../@name"/>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="@name"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="action" mode="modelclass-actionIP">
		<xsl:text>P</xsl:text>
		<xsl:value-of select="../../@name"/>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="@name"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="property-type">
		<xsl:param name="type" select="@type"/>
		<xsl:choose>
			<xsl:when test="@custom_type">
				<Property.Type>
					<xsl:call-template name="custom-type">
						<xsl:with-param name="type" select="@custom_type"/>
					</xsl:call-template>
				</Property.Type>
			</xsl:when>
			<xsl:when test="contains($simple-types,concat('#',translate($type,$lower-case,$upper-case),'#'))">
				<Property.Type>
					<xsl:call-template name="simple-type">
						<xsl:with-param name="type" select="$type"/>
					</xsl:call-template>
				</Property.Type>
			</xsl:when>
			<xsl:otherwise>
				<Property.NativeType>
					<xsl:call-template name="java-native-type">
						<xsl:with-param name="type" select="$type"/>
					</xsl:call-template>
				</Property.NativeType>
				<Property.Type>
					<Core.Reference path="Property:{@name}/NativeType"/>
				</Property.Type>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="custom-type">
		<xsl:param name="type"/>
		<xsl:variable name="name">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="string" select="$type"/>
				<xsl:with-param name="substring" select="'.'"/>
			</xsl:call-template>
		</xsl:variable>
		<Core.ForeignReference modelName="DtDictionary" type="DtSimpleType" package="{substring($type,1,string-length($type)-string-length($name)-1)}" name="{$name}"/>
	</xsl:template>
	
	<xsl:template name="simple-type">
		<xsl:param name="type"/>
		<Core.ForeignReference modelName="DtDictionary" type="DtSimpleType">
			<xsl:attribute name="name">
				<xsl:value-of select="translate($type,$upper-case,$lower-case)"/>
			</xsl:attribute>
			<xsl:attribute name="package">
				<xsl:call-template name="revert">
					<xsl:with-param name="path" select="ancestor::coolservice[1]/application/@provider"/>
				</xsl:call-template>
				<xsl:text>.dictionary</xsl:text>
			</xsl:attribute>
		</Core.ForeignReference>
	</xsl:template>
	
	<xsl:template name="java-native-type">
		<xsl:param name="type"/>
		<xsl:variable name="class-name">
			<xsl:choose>
				<xsl:when test="contains($collection-classes,concat('#',$type,'#'))">
					<xsl:value-of select="concat('java.util.',substring($type,1,1),translate(substring($type,2,string-length($type)-1),$upper-case,$lower-case))"/>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="name">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="string" select="$class-name"/>
				<xsl:with-param name="substring" select="'.'"/>
			</xsl:call-template>
		</xsl:variable>
		<JavaNativeType javaPackage="{substring($class-name,1,string-length($class-name)-string-length($name)-1)}" name="{$name}"/>
	</xsl:template>
	
</xsl:stylesheet>
