<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="AspectTemplate.xslt"/>
	<xsl:import href="WDModelCommon.xslt"/>
	<xsl:template match="aspect">
		<ModelClass xmlns="http://xml.sap.com/2002/10/metamodel/webdynpro" xmlns:IDX="urn:sap.com:WebDynpro.ModelClass:2.0" mmRelease="6.30" mmVersion="2.0" mmTimestamp="1063375387072" masterLanguage="en">
			<xsl:attribute name="package">
				<xsl:apply-templates select="." mode="package"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:apply-templates select="." mode="modelclass-aspect"/>
			</xsl:attribute>
			<xsl:call-template name="modelclass-parent"/>
			<ModelClass.Properties>
				<xsl:apply-templates select="property"/>
			        <ModelClassProperty xmlns="" name="guid" readonly="true">
			            <Property.Type>
				            <Core.ForeignReference name="id" package="com.sap.caf.core" type="DtSimpleType" modelName="DtDictionary"/>
			            </Property.Type>
			        </ModelClassProperty>
			</ModelClass.Properties>
		</ModelClass>
	</xsl:template>

	<xsl:template match="property">
	        <xsl:if test="not(@name='key')">
		<ModelClassProperty name="{@name}">
			<xsl:if test="@SG:visibility='protected' or contains($readonly-props,concat('#',@name,'#'))">
				<xsl:attribute name="readonly">true</xsl:attribute>
			</xsl:if>
			<xsl:call-template name="property-type"/>
		</ModelClassProperty>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
