<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="functions.xslt"/>
	<xsl:import href="WDModelCommon.xslt"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:param name="model-name"/>
	<xsl:template match="sources">
		<Model xmlns="http://xml.sap.com/2002/10/metamodel/webdynpro" xmlns:IDX="urn:sap.com:WebDynpro.Model:2.0" mmRelease="6.30" mmVersion="2.0" mmTimestamp="1063375387072" name="{$model-name}" package="{$package-prefix}services" masterLanguage="en">
			<!--test>
				<xsl:copy-of select="."/>
			</test-->
			<Model.ModelClasses>
				<xsl:for-each select=".//aspect[not(@key='true')]">
					<Core.Reference type="ModelClass">
						<xsl:attribute name="package">
							<xsl:apply-templates select="." mode="package"/>
						</xsl:attribute>
						<xsl:attribute name="name">
							<xsl:apply-templates select="." mode="modelclass-aspect"/>
						</xsl:attribute>
					</Core.Reference>
				</xsl:for-each>
				<xsl:for-each select=".//query[not(@SG:CAF-specific)]">
					<xsl:variable name="package">
						<xsl:apply-templates select="." mode="package"/>
					</xsl:variable>
					<Core.Reference type="ModelClass" package="{$package}">
						<xsl:attribute name="name">
							<xsl:apply-templates select="." mode="modelclass-query"/>
						</xsl:attribute>
					</Core.Reference>
					<Core.Reference type="ModelClass" package="{$package}">
						<xsl:attribute name="name">
							<xsl:apply-templates select="." mode="modelclass-queryIP"/>
						</xsl:attribute>
					</Core.Reference>
				</xsl:for-each>
				<xsl:for-each select=".//action[not(@SG:wrapper-specific='true')]">
					<xsl:variable name="package">
						<xsl:apply-templates select="." mode="package"/>
					</xsl:variable>
					<Core.Reference type="ModelClass" package="{$package}">
						<xsl:attribute name="name">
							<xsl:apply-templates select="." mode="modelclass-action"/>
						</xsl:attribute>
					</Core.Reference>
					<Core.Reference type="ModelClass" package="{$package}">
						<xsl:attribute name="name">
							<xsl:apply-templates select="." mode="modelclass-actionIP"/>
						</xsl:attribute>
					</Core.Reference>
				</xsl:for-each>
			</Model.ModelClasses>
			<Model.ModelRelations>
				<xsl:for-each select=".//coolservice">
					<xsl:apply-templates select="aspect[@key='true']/aspectrelation[not(@SG:indirect='true')]"/>
					<xsl:apply-templates select="query[not(@SG:CAF-specific)]" mode="relation"/>
					<xsl:apply-templates select=".//action[not(@SG:wrapper-specific='true')]" mode="relation"/>
				</xsl:for-each>
			</Model.ModelRelations>
			<Model.Settings>
				<ModelSetting name="requiresCodeGeneration" value="false">
					<ModelSetting.SettingDefinition>
						<Core.Reference package="com.sap.ide.webdynpro.modeltypes" name="ReverseEngineered" type="ModelType" path="ModelSettingDefinition:requiresCodeGeneration"/>
					</ModelSetting.SettingDefinition>
				</ModelSetting>
			</Model.Settings>
			<Model.ModelType>
				<Core.Reference package="com.sap.ide.webdynpro.modeltypes" name="ReverseEngineered" type="ModelType"/>
			</Model.ModelType>
		</Model>
	</xsl:template>
	
	<xsl:template match="aspectrelation">
		<xsl:variable name="client-role">
			<xsl:choose>
				<xsl:when test="@SG:clientRole!=''">
					<xsl:value-of select="@SG:clientRole"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat(@name,'Back')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="source-aspect" select="ancestor::coolservice/aspect[@primary='true']/@name"/>
		<xsl:variable name="target-service">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="string" select="@targetservice"/>
				<xsl:with-param name="substring" select="'.'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="target-aspect" select="@targetaspect"/>
		<xsl:variable name="source-service" select="ancestor::coolservice/@name"/>

		<xsl:variable name="source-class">
			<xsl:apply-templates select="ancestor::coolservice/aspect[@primary='true']" mode="modelclass-aspect"/>
		</xsl:variable>
		<xsl:variable name="target-class">
			<xsl:apply-templates select="//coolservice[@name=$target-service]/aspect[@name=$target-aspect]" mode="modelclass-aspect"/>
		</xsl:variable>
		<ModelRelation name="{$source-class}.{@name}:{$target-class}.{$client-role}">
			<ModelRelation.ModelRelationRoles>
				<ModelRelationRole name="{@name}">
					<xsl:attribute name="cardinality">
						<xsl:call-template name="cardinality">
							<xsl:with-param name="cardinality" select="@cardinality"/>
						</xsl:call-template>
					</xsl:attribute>
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$target-class}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="//coolservice[@name=$target-service]/aspect[@name=$target-aspect]" mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
				<ModelRelationRole name="{$client-role}">
					<xsl:attribute name="cardinality">
						<xsl:call-template name="cardinality">
							<xsl:with-param name="cardinality" select="@SG:clientcardinality"/>
						</xsl:call-template>
					</xsl:attribute>
					<xsl:if test="not(//aspect[@key='true' and aspectrelation[ancestor::coolservice/@name=$target-service and @targetaspect=$source-aspect and @targetservice=$source-service and @SG:indirect='true']])">
						<xsl:attribute name="navigable">false</xsl:attribute>
					</xsl:if>
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$source-class}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="ancestor::coolservice/aspect[@primary='true']" mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
			</ModelRelation.ModelRelationRoles>
		</ModelRelation>
	</xsl:template>
	
	<xsl:template match="query" mode="relation">
		<!--xsl:variable name="query-aspect" select="@aspect"/-->
		<xsl:variable name="source-aspect">
			<xsl:apply-templates select="." mode="modelclass-query"/>
		</xsl:variable>
		<xsl:variable name="target-ip-aspect">
			<xsl:apply-templates select="." mode="modelclass-queryIP"/>
		</xsl:variable>
		<xsl:variable name="relation-ip-name">InputParameter</xsl:variable>
		<ModelRelation name="{$source-aspect}.{$relation-ip-name}:{$target-ip-aspect}.{$source-aspect}">
			<ModelRelation.ModelRelationRoles>
				<ModelRelationRole name="{$relation-ip-name}" cardinality="_1_1">
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$target-ip-aspect}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="." mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
				<ModelRelationRole name="{$source-aspect}" cardinality="_1_1">
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$source-aspect}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="." mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
			</ModelRelation.ModelRelationRoles>
		</ModelRelation>
		<xsl:variable name="relation-r-name">Result</xsl:variable>
		<xsl:variable name="target-r-aspect" select="@aspect"/>
		<xsl:variable name="target-r-class">
			<xsl:apply-templates select="//aspect[@name=$target-r-aspect]" mode="modelclass-aspect"/>
		</xsl:variable>
		<ModelRelation name="{$source-aspect}.{$relation-r-name}:{$target-r-class}.{$source-aspect}">
			<ModelRelation.ModelRelationRoles>
				<ModelRelationRole name="{$relation-r-name}" cardinality="_0_n">
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$target-r-class}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="//aspect[@name=$target-r-aspect]" mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
				<ModelRelationRole name="{$source-aspect}" cardinality="_1_1" navigable="false">
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$source-aspect}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="." mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
			</ModelRelation.ModelRelationRoles>
		</ModelRelation>
	</xsl:template>
	
	<xsl:template match="action" mode="relation">
		<xsl:variable name="source-aspect">
			<xsl:apply-templates select="." mode="modelclass-action"/>
		</xsl:variable>
		<xsl:variable name="target-ip-aspect">
			<xsl:apply-templates select="." mode="modelclass-actionIP"/>
		</xsl:variable>
		<xsl:variable name="relation-ip-name">InputParameterStructure</xsl:variable>
		<ModelRelation name="{$source-aspect}.{$relation-ip-name}:{$target-ip-aspect}.{$source-aspect}">
			<ModelRelation.ModelRelationRoles>
				<ModelRelationRole name="{$relation-ip-name}" cardinality="_1_1">
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$target-ip-aspect}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="." mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
				<ModelRelationRole name="{$source-aspect}" cardinality="_1_1">
					<ModelRelationRole.ModelClass>
						<Core.Reference type="ModelClass" name="{$source-aspect}">
							<xsl:attribute name="package">
								<xsl:apply-templates select="." mode="package"/>
							</xsl:attribute>
						</Core.Reference>
					</ModelRelationRole.ModelClass>
				</ModelRelationRole>
			</ModelRelation.ModelRelationRoles>
		</ModelRelation>
	</xsl:template>
	
	<xsl:template name="cardinality">
		<xsl:param name="cardinality"/>
		<xsl:choose>
			<xsl:when test="$cardinality=''">_1_1</xsl:when>
			<xsl:otherwise><xsl:value-of select="concat('_',substring($cardinality,1,1),'_',substring($cardinality,4,1))"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
