<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="ServiceModule.xslt"/>
	<xsl:import href="JavaTemplate.xslt"/>
	<xsl:import href="AspectTemplate.xslt"/>
	<xsl:import href="WDModelCommon.xslt"/>
	
	<xsl:variable name="class-declaration-prefix" select="'public final class '"/>
	<xsl:variable name="class-declaration-suffix" select="'Utils'"/>
	
	<xsl:variable name="aspect-id">
		<xsl:call-template name="java-id">
			<xsl:with-param name="id" select="$aspect-name"/>
		</xsl:call-template>
	</xsl:variable>
	
	<xsl:template name="class-imports">
		<xsl:text>import java.io.ObjectStreamException;
import java.io.Serializable;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;

import com.sap.tc.webdynpro.services.session.IScope;
import com.sap.tc.webdynpro.services.session.IMaintainScope;
import com.sap.tc.webdynpro.services.session.IScopeListener;
import com.sap.tc.webdynpro.services.session.Utils;

import com.sap.tc.webdynpro.services.task.ITask;
import com.sap.tc.webdynpro.services.task.TaskBinder;

import </xsl:text><xsl:value-of select="$package-prefix"/><xsl:text>common.cool.api.CAFServiceFactory;
import </xsl:text><xsl:value-of select="$package-prefix"/><xsl:text>services.</xsl:text>
		<xsl:value-of select="concat(translate($model-name,$upper-case,$lower-case),'.',$model-name)"/>
		<xsl:text>Definition;

</xsl:text>
	</xsl:template>
	
	<xsl:template name="class-content">
		<xsl:if test="property[@name='guid']">
			<xsl:call-template name="key-to-guid"/>
		</xsl:if>
		<xsl:call-template name="key-to-aspect"/>
		<xsl:if test="following-sibling::aspect[property[@name='guid']]">
			<xsl:call-template name="guid-to-key"/>
			<xsl:call-template name="guid-to-aspect"/>
		</xsl:if>
		<xsl:call-template name="class-constructors"/>
		<xsl:call-template name="module"/>
	</xsl:template>
	
	<xsl:template name="guid-to-key">
		<xsl:text>	public static IKey cast(final String guid)
	{	
		final IServiceModule module = serviceModule();
		final IKey           key    = module.createKey
		(
			</xsl:text>
			<xsl:value-of select="$model-name"/>
			<xsl:text>Definition.</xsl:text>
			<xsl:apply-templates select="../aspect[@key='true']" mode="const-name"/>
			<xsl:text>,
			new String[]{ guid }
		);

		return key;
	}
	
</xsl:text>
	</xsl:template>
	
	<xsl:template name="key-to-guid">
		<xsl:text>	public static String cast(final IKey key)
	{	
		return </xsl:text><xsl:value-of select="$aspect-id"/><xsl:text>ByKey( key ).getGuid();
	}
	
</xsl:text>
	</xsl:template>
	
	<xsl:template name="guid-to-aspect">
		<xsl:text>	public static </xsl:text>
		<xsl:apply-templates  select="." mode="modelclass-aspect"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="$aspect-id"/>
		<xsl:text>ByGuid( final String guid )
	{	
		return </xsl:text><xsl:value-of select="$aspect-id"/><xsl:text>ByKey( cast(guid) );
	}
	
</xsl:text>
	</xsl:template>
	
	<xsl:template name="key-to-aspect">
		<xsl:text>	public static </xsl:text>
		<xsl:apply-templates  select="." mode="modelclass-aspect"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="$aspect-id"/>
		<xsl:text>ByKey( final IKey key )
	{
		final IServiceModule module = serviceModule();
		final IKeyList       keys   = module.createKeyList( </xsl:text>
		<xsl:value-of select="$model-name"/>
		<xsl:text>Definition.</xsl:text>
		<xsl:apply-templates select="../aspect[@key='true']" mode="const-name"/>
		<xsl:text> );
		keys.add( key ); 
		final IAspect        aspect = module.getAspect(</xsl:text>
		<xsl:value-of select="$model-name"/>
		<xsl:text>Definition.</xsl:text>
		<xsl:apply-templates select="." mode="const-name"/>
		<xsl:text>, keys);

		return (</xsl:text><xsl:apply-templates  select="." mode="modelclass-aspect"/><xsl:text>)aspect.getAspectRow( 0 ) ;
	}
	
</xsl:text>
	</xsl:template>
	
	<xsl:template name="class-constructors">
		<xsl:text>	private </xsl:text><xsl:value-of select="@name"/><xsl:text>Utils() {}
	
</xsl:text>
	</xsl:template>
	
	<xsl:template name="module">
		<xsl:text>	private static IServiceModule serviceModule()
	{
		final ITask  task  = TaskBinder.getCurrentTask(); 
		final IScope scope = task.getScope();
		
		IServiceModule srvcModule = (IServiceModule)scope.get( SERVICE_MODULE_KEY );
		if ( null == srvcModule )
		{
			final IServiceFacade srvc = CAFServiceFactory.getService(</xsl:text><xsl:value-of select="$model-name"/><xsl:text>Definition.class);
			srvcModule = srvc.getServiceModule(</xsl:text><xsl:value-of select="$model-name"/><xsl:text>Definition.</xsl:text><xsl:apply-templates select=".." mode="const-name"/><xsl:text>);
			scope.put(SERVICE_MODULE_KEY, srvcModule);
			
 			final IScopeListener onDestroyTask = new IScopeListener()
 			{ 
 				final public void scopeToBeDestroyed(final IMaintainScope maintainScope)
 				{
 					maintainScope.getScope().remove( SERVICE_MODULE_KEY );
 					task.unregisterToBeDestroyedListener( this );
 				}
 			};
 			task.registerToBeDestroyedListener( onDestroyTask );
		}
		return srvcModule;
	}
	
	final private static Object SERVICE_MODULE_KEY = new Serializable()
	{
		private Object readResolve() throws ObjectStreamException
		{
			return SERVICE_MODULE_KEY;
		}
	};

</xsl:text>
	</xsl:template>
	
	<xsl:template name="module1">
		<xsl:text>	final private static ThreadLocal Module = new ThreadLocal()
	{ 
		protected Object initialValue()
		{
			final IServiceFacade srvc   = CAFServiceFactory.getService(</xsl:text><xsl:value-of select="$model-name"/><xsl:text>Definition.class);
			final IServiceModule module = srvc.getServiceModule(</xsl:text>
			<xsl:value-of select="$model-name"/>
			<xsl:text>Definition.</xsl:text>
			<xsl:apply-templates select=".." mode="const-name"/>
			<xsl:text>);
			
			return module;
		}
	};

</xsl:text>
	</xsl:template>
	
</xsl:stylesheet>
