<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:template name="type-access-imports">import java.util.*;

import com.sap.caf.rt.ui.cool.generic.ServiceFacade;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.tc.cmi.metadata.ICMIModelClassPropertyInfo;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.LockStrategy;

import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ISimpleValueSet;

</xsl:template>

	<xsl:template name="type-access-internalCoding">
		<xsl:text>	public ISimpleType getDataType(String serviceName, String aspectName, String propertyName) throws ServiceException {
		try {
			final IServiceFacade serviceFacade = new ServiceFacade(Locale.getDefault());
			final IServiceModule serviceModule = serviceFacade.getServiceModule(serviceName);
			
			final IAspect aspect = serviceModule.createAspect(aspectName);
			ICMIModelClassPropertyInfo prop_info = aspect.associatedModelObjectCollectionInfo()
											.getElementModelClassInfo()
											.getPropertyInfo(propertyName);
			return prop_info.getDataType().isSimpleType() ? 
				(ISimpleType) prop_info.getDataType() : null;
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new ServiceException(ex);
		}
	}

</xsl:text>
	</xsl:template>

	<xsl:template name="type-access-provideTypeValues">
		<xsl:variable name="mname" select="@name"/>
		<xsl:variable name="provider">
			<xsl:call-template name="revert">
				<xsl:with-param name="path" select="../application/@provider"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="application" select="../application/@id"/>

		<xsl:variable name="datatypespackage"><xsl:value-of select="$provider"/>.<xsl:value-of select="$application"/>.appsrv.datatypes</xsl:variable>

		<xsl:variable name="t-aspect" select="../query[@name=$mname]/@aspect"/>
		<xsl:variable name="a" select="../aspect[@name=$t-aspect]"/>
		<xsl:if test="$a">
			<xsl:variable name="type-name" select="$a/@SG:type-name"/>
			<xsl:variable name="type-package" select="$a/@SG:type-package"/>
			<xsl:variable name="AName" select="$a/@name"/>
			<xsl:variable name="type-full-name">
				<xsl:value-of select="$type-package"/>
				<xsl:if test="$type-package!=''">.</xsl:if>
				<xsl:value-of select="$type-name"/>
			</xsl:variable>
			<xsl:variable name="r-property" select="//property[@custom_type=$type-full-name]"/>
			<xsl:for-each select="$r-property[1]">
				<xsl:variable name="backend-type">
					<xsl:choose>
						<xsl:when test="@SG:enumeration"><xsl:value-of select="@SG:enumeration"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="@type"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:text/>		ISimpleType sType = getDataType("<xsl:call-template name="service-name"/>", "<xsl:value-of select="../@name"/>", "<xsl:value-of select="@name"/>");
		retValue = new ArrayList();
		if (sType != null) {
			ISimpleValueServices svServices = sType.getSVServices();
			ISimpleValueSet vs = svServices.getValues();
			if (vs != null)
				for (Iterator it = vs.keySet().iterator(); it.hasNext(); ) {
<!--					<xsl:apply-templates select="$a" mode="datastructure"/> vbean = new <xsl:apply-templates select="$a" mode="datastructure"/>();
-->
					<xsl:value-of select="$datatypespackage"/>.<xsl:value-of select="$AName"/>DS vbean = new <xsl:value-of select="$datatypespackage"/>.<xsl:value-of select="$AName"/>DS();
					Object value = it.next();
					if (value != null) {
						vbean.setProperty("backendValue", <xsl:if test="$backend-type!='String'">value instanceof String ? <xsl:value-of select="$backend-type"/>.valueOf((String) value) : </xsl:if>value);
						vbean.setProperty("frontendValue", <xsl:if test="@type!='String'">value instanceof String ? <xsl:value-of select="@type"/>.valueOf((String) value) : </xsl:if><xsl:text>value);
					}
					else {
						vbean.setProperty("backendValue", null);
						vbean.setProperty("frontendValue", null);
					}
					retValue.add(vbean);
				}
		}
</xsl:text>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
