<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="JavaTemplate.xslt"/>
	<xsl:import href="functions.xslt"/>
	<xsl:import href="WDModelCommon.xslt"/>

	<xsl:template name="class-package">
		<xsl:value-of select="$package-prefix"/>
		<xsl:text>services.</xsl:text>
		<xsl:value-of select="translate($model-name,$upper-case,$lower-case)"/>
	</xsl:template>

	<xsl:template name="class-imports">
		<xsl:text>import </xsl:text><xsl:value-of select="$package-prefix"/><xsl:text>services.core.CoreCAFModelDefinition;

</xsl:text>
	</xsl:template>

	<xsl:template name="class-declaration">
		<xsl:text>public class </xsl:text>
		<xsl:value-of select="$model-name"/>
		<xsl:text>Definition extends CoreCAFModelDefinition</xsl:text>
	</xsl:template>
	
	<xsl:template name="class-content">
		<xsl:call-template name="class-consts"/>
		<xsl:call-template name="method-init"/>
	</xsl:template>
	
	<xsl:template name="class-consts">
		<xsl:for-each select=".//coolservice">
			<xsl:variable name="s-name" select="aspect[@primary='true']/@name"/>
			<xsl:if test="not(../coolservice[aspect[@name=concat($s-name,'AS') and @SG:parent=$s-name]])">
				<xsl:text>	public static final String </xsl:text>
				<xsl:apply-templates select="." mode="const-name"/>
				<xsl:text> = "</xsl:text>
				<xsl:apply-templates select="." mode="service-name"/>
				<xsl:text>";
</xsl:text>
				<xsl:for-each select="aspect">
					<xsl:text>	public static final String </xsl:text>
					<xsl:apply-templates select="." mode="const-name"/>
					<xsl:text> = "</xsl:text>
					<xsl:apply-templates select="." mode="aspect-name"/>
					<xsl:text>";
</xsl:text>
				</xsl:for-each>
				<xsl:for-each select="query[not(@SG:CAF-specific)]">
					<xsl:text>	public static final String </xsl:text>
					<xsl:apply-templates select="." mode="const-name"/>
					<xsl:text> = "</xsl:text>
					<xsl:value-of select="@name"/>
					<xsl:text>";
</xsl:text>
				</xsl:for-each>
				<xsl:for-each select=".//action[not(@SG:wrapper-specific)]">
					<xsl:text>	public static final String </xsl:text>
					<xsl:apply-templates select="." mode="const-name"/>
					<xsl:text> = "</xsl:text>
					<xsl:value-of select="@name"/>
					<xsl:text>";
</xsl:text>
				</xsl:for-each>
				<xsl:value-of select="$crlf"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="method-init">
		<xsl:text>	protected void init ()
	{
</xsl:text>

		<xsl:for-each select=".//coolservice">
			<xsl:for-each select="aspect[not(@key='true')]">
				<xsl:call-template name="register-aspect"/>
			</xsl:for-each>
			<xsl:for-each select="query[not(@SG:CAF-specific) and not(@SG:wrapper-specific)]">
				<xsl:call-template name="register-query"/>
				<xsl:call-template name="register-queryIP"/>
			</xsl:for-each>
			<xsl:for-each select=".//action[not(@SG:wrapper-specific) and not(@SG:CAF-specific)]">
				<xsl:variable name="aname" select="@name"/>
				<xsl:variable name="aspect" select="../@SG:parent"/>
				<xsl:if test="not(//aspect[@name=$aspect and action[@name=$aname]])">
					<xsl:call-template name="register-action"/>
					<xsl:call-template name="register-actionIP"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>

		<xsl:text>	}

</xsl:text>
	</xsl:template>
	
	<xsl:template name="register-aspect">
		<xsl:text>		registerAspectRowImpl(</xsl:text>
		<xsl:apply-templates select=".." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="package"/>
		<xsl:text>.</xsl:text>
		<xsl:apply-templates select="." mode="modelclass-aspect"/>
		<xsl:text>.class);

</xsl:text>
		<xsl:variable name="bad-bo"><xsl:apply-templates select=".." mode="bad-bo"/></xsl:variable>
		<xsl:if test="$bad-bo!=''">
			<xsl:text>		registerAspectRowImpl("</xsl:text>
			<xsl:value-of select="../application/@provider"/>/<xsl:value-of select="../application/@id"/>/<xsl:value-of select="../@name"/>
			<xsl:text>", </xsl:text>
			<xsl:apply-templates select="." mode="const-name"/>
			<xsl:text>, </xsl:text>
			<xsl:apply-templates select="." mode="package"/>
			<xsl:text>.</xsl:text>
			<xsl:apply-templates select="." mode="modelclass-aspect"/>
			<xsl:text>.class);

</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="register-query">
		<xsl:text>		registerQueryImpl(</xsl:text>
		<xsl:apply-templates select=".." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="package"/>
		<xsl:text>.</xsl:text>
		<xsl:apply-templates select="." mode="modelclass-query"/>
		<xsl:text>.class);

</xsl:text>
	</xsl:template>
	
	<xsl:template name="register-queryIP">
		<xsl:text>		registerParametersImpl(</xsl:text>
		<xsl:apply-templates select=".." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="package"/>
		<xsl:text>.</xsl:text>
		<xsl:apply-templates select="." mode="modelclass-queryIP"/>
		<xsl:text>.class);

</xsl:text>
	</xsl:template>
	
	<xsl:template name="register-action">
		<xsl:text>		registerActionImpl(</xsl:text>
		<xsl:apply-templates select="../.." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select=".." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="package"/>
		<xsl:text>.</xsl:text>
		<xsl:apply-templates select="." mode="modelclass-action"/>
		<xsl:text>.class);

</xsl:text>
	</xsl:template>
	
	<xsl:template name="register-actionIP">
		<xsl:text>		registerParametersImpl(</xsl:text>
		<xsl:apply-templates select="../.." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="const-name"/>
		<xsl:text>, </xsl:text>
		<xsl:apply-templates select="." mode="package"/>
		<xsl:text>.</xsl:text>
		<xsl:apply-templates select="." mode="modelclass-actionIP"/>
		<xsl:text>.class);

</xsl:text>
	</xsl:template>
	
	<xsl:template match="coolservice" mode="const-name">
		<xsl:value-of select="concat('S_',translate(@name,$lower-case,$upper-case))"/>
	</xsl:template>

	<xsl:template match="aspect" mode="const-name">
		<xsl:text>A_</xsl:text>
		<xsl:value-of select="translate(../@name,$lower-case,$upper-case)"/>
		<xsl:choose>
			<xsl:when test="@key='true'">_PK</xsl:when>
			<xsl:when test="not(@primary='true')">
				<xsl:text>_</xsl:text>
				<xsl:value-of select="translate(@name,$lower-case,$upper-case)"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="query" mode="const-name">
		<xsl:value-of select="translate(concat('Q_',../@name,'_',@name),$lower-case,$upper-case)"/>
	</xsl:template>

	<xsl:template match="action" mode="const-name">
		<xsl:value-of select="translate(concat('C_',../@name,'_',@name),$lower-case,$upper-case)"/>
	</xsl:template>

	<xsl:template match="coolservice" mode="service-name">
		<!--xsl:call-template name="revert">
			<xsl:with-param name="path" select="application/@provider"/>
		</xsl:call-template>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="application/@id"/>
		<xsl:text>.services.</xsl:text>
		<xsl:value-of select="concat(translate(@name,$upper-case,$lower-case),'.',@name)"/-->
		<xsl:text/><xsl:value-of select="application/@provider"/>/<xsl:value-of select="application/@id"/>/<xsl:value-of select="@name"/><xsl:text/>
		<xsl:variable name="bad-bo"><xsl:apply-templates select="." mode="bad-bo"/></xsl:variable>
		<xsl:if test="$bad-bo!=''">AS</xsl:if>
	</xsl:template>
	
	<xsl:template match="aspect" mode="aspect-name">
		<xsl:value-of select="concat(@name,'DO')"/>
	</xsl:template>
	
	<xsl:template match="coolservice" mode="bad-bo">
		<xsl:variable name="s-name" select="aspect[@primary='true']/@name"/>
		<xsl:if test="not(../coolservice[aspect[@name=concat($s-name,'AS') and @SG:parent=$s-name]])">!</xsl:if>
	</xsl:template>

</xsl:stylesheet>
