<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>
	<xsl:variable name="class-declaration-prefix" select="'public '"/>
	<xsl:variable name="class-declaration-suffix" select="''"/>
	<xsl:template match="*" name="java-template">
		<xsl:call-template name="class-intro"/>
		<xsl:text>package </xsl:text>
		<xsl:call-template name="class-package"/>
		<xsl:text>;

</xsl:text>
		<xsl:call-template name="class-imports"/>
		<xsl:call-template name="class-comments"/>
		<xsl:call-template name="class-declaration"/>
		<xsl:text> {

</xsl:text>
		<xsl:call-template name="class-content"/>
		<xsl:text>}
</xsl:text>
	</xsl:template>
	
	<xsl:template name="class-intro"/>
	<xsl:template name="class-comments"/>

	<xsl:template name="class-declaration">
		<xsl:value-of select="concat($class-declaration-prefix,@name,$class-declaration-suffix)"/>
	</xsl:template>

	<xsl:template name="class-imports"/>
	<xsl:template name="class-content"/>

	<xsl:template name="addrelation-name">
		<xsl:param name="prop-name"/>
		<xsl:text>add</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$prop-name"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="removerelation-name">
		<xsl:param name="prop-name"/>
		<xsl:text>remove</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$prop-name"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="getter-name">
		<xsl:param name="prop-name"/>
		<xsl:text>get</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$prop-name"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="setter-name">
		<xsl:param name="prop-name"/>
		<xsl:text>set</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$prop-name"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="bo-getter-name-collection">
		<xsl:param name="prop-name"/>
		<xsl:text>get</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$prop-name"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="adder-name">
		<xsl:param name="prop-name"/>
		<xsl:text>addTo</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$prop-name"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="remover-name">
		<xsl:param name="prop-name"/>
		<xsl:text>removeFrom</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$prop-name"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="java-const">
		<xsl:param name="value"/>
		<xsl:param name="type"/>
		<xsl:if test="$type='BigDecimal'">new BigDecimal(</xsl:if>
		<xsl:choose>
			<xsl:when test="$type='String'">
				<xsl:text>"</xsl:text>
				<xsl:call-template name="string-replace">
					<xsl:with-param name="string">
						<xsl:call-template name="string-replace">
							<xsl:with-param name="string" select="$value"/>
							<xsl:with-param name="old-pattern" select="'\'"/>
							<xsl:with-param name="new-pattern" select="'\\'"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="old-pattern" select="'&quot;'"/>
					<xsl:with-param name="new-pattern" select="'\&quot;'"/>
				</xsl:call-template>
				<xsl:text>"</xsl:text>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="$type='BigDecimal'">)</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
