<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xalan="http://xml.apache.org/xalan" xmlns:REL="http://www.sap.com/caf/jmi" xmlns:UML="//org.omg/UML/1.3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="functions.xslt"/>
	<xsl:import href="Coding.xslt"/>
	<xsl:param name="external-apps" select="'caf.core'"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	
	<xsl:variable name="XMI" select="XMI/XMI.content"/>
	<xsl:variable name="dictionary" select="XMI/dictionary"/>
	<xsl:variable name="apps">
		<xsl:for-each select="$XMI/com.sap.caf.metamodel.Application">
			<app id="{@objectName}" xmi.id="{@xmi.id}">
				<xsl:attribute name="package">
					<xsl:apply-templates select="." mode="package"/>
					<xsl:text>.services</xsl:text>
				</xsl:attribute>
				<xsl:if test="contains(concat(';',$external-apps,';'),concat(';',@objectName,';'))">
					<xsl:attribute name="external"/>
				</xsl:if>
			</app>
		</xsl:for-each>
		<xsl:for-each select="$dictionary/simple-type">
			<xsl:variable name="package" select="@package"/>
			<xsl:if test="not(preceding-sibling::simple-type[@package=$package])">
				<app package="{@package}"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="apps-nodeset" select="xalan:nodeset($apps)"/>
	<xsl:variable name="apps-sorted">
		<xsl:for-each select="$apps-nodeset/app">
			<xsl:sort select="@package"/>
			<xsl:variable name="package" select="@package"/>
			<xsl:if test="not(preceding-sibling::app[@package=$package])">
				<xsl:copy-of select="."/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="non-external">
		<xsl:text>;</xsl:text>
		<xsl:for-each select="$apps-nodeset/app[not(@external)]">
			<xsl:value-of select="@xmi.id"/>
			<xsl:text>;</xsl:text>
		</xsl:for-each>
	</xsl:variable>
	
	<xsl:key name="kApplications" match="com.sap.caf.metamodel.Application[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kDataObjects" match="com.sap.caf.metamodel.DataObject[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kDataStructures" match="com.sap.caf.metamodel.DataStructure[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kAspects" match="com.sap.caf.metamodel.DataStructure[@xmi.id]|com.sap.caf.metamodel.DataObject[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kBEI" match="com.sap.caf.metamodel.BusinessEntityInterface[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kAI" match="com.sap.caf.metamodel.ApplicationInterface[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kInterfaces" match="com.sap.caf.metamodel.ApplicationInterface[@xmi.id]|com.sap.caf.metamodel.BusinessEntityInterface[@xmi.id]" use="@xmi.id"/>
	<!--xsl:key name="kAIByName" match="com.sap.caf.metamodel.ApplicationInterface[@xmi.id and contains($non-external,concat(';',@xmi.id,':'))]" use="@objectName"/-->
	<xsl:key name="kAIByName" match="com.sap.caf.metamodel.ApplicationInterface[@xmi.id]" use="@objectName"/>
	<xsl:key name="kOperations" match="com.sap.caf.metamodel.Operation[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kMessages" match="com.sap.caf.metamodel.Message[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kProperties" match="com.sap.caf.metamodel.Property[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kAttributes" match="com.sap.caf.metamodel.Attribute[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kPermissions" match="com.sap.caf.metamodel.Permission[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kFields" match="com.sap.caf.metamodel.Field[@xmi.id]" use="@xmi.id"/>
	<xsl:key name="kTables" match="com.sap.caf.metamodel.Table[@xmi.id]" use="@xmi.id"/>
	
	<xsl:template match="XMI">
		<XMI>
			<XMI.content>
				<!--xsl:copy-of select="$apps"/-->
				<UML:Model xmi.id="Model" name="Project" visibility="public">
					<UML:Namespace.ownedElement>
						<xsl:for-each select="xalan:nodeset($apps-sorted)/app[1]">
							<xsl:call-template name="UMLPackage"/>
						</xsl:for-each>
						<xsl:call-template name="predefined-types"/>
						<xsl:call-template name="dictionary-types"/>
						<xsl:call-template name="object-types"/>
						<xsl:call-template name="stereo-types"/>
					</UML:Namespace.ownedElement>
				</UML:Model>
				<xsl:call-template name="tagged-values"/>
			</XMI.content>
		</XMI>
	</xsl:template>
	
	<xsl:template name="UMLPackage">
		<xsl:param name="parent-package"/>
		<xsl:if test="starts-with(@package,$parent-package)">
			<xsl:variable name="shift" select="number($parent-package!='')"/>
			<xsl:variable name="post-package" select="substring(@package,1+$shift+string-length($parent-package),string-length(@package)-string-length($parent-package)-$shift)"/>
			<xsl:variable name="current-package-part">
				<xsl:choose>
					<xsl:when test="contains($post-package,'.')"><xsl:value-of select="substring-before($post-package,'.')"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$post-package"/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="current-package">
				<xsl:if test="$parent-package!=''">
					<xsl:value-of select="concat($parent-package,'.')"/>
				</xsl:if>
				<xsl:value-of select="$current-package-part"/>
			</xsl:variable>
			<!--UML:Package name="{$current-package-part}" pack="{@package}" post="{$post-package}" par="{$parent-package}" curr="{$current-package}"-->
			<UML:Package name="{$current-package-part}" xmi.id="{$current-package}" visibility="package" isSpecification="false" isAbstract="false">
				<UML:Namespace.ownedElement>
					<xsl:choose>
						<xsl:when test="@package=$current-package">
							<xsl:if test="$apps-nodeset/app[@id and @package=$current-package]">
								<xsl:call-template name="UMLClass">
									<xsl:with-param name="external">
										<xsl:if test="$apps-nodeset/app[@id and @package=$current-package and @external]">true</xsl:if>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:if>
							<xsl:apply-templates select="$dictionary/simple-type[@package=$current-package]"/>
							<xsl:for-each select="following-sibling::app[1][starts-with(@package,$current-package)]">
								<xsl:call-template name="UMLPackage">
									<xsl:with-param name="parent-package" select="$current-package"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="UMLPackage">
								<xsl:with-param name="parent-package" select="$current-package"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</UML:Namespace.ownedElement>
			</UML:Package>
			<xsl:for-each select="following-sibling::app[not(starts-with(@package,concat($current-package,'.'))) and (starts-with(@package,concat($parent-package,'.')) or $parent-package='')][1]">
				<xsl:call-template name="UMLPackage">
					<xsl:with-param name="parent-package" select="$parent-package"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="UMLClass">
		<xsl:param name="external"/>
		<xsl:variable name="pid" select="@id"/>
		<xsl:variable name="app" select="$XMI/com.sap.caf.metamodel.Application[@objectName=$pid]"/>
		<xsl:for-each select="$app/com.sap.caf.metamodel.Application.BaseObjects/com.sap.caf.metamodel.DataStructure">
			<!-- interface-based browsing might be smarter -->
			<xsl:apply-templates select="key('kDataStructures',@xmi.idref)"/>
		</xsl:for-each>
		<xsl:for-each select="$app/com.sap.caf.metamodel.Application.BaseObjects/com.sap.caf.metamodel.BusinessEntityInterface">
			<xsl:apply-templates select="key('kDataObjects',key('kBEI',@xmi.idref)/com.sap.caf.metamodel.BusinessEntityInterface.BusinessEntity/com.sap.caf.metamodel.DataObject/@xmi.idref)"/>
		</xsl:for-each>

		<xsl:if test="not($external='true')">
			<xsl:for-each select="$app/com.sap.caf.metamodel.Application.BaseObjects/*[name()='com.sap.caf.metamodel.DataStructure' or name()='com.sap.caf.metamodel.DataObject']">
				<xsl:for-each select="key('kAspects',@xmi.idref)">
					<xsl:variable name="sourceObj" select="."/>
					<!--xsl:for-each select=".//com.sap.caf.metamodel.Property">
						<xsl:variable name="prop" select="key('kProperties',@xmi.idref)"/>
						<xsl:if test="$prop/com.sap.caf.metamodel.Attribute.ReferencedObject">
							<xsl:variable name="targetObj" select="key('kAspects',$prop/com.sap.caf.metamodel.Attribute.ReferencedObject/com.sap.caf.metamodel.DataObject/@xmi.idref)"/>
							<xsl:if test="$tragetObj and $sourceObj/@objectName!=$targetObj/@objectName">
								<xsl:call-template name="UMLAssociation">
									<xsl:with-param name="sourceObj" select="$sourceObj"/>
									<xsl:with-param name="targetObj" select="$targetObj"/>
									<xsl:with-param name="id" select="$prop/@xmi.id"/>
									<xsl:with-param name="supplierRole" select="$prop/@objectName"/>
									<xsl:with-param name="minOccurs" select="$minOccurs"/>
									<xsl:with-param name="maxOccurs" select="$maxOccurs"/>
								</xsl:call-template>
							</xsl:if>
						</xsl:if>
					</xsl:for-each-->
					<!-- looking for non-primary aspects -->
					<xsl:variable name="ref-aspects">
						<xsl:call-template name="collect-aspects"/>
					</xsl:variable>
					<xsl:variable name="rel-aspects-a">
						<xsl:call-template name="collect-rel-aspects"/>
					</xsl:variable>
					<xsl:variable name="rel-aspects" select="xalan:nodeset($rel-aspects-a)"/>
					<xsl:for-each select="xalan:nodeset($ref-aspects)/ref[@xmi.idref!=$sourceObj/@xmi.id]">
						<xsl:variable name="ref" select="@xmi.idref"/>
						<xsl:if test="not(preceding-sibling::ref[@xmi.idref=$ref]) and not($rel-aspects/ref[@xmi.idref=$ref])">
							<xsl:variable name="targetObj" select="$XMI/com.sap.caf.metamodel.DataStructure[@xmi.id=$ref]"/>
							<xsl:call-template name="UMLAssociation">
								<xsl:with-param name="sourceObj" select="$sourceObj"/>
								<xsl:with-param name="targetObj" select="$targetObj"/>
								<xsl:with-param name="id" select="concat($sourceObj/@objectName,'$',$targetObj/@objectName)"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="$app/com.sap.caf.metamodel.Application.BaseObjects/com.sap.caf.metamodel.ApplicationInterface">
				<xsl:for-each select="key('kAI',@xmi.idref)">
					<xsl:variable name="sourceObj" select="."/>
					<xsl:if test="@objectName!='TypeAccess' and (string-length(@objectName)&gt;1 or substring(@objectName,string-length(@objectName)-1,2)!='AS')">
						<xsl:variable name="sourceObjName" select="@objectName"/>
						<xsl:if test="not($XMI/com.sap.caf.metamodel.DataStructure[com.sap.caf.metamodel.BaseObject.Application/com.sap.caf.metamodel.Application/@xmi.idref=$app/@xmi.id and (@objectName=$sourceObjName or @objectName=concat($sourceObjName,'DS'))])">
							<UML:Class name="{$sourceObjName}" xmi.id="{@xmi.id}" isAbstract="{@isAbstract}" visibility="public" isSpecification="false" isActive="false">
								<UML:Classifier.feature>
									<xsl:for-each select="com.sap.caf.metamodel.Interface.Operations/com.sap.caf.metamodel.Operation">
										<!--xsl:apply-templates select="key('kOperations',@xmi.idref)[not(com.sap.caf.metamodel.Operation.output) or key('kAttributes',key('kMessages',com.sap.caf.metamodel.Operation.output/com.sap.caf.metamodel.Message/@xmi.id)/com.sap.caf.metamodel.Message.MessageParts/com.sap.caf.metamodel.Attribute)/com.sap.caf.metamodel.Attribute.ReferencedObject/com.sap.caf.metamodel.DataStructure]"/-->
										<xsl:apply-templates select="key('kOperations',@xmi.idref)"/>
									</xsl:for-each>
								</UML:Classifier.feature>
							</UML:Class>
						</xsl:if>

						<xsl:variable name="ref-aspects">
							<xsl:call-template name="collect-aspects">
								<xsl:with-param name="objName" select="@objectName"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="xalan:nodeset($ref-aspects)/ref">
							<xsl:variable name="ref" select="@xmi.idref"/>
							<xsl:if test="not(preceding-sibling::ref[@xmi.idref=$ref])">
								<xsl:variable name="targetObj" select="$XMI/com.sap.caf.metamodel.DataStructure[@xmi.id=$ref]"/>
								<xsl:call-template name="UMLAssociation">
									<xsl:with-param name="sourceObj" select="$sourceObj"/>
									<xsl:with-param name="targetObj" select="$targetObj"/>
									<xsl:with-param name="id" select="concat($sourceObj/@objectName,'$',$targetObj/@objectName)"/>
								</xsl:call-template>
							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>

	</xsl:template>
	
	<xsl:template match="com.sap.caf.metamodel.DataStructure|com.sap.caf.metamodel.DataObject">
		<!-- find appropriate operations interface -->
		<xsl:variable name="c-id" select="@xmi.id"/>
		<!-- incredible ... perhaps we should simplify this? -->
		<xsl:variable name="host-queries" select="$XMI/com.sap.caf.metamodel.Operation[key('kAttributes',key('kMessages',com.sap.caf.metamodel.Operation.output/com.sap.caf.metamodel.Message/@xmi.idref)/com.sap.caf.metamodel.Message.MessageParts/com.sap.caf.metamodel.Attribute/@xmi.idref)/com.sap.caf.metamodel.Attribute.ReferencedObject/*/@xmi.idref=$c-id]"/>
		<xsl:if test="not(key('kAI',$host-queries/com.sap.caf.metamodel.Operation.Interface/com.sap.caf.metamodel.ApplicationInterface/@xmi.idref)/@objectName='TypeAccess')">
		<xsl:variable name="ainame"><xsl:call-template name="iname"><xsl:with-param name="force-ai" select="'true'"/></xsl:call-template></xsl:variable>
		<xsl:variable name="iname"><xsl:call-template name="iname"/></xsl:variable>
		<xsl:variable name="parent-bei-id">
			<xsl:for-each select="key('kAIByName',$ainame)">
				<xsl:if test="count(com.sap.caf.metamodel.Interface.UsedInterfaces/com.sap.caf.metamodel.BusinessEntityInterface)=1">
					<xsl:value-of select="com.sap.caf.metamodel.Interface.UsedInterfaces/com.sap.caf.metamodel.BusinessEntityInterface/@xmi.idref"/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<UML:Class name="{$iname}" xmi.id="{@xmi.id}" isAbstract="{@isAbstract}" visibility="public" isSpecification="false" isActive="false">
			<xsl:variable name="app-id" select=".//com.sap.caf.metamodel.Application/@xmi.idref"/>
			<xsl:if test="not($apps-nodeset[@xmi.id=$app-id]/@external)">
				<xsl:variable name="parent-class" select="key('kDataObjects',key('kBEI',$parent-bei-id)/com.sap.caf.metamodel.BusinessEntityInterface.BusinessEntity/*/@xmi.idref)[@xmi.id!=$c-id]"/>
				<UML:Classifier.feature>
					<xsl:for-each select=".//com.sap.caf.metamodel.Attribute">
						<xsl:variable name="attr" select="key('kAttributes',@xmi.idref)"/>
						<xsl:if test="not($parent-class//com.sap.caf.metamodel.Property[key('kProperties',@xmi.idref)/@objectName=$attr/@objectName])">
							<xsl:apply-templates select="$attr"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:for-each select=".//com.sap.caf.metamodel.Property">
						<xsl:variable name="prop" select="key('kProperties',@xmi.idref)"/>
						<xsl:if test="not($parent-class//com.sap.caf.metamodel.Property[key('kProperties',@xmi.idref)/@objectName=$prop/@objectName])">
							<xsl:apply-templates select="$prop"/>
						</xsl:if>
					</xsl:for-each>
					<xsl:apply-templates select="key('kBEI',com.sap.caf.metamodel.DataObject.BusinessEntityInterface/com.sap.caf.metamodel.BusinessEntityInterface/@xmi.idref)"/>
					<xsl:variable name="bei-methods">
						<xsl:for-each select="key('kBEI',com.sap.caf.metamodel.DataObject.BusinessEntityInterface/com.sap.caf.metamodel.BusinessEntityInterface/@xmi.idref)">
							<xsl:text>#</xsl:text>
							<xsl:for-each select="com.sap.caf.metamodel.Interface.Operations/com.sap.caf.metamodel.Operation">
								<xsl:value-of select="concat(key('kOperations',@xmi.idref)/@objectName,'#')"/>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:variable>
					<!-- Actions come from interface named like the class -->
					<xsl:for-each select="key('kAIByName',$ainame)/com.sap.caf.metamodel.Interface.Operations/com.sap.caf.metamodel.Operation">
						<xsl:apply-templates select="key('kOperations',@xmi.idref)[not(com.sap.caf.metamodel.Operation.output) and not(contains($bei-methods,concat('#',@objectName,'#')))]"/>
					</xsl:for-each>
					<xsl:if test="name()='com.sap.caf.metamodel.DataStructure'">
						<xsl:apply-templates select="$host-queries[not(contains($bei-methods,concat('#',@objectName,'#')))]"/>
					</xsl:if>
				</UML:Classifier.feature>
				<xsl:variable name="c-id" select="@xmi.id"/>
				<xsl:variable name="i-id" select="key('kAIByName',$ainame)/@xmi.id"/>
				<xsl:if test="$parent-class">
					<UML:Namespace.ownedElement>
						<UML:Generalization xmi.id="G{$i-id}-{$parent-bei-id}" name="" visibility="public" isSpecification="false" discriminator="">
							<UML:Generalization.child>
								<Foundation.Core.GeneralizableElement xmi.idref="{$c-id}"/>
							</UML:Generalization.child>
							<UML:Generalization.parent>
								<Foundation.Core.GeneralizableElement xmi.idref="{$parent-class/@xmi.id}"/>
							</UML:Generalization.parent>
						</UML:Generalization>
					</UML:Namespace.ownedElement>
				</xsl:if>
			</xsl:if>
		</UML:Class>
		</xsl:if>
	</xsl:template>

	<xsl:template name="UMLAssociation">
		<xsl:param name="sourceObj"/>
		<xsl:param name="targetObj"/>
		<xsl:param name="id"/>
		<xsl:param name="supplierRole"/>
		<xsl:param name="minOccurs"/>
		<xsl:param name="maxOccurs"/>
		<UML:Association xmi.id="{$id}" name="{concat('{',$sourceObj/@objectName,'-',$targetObj/@objectName,'}')}" visibility="public" isSpecification="false" isAbstract="false">
			<UML:Association.connection>
				<UML:AssociationEnd xmi.id="{$id}.Source" visibility="public" isSpecification="false" isAbstract="false" isNavigable="true" ordering="unordered" aggregation="none" targetScope="instance" changeability="changeable">
					<UML:AssociationEnd.multiplicity><UML:Multiplicity/></UML:AssociationEnd.multiplicity>
					<UML:AssociationEnd.type>
						<Foundation.Core.Classifier xmi.idref="{$sourceObj/@xmi.id}"/>
					</UML:AssociationEnd.type>
				</UML:AssociationEnd>
				<UML:AssociationEnd xmi.id="{$id}.Target" name="{$supplierRole}" visibility="public" isSpecification="false" ordering="unordered" isAbstract="false" isNavigable="true" aggregation="none" targetScope="instance" changeability="changeable">
					<UML:AssociationEnd.multiplicity>
						<UML:Multiplicity>
							<UML:Multiplicity.range>
								<UML:MultiplicityRange lower="{$minOccurs}" upper="{$maxOccurs}"/>
							</UML:Multiplicity.range>
						</UML:Multiplicity>
					</UML:AssociationEnd.multiplicity>
					<UML:AssociationEnd.type>
						<Foundation.Core.Classifier xmi.idref="{$targetObj/@xmi.id}"/>
					</UML:AssociationEnd.type>
				</UML:AssociationEnd>
			</UML:Association.connection>
		</UML:Association>
	</xsl:template>
	
	<xsl:template name="collect-aspects">
		<xsl:param name="objName"><xsl:call-template name="iname"><xsl:with-param name="force-ai" select="'true'"/></xsl:call-template></xsl:param>
		<xsl:for-each select="key('kAIByName',$objName)/com.sap.caf.metamodel.Interface.Operations/com.sap.caf.metamodel.Operation">
			<xsl:for-each select="key('kOperations',@xmi.idref)/com.sap.caf.metamodel.Operation.output/com.sap.caf.metamodel.Message">
				<xsl:for-each select="key('kMessages',@xmi.idref)/com.sap.caf.metamodel.Message.MessageParts/com.sap.caf.metamodel.Attribute">
					<xsl:for-each select="key('kAttributes',@xmi.idref)">
						<xsl:if test="com.sap.caf.metamodel.Attribute.ReferencedObject">
							<xsl:for-each select="key('kAspects',com.sap.caf.metamodel.Attribute.ReferencedObject/*/@xmi.idref)">
								<ref xmi.idref="{@xmi.id}" name="{@objectName}"/>
							</xsl:for-each>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="collect-rel-aspects">
		<xsl:for-each select=".//com.sap.caf.metamodel.Property">
			<xsl:for-each select="key('kProperties',@xmi.idref)">
				<xsl:for-each select="com.sap.caf.metamodel.Attribute.ReferencedObject/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']">
					<ref xmi.idref="{@xmi.idref}"/>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="com.sap.caf.metamodel.Property" mode="prop-ref">
		<xsl:variable name="prop" select="key('kProperties',@xmi.idref)"/>
		<!-- find out if the property is a relation to some extending aspect by checking extended interfaces -->
		<!--xsl:variable name="related-aspect" 
			select="key('kAspects',$prop/com.sap.caf.metamodel.Attribute.ReferencedObject/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']/@xmi.idref)"/>
		<xsl:variable name="extends">
			<xsl:if test="$related-aspect">
				<xsl:variable name="r-name">
					<xsl:call-template name="iname">
						<xsl:with-param name="objectName" select="$related-aspect/@objectName"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="bei" select="key('kBEI',../../com.sap.caf.metamodel.DataObject.BusinessEntityInterface/com.sap.caf.metamodel.BusinessEntityInterface/@xmi.idref)"/>
				<xsl:if test="key('kAI',@xmi.idref)[@objectName=$r-name and com.sap.caf.metamodel.Interface.UsedInterfaces/com.sap.caf.metamodel.BusinessEntityInterface[@xmi.idref=$bei/@xmi.id]]">!</xsl:if>
			</xsl:if>
		</xsl:variable>
		<xsl:if test="$extends=''">
			<xsl:apply-templates select="$prop"/>
		</xsl:if-->
		<xsl:apply-templates select="$prop"/>
	</xsl:template>

	<xsl:template match="com.sap.caf.metamodel.Property|com.sap.caf.metamodel.Attribute">
		<UML:Attribute xmi.id="{@xmi.id}" name="{@objectName}" isSpecification="false" changeability="changeable" ownerScope="instance">
			<xsl:attribute name="visibility">
				<xsl:choose>
					<xsl:when test="com.sap.caf.metamodel.Property.Field">public</xsl:when>
					<xsl:otherwise>protected</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<UML:StructuralFeature.multiplicity>
				<UML:Multiplicity>
					<UML:Multiplicity.range>
						<UML:MultiplicityRange lower="1" upper="1"/>
					</UML:Multiplicity.range>
				</UML:Multiplicity>
			</UML:StructuralFeature.multiplicity>
			<UML:StructuralFeature.type>
				<Foundation.Core.Classifier>
					<xsl:attribute name="xmi.idref">
						<xsl:choose>
							<xsl:when test="com.sap.caf.metamodel.Attribute.ReferencedObject">
								<xsl:value-of select="concat(com.sap.caf.metamodel.Attribute.ReferencedObject/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']/@xmi.idref,'.DataType')"/>
							</xsl:when>
							<xsl:when test="@maxOccurs='-1'">Collection</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="type-ddic-to-java">
									<xsl:with-param name="ddic-type" select="@typeJavaDDic"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Foundation.Core.Classifier>
			</UML:StructuralFeature.type>
		</UML:Attribute>
	</xsl:template>

	<xsl:template match="com.sap.caf.metamodel.Attribute">
		<UML:Attribute xmi.id="{@xmi.id}" name="{@objectName}" isSpecification="false" changeability="changeable" ownerScope="instance">
			<xsl:attribute name="visibility">protected</xsl:attribute>
			<UML:StructuralFeature.multiplicity>
				<UML:Multiplicity>
					<UML:Multiplicity.range>
						<UML:MultiplicityRange lower="1" upper="1"/>
					</UML:Multiplicity.range>
				</UML:Multiplicity>
			</UML:StructuralFeature.multiplicity>
			<UML:StructuralFeature.type>
				<Foundation.Core.Classifier>
					<xsl:attribute name="xmi.idref">
						<xsl:choose>
							<xsl:when test="com.sap.caf.metamodel.Attribute.ReferencedObject">
								<xsl:value-of select="concat(com.sap.caf.metamodel.Attribute.ReferencedObject/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']/@xmi.idref,'.DataType')"/>
							</xsl:when>
							<xsl:when test="@maxOccurs='-1'">Collection</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="type-ddic-to-java">
									<xsl:with-param name="ddic-type" select="@typeJavaDDic"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Foundation.Core.Classifier>
			</UML:StructuralFeature.type>
		</UML:Attribute>
	</xsl:template>

	
	<xsl:template match="com.sap.caf.metamodel.BusinessEntityInterface|com.sap.caf.metamodel.ApplicationInterface">
		<xsl:for-each select="com.sap.caf.metamodel.Interface.Operations/com.sap.caf.metamodel.Operation">
			<xsl:apply-templates select="key('kOperations',@xmi.idref)"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="com.sap.caf.metamodel.Operation">
		<UML:Operation xmi.id="{@xmi.id}" name="{@objectName}" visibility="public" isSpecification="false" isAbstract="false" ownerScope="instance" specification="{@LongText}">
			<UML:BehavioralFeature.parameter>
				<xsl:for-each select="com.sap.caf.metamodel.Operation.output/com.sap.caf.metamodel.Message">
					<UML:Parameter>
						<xsl:attribute name="xmi.id"><xsl:value-of select="@xmi.idref"/></xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="concat(../../@objectName,'.Return')"/></xsl:attribute>
						<xsl:attribute name="isSpecification">false</xsl:attribute>
						<xsl:attribute name="kind">return</xsl:attribute>
						<UML:Parameter.type>
							<Foundation.Core.Classifier xmi.idref="Collection"/>
						</UML:Parameter.type>
					</UML:Parameter>
				</xsl:for-each>
				<xsl:for-each select="com.sap.caf.metamodel.Operation.input/com.sap.caf.metamodel.Message">
					<xsl:variable name="mid" select="@xmi.idref"/>
					<xsl:for-each select="key('kMessages',@xmi.idref)/com.sap.caf.metamodel.Message.MessageParts/*[name()='com.sap.caf.metamodel.Property' or name()='com.sap.caf.metamodel.Attribute']">
						<xsl:for-each select="key('kAttributes',@xmi.idref)">
							<xsl:call-template name="parameter">
								<xsl:with-param name="pre-id" select="$mid"/>
							</xsl:call-template>
						</xsl:for-each>
						<xsl:for-each select="key('kProperties',@xmi.idref)">
							<xsl:call-template name="parameter">
								<xsl:with-param name="pre-id" select="$mid"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
			</UML:BehavioralFeature.parameter>
		</UML:Operation>
	</xsl:template>
	
	<xsl:template name="parameter">
		<xsl:param name="pre-id"/>
		<UML:Parameter>
			<xsl:attribute name="xmi.id"><xsl:value-of select="concat($pre-id,'.',@xmi.id)"/></xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="@objectName"/></xsl:attribute>
			<xsl:attribute name="isSpecification">false</xsl:attribute>
			<xsl:attribute name="kind">inout</xsl:attribute>
			<UML:Parameter.type>
				<Foundation.Core.Classifier>
					<xsl:attribute name="xmi.idref">
						<xsl:choose>
							<xsl:when test="@maxOccurs='-1'">Collection</xsl:when>
							<xsl:when test="com.sap.caf.metamodel.Attribute.ReferencedObject">
								<xsl:value-of select="concat(com.sap.caf.metamodel.Attribute.ReferencedObject/com.sap.caf.metamodel.DataObject/@xmi.idref,'.DataType')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="type-ddic-to-java">
									<xsl:with-param name="ddic-type" select="@typeJavaDDic"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Foundation.Core.Classifier>
			</UML:Parameter.type>
		</UML:Parameter>
	</xsl:template>
	
	<xsl:template name="type-ddic-to-java">
		<xsl:param name="ddic-type"/>
		<xsl:choose>
			<xsl:when test="$ddic-type='com.sap.caf.base.integer'">Integer</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.base.string'">String</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.core.boolean'">Boolean</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.core.date'">Date</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.core.timestamp'">Timestamp</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.base.decimal'">BigDecimal</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.core.bytearray'">byte[]</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.base.float'">Float</xsl:when>
			<xsl:when test="$ddic-type='com.sap.caf.base.double'">Double</xsl:when>
			<xsl:otherwise><xsl:value-of select="$ddic-type"/>.DataType</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="predefined-types">
		<UML:DataType xmi.id="Float" name="java.lang.Float" visibility="public" isSpecification="false"/>	
		<UML:DataType xmi.id="Double" name="java.lang.Double" visibility="public" isSpecification="false"/>
		<UML:DataType xmi.id="String" name="java.lang.String" visibility="public" isSpecification="false"/>
		<UML:DataType xmi.id="Collection" name="java.util.Collection" visibility="public" isSpecification="false"/>
		<UML:DataType xmi.id="Integer" name="java.lang.Integer" visibility="public" isSpecification="false"/>
		<UML:DataType xmi.id="Boolean" name="java.lang.Boolean" visibility="public" isSpecification="false"/>
		<UML:DataType xmi.id="Timestamp" name="java.sql.Timestamp" visibility="public" isSpecification="false"/>
		<UML:DataType xmi.id="Date" name="java.util.Date" visibility="public" isSpecification="false"/>
		<UML:DataType xmi.id="byte[]" name="byte[]" visibility="public" isSpecification="false"/>
	</xsl:template>
	
	<xsl:template name="object-types">
		<xsl:for-each select="$XMI/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']">
			<UML:DataType xmi.id="{@xmi.id}.DataType" visibility="public" isSpecification="false">
				<xsl:attribute name="name">
					<xsl:apply-templates select="key('kApplications',.//com.sap.caf.metamodel.Application/@xmi.idref)" mode="package"/>
					<xsl:text>.services.</xsl:text>
					<xsl:call-template name="iname"/>
				</xsl:attribute>
			</UML:DataType>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="dictionary-types">
		<xsl:for-each select="$dictionary/simple-type">
			<xsl:variable name="full-name">
				<xsl:value-of select="@package"/>
				<xsl:if test="@package!=''">.</xsl:if>
				<xsl:value-of select="@name"/>
			</xsl:variable>
			<UML:DataType xmi.id="{$full-name}.DataType" name="{$full-name}" visibility="public" isSpecification="false"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="simple-type">
		<xsl:variable name="full-name">
			<xsl:value-of select="@package"/>
			<xsl:if test="@package!=''">.</xsl:if>
			<xsl:value-of select="@name"/>
		</xsl:variable>
		<UML:Class name="{@name}" xmi.id="{$full-name}" isAbstract="false" visibility="public" isSpecification="false" isActive="false"/>
	</xsl:template>

	<xsl:template name="stereo-types">
		<!-- Application Inteface stereotypes for fake classes representing AI -->
		<xsl:for-each select="$XMI/com.sap.caf.metamodel.ApplicationInterface">
			<xsl:variable name="sourceObj" select="."/>
			<xsl:variable name="app-id" select="com.sap.caf.metamodel.BaseObject.Application/com.sap.caf.metamodel.Application/@xmi.idref"/>
			<xsl:if test="@objectName!='TypeAccess' and (string-length(@objectName)&gt;1 or substring(@objectName,string-length(@objectName)-1,2)!='AS')">
				<xsl:variable name="sourceObjName" select="@objectName"/>
				<xsl:if test="not($XMI/com.sap.caf.metamodel.DataStructure[com.sap.caf.metamodel.BaseObject.Application/com.sap.caf.metamodel.Application/@xmi.idref=$app-id and @objectName=$sourceObjName or @objectName=concat($sourceObjName,'DS')])">
					<xsl:comment>==================== Application Interface [Stereotype] ====================</xsl:comment>
					<UML:Stereotype xmi.id="{@xmi.id}.Stereotype" name="Composite Service" visibility="public" isSpecification="false" baseClass="Class">
						<UML:Stereotype.extendedElement>
							<Foundation.Core.ModelElement xmi.idref="{@xmi.id}"/>
						</UML:Stereotype.extendedElement>
					</UML:Stereotype>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>

		<!-- list stereo types of all classes -->
		<xsl:for-each select="$XMI/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']">
			<xsl:variable name="iname"><xsl:call-template name="iname"><xsl:with-param name="force-ai" select="'true'"/></xsl:call-template></xsl:variable>
			<xsl:variable name="stereo-type">
				<xsl:choose>
					<xsl:when test="name()='com.sap.caf.metamodel.DataObject'">BO Service</xsl:when>
					<xsl:when test="key('kAIByName',$iname)">Composite Service</xsl:when>
					<xsl:otherwise>Aspect</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:comment>==================== <xsl:value-of select="$stereo-type"/> [Stereotype] ====================</xsl:comment>
			<UML:Stereotype xmi.id="{@xmi.id}.Stereotype" name="{$stereo-type}" visibility="public" isSpecification="false" baseClass="Class">
				<UML:Stereotype.extendedElement>
					<Foundation.Core.ModelElement xmi.idref="{@xmi.id}"/>
				</UML:Stereotype.extendedElement>
			</UML:Stereotype>
		</xsl:for-each>
		<!-- list stereo types for operations -->
		<xsl:for-each select="$XMI/*[name()='com.sap.caf.metamodel.BusinessEntityInterface' or name()='com.sap.caf.metamodel.ApplicationInterface']">
			<xsl:for-each select="com.sap.caf.metamodel.Interface.Operations/com.sap.caf.metamodel.Operation">
				<xsl:variable name="ope" select="key('kOperations',@xmi.idref)"/>
				<!-- skip common operations -->
				<xsl:if test="$ope/@patternType='5' or $ope/@patternType='0'">
					<xsl:variable name="o-stereo-type">
						<xsl:choose>
							<xsl:when test="not($ope/com.sap.caf.metamodel.Operation.output)">Action</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="input-message" select="key('kMessages',$ope/com.sap.caf.metamodel.Operation.input/com.sap.caf.metamodel.Message/@xmi.idref)"/>
								<xsl:choose>
									<xsl:when test="$input-message/com.sap.caf.metamodel.Message.MessageParts/com.sap.caf.metamodel.Property">Find-by query</xsl:when>
									<xsl:otherwise>Query</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:comment>==================== <xsl:value-of select="$o-stereo-type"/> [Stereotype] ====================</xsl:comment>
					<UML:Stereotype xmi.id="{$ope/@xmi.id}.Stereotype" name="{$o-stereo-type}" visibility="public" isSpecification="false" baseClass="Operation">
						<UML:Stereotype.extendedElement>
							<Foundation.Core.ModelElement xmi.idref="{$ope/@xmi.id}"/>
						</UML:Stereotype.extendedElement>
					</UML:Stereotype>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:for-each select="$dictionary/simple-type">
			<xsl:variable name="full-name">
				<xsl:value-of select="@package"/>
				<xsl:if test="@package!=''">.</xsl:if>
				<xsl:value-of select="@name"/>
			</xsl:variable>
			<xsl:comment>==================== type [Stereotype] ====================</xsl:comment>
			<UML:Stereotype xmi.id="{$full-name}.Stereotype" name="type" visibility="public" isSpecification="false" baseClass="Class">
				<UML:Stereotype.extendedElement>
					<Foundation.Core.ModelElement xmi.idref="{$full-name}"/>
				</UML:Stereotype.extendedElement>
			</UML:Stereotype>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="tagged-values">
		<xsl:for-each select="$XMI/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']">
			<xsl:variable name="app-id" select=".//com.sap.caf.metamodel.Application/@xmi.idref"/>
			<xsl:choose>
				<xsl:when test="$apps-nodeset/app[@xmi.id=$app-id and @external]">
					<xsl:call-template name="tagged-value">
						<xsl:with-param name="element-id" select="@xmi.id"/>
						<xsl:with-param name="tag" select="'externalservice'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- tagged values for classes go here -->
					<xsl:if test="@objectID">
						<xsl:call-template name="tagged-value">
							<xsl:with-param name="element-id" select="@xmi.id"/>
							<xsl:with-param name="tag" select="'objectID'"/>
							<xsl:with-param name="value" select="@objectID"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:variable name="tableName">
						<!--xsl:for-each select="*[com.sap.caf.metamodel.Property][1]/com.sap.caf.metamodel.Property[1]">
							<xsl:apply-templates select="." mode="tableName-ref"/>
						</xsl:for-each-->
						<xsl:apply-templates select="com.sap.caf.metamodel.DataStructure.attributes/com.sap.caf.metamodel.Property[1]" mode="tableName-ref"/>
					</xsl:variable>
					<xsl:if test="$tableName!=''">
						<xsl:call-template name="tagged-value">
							<xsl:with-param name="element-id" select="@xmi.id"/>
							<xsl:with-param name="tag" select="'tableName'"/>
							<xsl:with-param name="value" select="$tableName"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:variable name="sourceObj" select="."/>
					<xsl:apply-templates select=".//com.sap.caf.metamodel.Property" mode="tagged-value.ref"/>
					<xsl:choose>
						<xsl:when test="com.sap.caf.metamodel.DataObject.BusinessEntityInterface">
							<xsl:for-each select="com.sap.caf.metamodel.DataObject.BusinessEntityInterface/com.sap.caf.metamodel.BusinessEntityInterface">
								<xsl:apply-templates select="key('kBEI',@xmi.idref)" mode="tagged-value"/>
							</xsl:for-each>
						</xsl:when>
						<!--xsl:otherwise>
							<xsl:variable name="iname"><xsl:call-template name="iname"><xsl:with-param name="force-ai" select="'true'"/></xsl:call-template></xsl:variable>
							<xsl:for-each select="key('kAIByName',$iname)">
								<xsl:apply-templates select="." mode="tagged-value"/>
							</xsl:for-each>
						</xsl:otherwise-->
					</xsl:choose>
					<xsl:variable name="sourceObj" select="."/>
					<!-- looking for non-primary aspects -->
					<xsl:variable name="ref-aspects">
						<xsl:call-template name="collect-aspects"/>
					</xsl:variable>
					<xsl:variable name="rel-aspects-a">
						<xsl:call-template name="collect-rel-aspects"/>
					</xsl:variable>
					<xsl:variable name="rel-aspects" select="xalan:nodeset($rel-aspects-a)"/>
					<xsl:for-each select="xalan:nodeset($ref-aspects)/ref[@xmi.idref!=$sourceObj/@xmi.id]">
						<xsl:variable name="ref" select="@xmi.idref"/>
						<xsl:if test="not(preceding-sibling::ref[@xmi.idref=$ref]) and not($rel-aspects/ref[@xmi.idref=$ref])">
							<xsl:variable name="targetObj" select="$XMI/com.sap.caf.metamodel.DataStructure[@xmi.id=$ref]"/>
							<xsl:call-template name="tagged-value">
								<xsl:with-param name="element-id" select="concat($sourceObj/@objectName,'$',$targetObj/@objectName)"/>
								<xsl:with-param name="tag" select="'undirected'"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:apply-templates select="$XMI/com.sap.caf.metamodel.ApplicationInterface" mode="tagged-value"/>
		<xsl:apply-templates select="$dictionary/simple-type" mode="tagged-value"/>
	</xsl:template>
	
	<xsl:template match="com.sap.caf.metamodel.Property" mode="tableName-ref">
		<xsl:variable name="t">
			<xsl:variable name="prop" select="key('kProperties',@xmi.idref)"/>
			<xsl:if test="$prop/com.sap.caf.metamodel.Property.Field">
				<xsl:variable name="field" select="key('kFields',$prop/com.sap.caf.metamodel.Property.Field/com.sap.caf.metamodel.Field/@xmi.idref)"/>
				<xsl:value-of select="key('kTables',$field/com.sap.caf.metamodel.Field.Table/com.sap.caf.metamodel.Table/@xmi.idref)/@tableName"/>
			</xsl:if>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$t!=''"><xsl:value-of select="$t"/></xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="following-sibling::com.sap.caf.metamodel.Property[1]" mode="tableName-ref"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="com.sap.caf.metamodel.Property" mode="tagged-value.ref">
		<xsl:variable name="prop" select="key('kProperties',@xmi.idref)"/>
		<xsl:if test="$prop/@objectID">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$prop/@xmi.id"/>
				<xsl:with-param name="tag" select="'objectID'"/>
				<xsl:with-param name="value" select="$prop/@objectID"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$prop/com.sap.caf.metamodel.Property.Field">
			<xsl:variable name="field" select="key('kFields',$prop/com.sap.caf.metamodel.Property.Field/com.sap.caf.metamodel.Field/@xmi.idref)"/>
			<xsl:if test="$field/@fieldName">
				<xsl:call-template name="tagged-value">
					<xsl:with-param name="element-id" select="$prop/@xmi.id"/>
					<xsl:with-param name="tag" select="'fieldName'"/>
					<xsl:with-param name="value" select="$field/@fieldName"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="$prop/com.sap.caf.metamodel.Attribute.ReferencedObject">
				<xsl:variable name="targetObj" select="key('kAspects',$prop/com.sap.caf.metamodel.Attribute.ReferencedObject/*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']/@xmi.idref)"/>
				<xsl:if test="$targetObj">
					<!-- tagged values for relations go here -->
					<xsl:call-template name="tagged-value">
						<xsl:with-param name="element-id" select="$prop/@xmi.id"/>
						<xsl:with-param name="tag" select="'directed'"/>
					</xsl:call-template>
					<xsl:call-template name="tagged-value">
						<xsl:with-param name="element-id" select="$prop/@xmi.id"/>
						<xsl:with-param name="tag" select="'supplierRole'"/>
						<xsl:with-param name="value" select="$prop/@objectName"/>
					</xsl:call-template>
					<xsl:call-template name="tagged-value">
						<xsl:with-param name="element-id" select="$prop/@xmi.id"/>
						<xsl:with-param name="tag" select="'supplierCardinality'"/>
						<xsl:with-param name="value">
							<xsl:value-of select="$prop/@minOccurs"/>
							<xsl:if test="not($prop/@minOccurs='1' and $prop/@maxOccurs='1')">
								<xsl:text>..</xsl:text>
								<xsl:choose>
									<xsl:when test="$prop/@maxOccurs='-1'">*</xsl:when>
									<xsl:otherwise><xsl:value-of select="$prop/@maxOccurs"/></xsl:otherwise>
								</xsl:choose>
							</xsl:if>
						</xsl:with-param>
					</xsl:call-template>
					<xsl:variable name="field" select="key('kFields',$prop/com.sap.caf.metamodel.Property.Field/com.sap.caf.metamodel.Field/@xmi.idref)"/>
					<xsl:variable name="table" select="key('kTables',$field/com.sap.caf.metamodel.Field.Table/com.sap.caf.metamodel.Table/@xmi.idref)"/>
					<xsl:if test="$table/@tableName">
						<xsl:call-template name="tagged-value">
							<xsl:with-param name="element-id" select="$prop/@xmi.id"/>
							<xsl:with-param name="tag" select="'tableName'"/>
							<xsl:with-param name="value" select="$table/@tableName"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<!-- tagged values for properties go here -->
				<xsl:if test="$prop/@LongText">
					<xsl:call-template name="tagged-value">
						<xsl:with-param name="element-id" select="$prop/@xmi.id"/>
						<xsl:with-param name="tag" select="'documentation'"/>
						<xsl:with-param name="value" select="$prop/@LongText"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="com.sap.caf.metamodel.BusinessEntityInterface|com.sap.caf.metamodel.ApplicationInterface" mode="tagged-value">
		<!-- tagged values for operations -->
		<xsl:variable name="obj-id" select=".//*[name()='com.sap.caf.metamodel.DataObject' or name()='com.sap.caf.metamodel.DataStructure']/@xmi.idref"/>
		<xsl:if test="@objectID and com.sap.caf.metamodel.BusinessEntityInterface.BusinessEntity">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$obj-id"/>
				<xsl:with-param name="tag" select="'interfaceID'"/>
				<xsl:with-param name="value" select="@objectID"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@instancePermission='1'">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$obj-id"/>
				<xsl:with-param name="tag" select="'instancePermission'"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:for-each select="com.sap.caf.metamodel.Interface.Operations/com.sap.caf.metamodel.Operation">
			<xsl:apply-templates select="key('kOperations',@xmi.idref)" mode="tagged-value"/>
		</xsl:for-each>

		<!-- relations to aspects from application interface without primary aspect -->
		<xsl:variable name="sourceObj" select="."/>
		<xsl:if test="name()='com.sap.caf.metamodel.ApplicationInterface' and @objectName!='TypeAccess' and (string-length(@objectName)&gt;1 or substring(@objectName,string-length(@objectName)-1,2)!='AS')">
			<xsl:variable name="sourceObjName" select="@objectName"/>
			<xsl:variable name="app-id" select="com.sap.caf.metamodel.BaseObject.Application/com.sap.caf.metamodel.Application/@xmi.idref"/>
			<xsl:if test="not($XMI/com.sap.caf.metamodel.DataStructure[com.sap.caf.metamodel.BaseObject.Application/com.sap.caf.metamodel.Application/@xmi.idref=$app-id and @objectName=$sourceObjName or @objectName=concat($sourceObjName,'DS')])">
				<xsl:variable name="ref-aspects">
					<xsl:call-template name="collect-aspects">
						<xsl:with-param name="objName" select="@objectName"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="xalan:nodeset($ref-aspects)/ref">
					<xsl:variable name="ref" select="@xmi.idref"/>
					<xsl:if test="not(preceding-sibling::ref[@xmi.idref=$ref])">
						<xsl:variable name="targetObj" select="$XMI/com.sap.caf.metamodel.DataStructure[@xmi.id=$ref]"/>
						<xsl:call-template name="tagged-value">
							<xsl:with-param name="element-id" select="concat($sourceObj/@objectName,'$',$targetObj/@objectName)"/>
							<xsl:with-param name="tag" select="'undirected'"/>
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="com.sap.caf.metamodel.Operation" mode="tagged-value">
		<xsl:if test="@objectID">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'objectID'"/>
				<xsl:with-param name="value" select="@objectID"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@LongText">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'semantics'"/>
				<xsl:with-param name="value" select="@LongText"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@ShortText">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'description'"/>
				<xsl:with-param name="value" select="@ShortText"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="ope-id" select="@xmi.id"/>
		<xsl:if test="com.sap.caf.metamodel.Operation.Permission">
			<xsl:variable name="permission" select="key('kPermissions',com.sap.caf.metamodel.Operation.Permission/com.sap.caf.metamodel.Permission/@xmi.idref)"/>
			<xsl:if test="$permission/@objectID">
				<xsl:call-template name="tagged-value">
					<xsl:with-param name="element-id" select="@xmi.id"/>
					<xsl:with-param name="tag" select="'permissionID'"/>
					<xsl:with-param name="value" select="$permission/@objectID"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$permission/@implicitCheck='1'">
				<xsl:call-template name="tagged-value">
					<xsl:with-param name="element-id" select="@xmi.id"/>
					<xsl:with-param name="tag" select="'implicitCheck'"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
		<xsl:if test="com.sap.caf.metamodel.Operation.input">
			<xsl:variable name="input" select="key('kMessages',com.sap.caf.metamodel.Operation.input/com.sap.caf.metamodel.Message/@xmi.idref)"/>
			<xsl:if test="$input/@objectID">
				<xsl:call-template name="tagged-value">
					<xsl:with-param name="element-id" select="@xmi.id"/>
					<xsl:with-param name="tag" select="'inputMessageID'"/>
					<xsl:with-param name="value" select="$input/@objectID"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:for-each select="$input/com.sap.caf.metamodel.Message.MessageParts/com.sap.caf.metamodel.Attribute">
				<xsl:variable name="attr" select="key('kAttributes',@xmi.idref)"/>
				<xsl:if test="$attr/@objectID">
					<xsl:call-template name="tagged-value">
						<xsl:with-param name="element-id" select="$ope-id"/>
						<xsl:with-param name="tag" select="concat('permissionID_',position(),'_',$attr/@objectName)"/>
						<xsl:with-param name="value" select="$attr/@objectID"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="com.sap.caf.metamodel.Operation.output">
			<xsl:variable name="output" select="key('kMessages',com.sap.caf.metamodel.Operation.output/com.sap.caf.metamodel.Message/@xmi.idref)"/>
			<xsl:if test="$output/@objectID">
				<xsl:call-template name="tagged-value">
					<xsl:with-param name="element-id" select="@xmi.id"/>
					<xsl:with-param name="tag" select="'outputMessageID'"/>
					<xsl:with-param name="value" select="$output/@objectID"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:for-each select="$output/com.sap.caf.metamodel.Message.MessageParts/com.sap.caf.metamodel.Attribute">
				<xsl:variable name="attr" select="key('kAttributes',@xmi.idref)"/>
				<xsl:if test="$attr/com.sap.caf.metamodel.Attribute.ReferencedObject/com.sap.caf.metamodel.DataObject">
					<xsl:variable name="do" select="key('kDataObjects',$attr/com.sap.caf.metamodel.Attribute.ReferencedObject/com.sap.caf.metamodel.DataObject/@xmi.idref)"/>
					<xsl:call-template name="tagged-value">
						<xsl:with-param name="element-id" select="$ope-id"/>
						<xsl:with-param name="tag" select="'target'"/>
						<xsl:with-param name="value">
							<xsl:apply-templates select="key('kApplications',key('kBEI',$do//com.sap.caf.metamodel.BusinessEntityInterface/@xmi.idref)//com.sap.caf.metamodel.Application/@xmi.idref)" mode="package"/>
							<xsl:text>.services.</xsl:text>
							<xsl:value-of select="$do/@objectName"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="@internalCoding">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'internalCoding'"/>
				<xsl:with-param name="value">
					<xsl:call-template name="remove-gen-code">
						<xsl:with-param name="code" select="@internalCoding"/>
					</xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@importsCoding">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="@xmi.id"/>
				<xsl:with-param name="tag" select="'iimportsCoding'"/>
				<xsl:with-param name="value">
					<xsl:call-template name="remove-gen-code">
						<xsl:with-param name="code" select="@importsCoding"/>
					</xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="simple-type" mode="tagged-value">
		<xsl:variable name="full-name">
			<xsl:value-of select="@package"/>
			<xsl:if test="@package!=''">.</xsl:if>
			<xsl:value-of select="@name"/>
		</xsl:variable>
		<xsl:call-template name="tagged-value">
			<xsl:with-param name="element-id" select="$full-name"/>
			<xsl:with-param name="tag" select="'originaltype'"/>
			<xsl:with-param name="value" select="@base-type"/>
		</xsl:call-template>
		<xsl:if test="@maxlength">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'maxlength'"/>
				<xsl:with-param name="value" select="@maxlength"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@minInclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'mininclusive'"/>
				<xsl:with-param name="value" select="@minInclusive"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@maxInclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'maxinclusive'"/>
				<xsl:with-param name="value" select="@maxInclusive"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@minExclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'minexclusive'"/>
				<xsl:with-param name="value" select="@minExclusive"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@maxExclusive">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'maxexclusive'"/>
				<xsl:with-param name="value" select="@maxExclusive"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@format">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'format'"/>
				<xsl:with-param name="value" select="@format"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@dbDefault">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'dbDefault'"/>
				<xsl:with-param name="value" select="@dbDefault"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="@notNull">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'notNull'"/>
				<xsl:with-param name="value" select="@notNull"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:for-each select="enumeration/option">
			<xsl:call-template name="tagged-value">
				<xsl:with-param name="element-id" select="$full-name"/>
				<xsl:with-param name="tag" select="'option'"/>
				<xsl:with-param name="value">
					<xsl:choose>
						<xsl:when test="@key=@value"><xsl:value-of select="@key"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="@key"/>;<xsl:value-of select="@value"/></xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="version" select="position()"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="tagged-value">
		<xsl:param name="element-id"/>
		<xsl:param name="tag"/>
		<xsl:param name="value"/>
		<xsl:param name="version"/>
		<UML:TaggedValue xmi.id="{$element-id}.{$tag}.{$version}" tag="{$tag}" value="{$value}">
			<UML:TaggedValue.modelElement>
				<Foundation.Core.ModelElement xmi.idref="{$element-id}"/>
			</UML:TaggedValue.modelElement>
		</UML:TaggedValue>
	</xsl:template>
	
	<xsl:template name="iname">
		<xsl:param name="objectName" select="@objectName"/>
		<xsl:param name="force-ai"/>
		<xsl:choose>
			<xsl:when test="string-length($objectName)&lt;2"><xsl:value-of select="$objectName"/></xsl:when>
			<xsl:otherwise>
				<xsl:variable name="suffix" select="substring($objectName,string-length($objectName)-1,2)"/>
				<xsl:choose>
					<xsl:when test="$suffix='DO' or $suffix='DS'">
						<xsl:value-of select="substring($objectName,1,string-length($objectName)-2)"/>
						<xsl:if test="$suffix='DO' and $force-ai">AS</xsl:if>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$objectName"/></xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="com.sap.caf.metamodel.Application" mode="package">
		<xsl:call-template name="revert">
			<xsl:with-param name="path" select="@providerName"/>
		</xsl:call-template>
		<xsl:text>.</xsl:text>
		<xsl:value-of select="@objectName"/>
	</xsl:template>
	
</xsl:stylesheet>