<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xalan="http://xml.apache.org/xalan" xmlns:REL="http://www.sap.com/caf/jmi" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="JMI.xslt"/>
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="yes"/>
	
	<xsl:template match="MetaData">
		<xsl:variable name="JMI"><xsl:apply-templates select="." mode="JMI"/></xsl:variable>
		<xsl:variable name="JMI-nodeset" select="xalan:nodeset($JMI)"/>
		<xsl:text/>Applications: <xsl:value-of select="count($JMI-nodeset//Application)"/>
ApplicationInterfaces: <xsl:value-of select="count($JMI-nodeset//ApplicationInterface)"/>
Attributes: <xsl:value-of select="count($JMI-nodeset//Attribute)"/>
BusinessEntityInterfaces: <xsl:value-of select="count($JMI-nodeset//BusinessEntityInterface)"/>
DataObjects: <xsl:value-of select="count($JMI-nodeset//DataObject)"/>
DataStructures: <xsl:value-of select="count($JMI-nodeset//DataStructure)"/>
FaultMessages: <xsl:value-of select="count($JMI-nodeset//FaultMessage)"/>
Fields: <xsl:value-of select="count($JMI-nodeset//Field)"/>
Messages: <xsl:value-of select="count($JMI-nodeset//Message)"/>
Operations: <xsl:value-of select="count($JMI-nodeset//Operation)"/>
Permissions: <xsl:value-of select="count($JMI-nodeset//Permission)"/>
Properties: <xsl:value-of select="count($JMI-nodeset//Property)"/>
Tables: <xsl:value-of select="count($JMI-nodeset//Table)"/>
BaseObjectApplicationAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:BaseObjectApplicationAssociation')])"/>
BusinessObjectInterfaceDataObjectAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:BusinessObjectInterfaceDataObjectAssociation')])"/>
ObjectAttributeAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:ObjectAttributeAssociation')])"/>
AttributeObjectAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:AttributeObjectAssociation')])"/>
ObjectCompoundAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:ObjectCompoundAssociation')])"/>
MessageAttributeAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:MessageAttributeAssociation')])"/>
PropertyFieldAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:PropertyFieldAssociation')])"/>
InterfaceOperationAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:InterfaceOperationAssociation')])"/>
OperationOutputMessageAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:OperationOutputMessageAssociation')])"/>
OperationInputMessageAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:OperationInputMessageAssociation')])"/>
TableFieldAssociation: <xsl:value-of select="count($JMI-nodeset//@*[starts-with(name(),'REL:TableFieldAssociation')])"/>
<xsl:text/>
	</xsl:template>
</xsl:stylesheet>
