<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:REL="http://www.sap.com/caf/jmi" xmlns:SG="http://www.sap.com/xapps/xslt_generation/" xmlns:lxslt="http://xml.apache.org/xslt" xmlns:XmlUtils="XmlUtils">
	<xsl:import href="functions.xslt"/>
	<xsl:include href="Coding.xslt"/>
	
	<xsl:param name="gen-implemented-services" select="'true'"/>
	
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	
	<lxslt:component prefix="XmlUtils">
		<lxslt:script lang="javaclass" src="com.sap.caf.xslt_generation.XmlUtils"/>
	</lxslt:component>

	<xsl:template match="JMI">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<xsl:template match="MetaData">
		<xsl:variable name="tables">
			<xsl:for-each select="coolservice">
				<xsl:if test="aspect[@primary='true']/@SG:tableName">
					<xsl:value-of select="aspect[@primary='true']/@SG:tableName"/><xsl:text>;</xsl:text>
				</xsl:if>
				<xsl:for-each select="aspect[@key='true']/aspectrelation[@SG:tableName]">
					<xsl:value-of select="@SG:tableName"/><xsl:text>;</xsl:text>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="X" select="XmlUtils:initUniqueNames('tables',$tables)"/>
		<xsl:apply-templates select="." mode="JMI"/>
	</xsl:template>
	
	<xsl:template match="MetaData" mode="JMI">
		<JMI>
			<!-- all external services are considered to come from caf.core application -->
			<!--xsl:copy-of select="."/-->
			<xsl:if test="SG:externalservice">
				<Application REL:id="APP:caf.core" objectName="caf.core" providerName="sap.com" REL:ExternalObject="true">
					<xsl:apply-templates select="SG:externalservice"/>
				</Application>
			</xsl:if>
			<xsl:for-each select="coolservice[$gen-implemented-services='true' or not(@SG:implemented-service)]">
				<xsl:variable name="app-id" select="application/@id"/>
				<!-- coolservice iteration could be optimized -->
				<xsl:if test="not(preceding-sibling::coolservice[($gen-implemented-services='true' or not(@SG:implemented-service)) and application/@id=$app-id])">
					<Application objectName="{$app-id}" providerName="{application/@provider}">
						<xsl:attribute name="REL:id">
							<xsl:apply-templates select="application" mode="id"/>
						</xsl:attribute>
						<xsl:for-each select="../coolservice[($gen-implemented-services='true' or not(@SG:implemented-service)) and application/@id=$app-id and @SG:stereotype='BO Service']">
							<xsl:variable name="bad-bo">
								<xsl:apply-templates select="." mode="bad-bo"/>
							</xsl:variable>
							<BusinessEntityInterface objectName="{@name}" ShortText="{@name}" backend="0" searchAndRetrieval="false" classifiable="false" versionable="false">
								<xsl:call-template name="InterfaceContent">
									<xsl:with-param name="id-suffix"><xsl:if test="$bad-bo!=''">_BO</xsl:if></xsl:with-param>
									<xsl:with-param name="is-bei" select="'true'"/>
								</xsl:call-template>
							</BusinessEntityInterface>
							<xsl:if test="$bad-bo!=''">
								<ApplicationInterface objectName="{@name}AS" ShortText="{@name}" remoteEnabled="false">
									<xsl:attribute name="REL:InterfaceInterfaceAssociation"><xsl:apply-templates select="." mode="id"/>/Interface_BO</xsl:attribute>
									<xsl:call-template name="InterfaceContent"/>
								</ApplicationInterface>
							</xsl:if>
						</xsl:for-each>
						<xsl:for-each select="../coolservice[($gen-implemented-services='true' or not(@SG:implemented-service)) and application/@id=$app-id and @SG:stereotype='Composite Service']">
							<ApplicationInterface objectName="{@name}" ShortText="{@name}" remoteEnabled="false">
								<xsl:if test="aspect[@primary='true']/@SG:parent">
									<xsl:variable name="parent" select="aspect[@primary='true']/@SG:parent"/>
									<xsl:for-each select="../coolservice[aspect[@name=$parent]]">
										<xsl:attribute name="REL:InterfaceInterfaceAssociation">
											<xsl:apply-templates select="." mode="id"/>
											<xsl:text>/Interface</xsl:text>
											<xsl:variable name="bad-parent"><xsl:apply-templates select="." mode="bad-bo"/></xsl:variable>
											<xsl:if test="$bad-parent!=''">_BO</xsl:if>
										</xsl:attribute>
									</xsl:for-each>
								</xsl:if>
								<xsl:call-template name="InterfaceContent"/>
							</ApplicationInterface>
						</xsl:for-each>
						<xsl:for-each select="../coolservice[($gen-implemented-services='true' or not(@SG:implemented-service)) and application/@id=$app-id and @SG:stereotype='BO Service']">
							<xsl:apply-templates select="aspect[@primary='true']" mode="DataObject"/>
						</xsl:for-each>
						<xsl:for-each select="../coolservice[($gen-implemented-services='true' or not(@SG:implemented-service)) and application/@id=$app-id]">
							<xsl:apply-templates select="aspect[@SG:stereotype='Aspect' or @SG:stereotype='Composite Service']" mode="DataStructure"/>
						</xsl:for-each>
					</Application>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="coolservice[not(@SG:implemented-service) and @SG:stereotype='BO Service']">
				<xsl:apply-templates select="aspect[@primary='true']" mode="db-table"/>
			</xsl:for-each>
		</JMI>
	</xsl:template>
	
	<xsl:template name="InterfaceContent">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/>/Interface<xsl:value-of select="$id-suffix"/></xsl:attribute>
		<!-- association with application -->
		<xsl:attribute name="REL:BaseObjectApplicationAssociation"><xsl:apply-templates select="application" mode="id"/></xsl:attribute>
		<xsl:if test="$is-bei">
			<!-- association with business entity -->
			<xsl:attribute name="REL:BusinessObjectInterfaceDataObjectAssociation"><xsl:apply-templates select="." mode="id"/><!--xsl:value-of select="$id-suffix"/--></xsl:attribute>
		</xsl:if>
		<!-- association with common bo methods -->
		<xsl:if test="@SG:stereotype='BO Service' or aspect[@primary='true' and concat(@SG:parent,'AS')=@name]">
			<xsl:variable name="bo-id"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:variable>
			<xsl:attribute name="REL:InterfaceOperationAssociation.create"><xsl:value-of select="$bo-id"/>/create</xsl:attribute>
			<xsl:attribute name="REL:InterfaceOperationAssociation.update"><xsl:value-of select="$bo-id"/>/update</xsl:attribute>
			<xsl:attribute name="REL:InterfaceOperationAssociation.read"><xsl:value-of select="$bo-id"/>/read</xsl:attribute>
			<xsl:attribute name="REL:InterfaceOperationAssociation.delete"><xsl:value-of select="$bo-id"/>/delete</xsl:attribute>
			<!--xsl:attribute name="REL:InterfaceOperationAssociation.findByMP"><xsl:value-of select="$bo-id"/>/findByMP</xsl:attribute-->
		</xsl:if>

		<!-- Composite services -->
		<!--xsl:for-each select="aspect[not(@primary='true') and SG:detail-services]"-->
		<xsl:for-each select="aspect[SG:detail-services]">
			<xsl:variable name="bo-id"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:variable>
			<xsl:attribute name="{concat('REL:InterfaceOperationAssociation.update',position())}"><xsl:value-of select="$bo-id"/>/update</xsl:attribute>
			<xsl:call-template name="method-update">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template>
		</xsl:for-each>
		
		<xsl:variable name="p-aspect" select="aspect[@primary='true']/@name"/>
		<xsl:for-each select="method[not(@SG:wrapper-specific) and not(@SG:CAF-specific)]">
			<xsl:variable name="m-name" select="@name"/>
			<!-- Business entity interfaces can return primary aspects only -->
			<xsl:if test="not($is-bei) or @SG:stereotype='Find-by query' and ../query[@name=$m-name]/@aspect=$p-aspect">
				<xsl:attribute name="REL:InterfaceOperationAssociation.{position()}"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:attribute>
			</xsl:if>
		</xsl:for-each>
		
		<xsl:if test="$id-suffix='' and aspect[@primary='true']/@SG:interfaceID">
			<xsl:attribute name="objectID"><xsl:value-of select="aspect[@primary='true']/@SG:interfaceID"/></xsl:attribute>
			<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
		</xsl:if>
		
		<xsl:attribute name="instancePermission">
			<xsl:choose>
				<xsl:when test="$is-bei and aspect[@primary='true']/@SG:instancePermission='true'">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		
		<xsl:if test="not($is-bei)">
			<xsl:if test="@SG:implemented-service">
				<xsl:attribute name="importsCoding">
					<xsl:apply-templates select="." mode="implemented-imports"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:variable name="internalCoding">
				<xsl:if test="@SG:stereotype='BO Service' or method[@SG:stereotype='Find-by query']">
					<xsl:apply-templates select="aspect[@primary='true']" mode="function-convertCollection"/>
					<xsl:apply-templates select="aspect[@primary='true']" mode="function-convertDatatype"/>
					<xsl:apply-templates select="aspect[@primary='true']" mode="function-convertDataObject"/>
				</xsl:if>
				<xsl:apply-templates select="aspect[SG:detail-services]" mode="setAssociatedFields"/>
				<xsl:if test="@SG:implemented-service">
					<xsl:apply-templates select="." mode="implemented-internalCoding"/>
				</xsl:if>
				<xsl:apply-templates select="node()[@SG:implemented-service]" mode="implemented-internalCoding"/>
			</xsl:variable>
			<xsl:attribute name="internalCoding">
				<xsl:if test="$internalCoding!=''">
					<xsl:value-of select="$gen-code-start"/>
					<xsl:value-of select="$internalCoding"/>
					<xsl:if test="$internalCoding!=''"><xsl:value-of select="$no-gen-code"/></xsl:if>
					<xsl:value-of select="$gen-code-finish"/>
				</xsl:if>
				<xsl:value-of select="SG:internalCoding"/>
			</xsl:attribute>
			<xsl:apply-templates select="node()[@SG:implemented-service]" mode="implemented-imports"/>
		</xsl:if>
		
		<xsl:if test="not($is-bei)">
			<xsl:variable name="curr-srv" select="@name"/>
			<xsl:for-each select="aspect[@key='true']/aspectrelation[@targetservice!=$curr-srv and not(@SG:externalrelation)]">
				<xsl:attribute name="REL:InterfaceInterfaceAssociation.R{position()}">
					<xsl:variable name="r-srv" select="@targetservice"/>
					<xsl:apply-templates select="/MetaData/*[(name()='coolservice' or name()='SG:externalservice') and @name=$r-srv]" mode="id"/>
					<xsl:text>/Interface</xsl:text>
				</xsl:attribute>
			</xsl:for-each>
		</xsl:if>

		<xsl:if test="@SG:stereotype='BO Service' or aspect[@primary='true' and concat(@SG:parent,'AS')=@name]">
			<xsl:call-template name="bo-common-methods">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template>
		</xsl:if>

		<xsl:for-each select="method[not(@SG:wrapper-specific) and not(@SG:CAF-specific)]">
			<xsl:variable name="m-name" select="@name"/>
			<!-- Business entity interfaces can return primary aspects only -->
			<xsl:if test="not($is-bei) or @SG:stereotype='Find-by query' and ../query[@name=$m-name]/@aspect=$p-aspect">
				<xsl:call-template name="Operation">
					<xsl:with-param name="id-suffix" select="$id-suffix"/>
					<xsl:with-param name="is-bei" select="$is-bei"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="SG:externalservice">
		<xsl:variable name="s-name">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="string" select="@name"/>
				<xsl:with-param name="substring" select="'.'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="id"><xsl:apply-templates select="." mode="id"/></xsl:variable>
		<DataObject objectName="{$s-name}" languageDependent="false" REL:id="{$id}" REL:BaseObjectApplicationAssociation="APP:caf.core"/>
		<BusinessEntityInterface objectName="{$s-name}" REL:id="{$id}/Interface" REL:BaseObjectApplicationAssociation="APP:caf.core"/>
	</xsl:template>
	
	<xsl:template match="coolservice" mode="bad-bo">
		<xsl:variable name="s-name" select="aspect[@primary='true']/@name"/>
		<xsl:if test="not(../coolservice[aspect[@name=concat($s-name,'AS') and @SG:parent=$s-name]])">!</xsl:if>
		<!--xsl:choose>
			<xsl:when test="method[not(@SG:wrapper-specific) and not(@SG:CAF-specific) and not(@SG:stereotype='Find-by query')]">!</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="aspect[@key='true']/aspectrelation">
					<xsl:variable name="targetservice" select="@targetservice"/>
					<xsl:variable name="targetaspect" select="@targetaspect"/>
					<xsl:if test="not(@SG:externalrelation) and /MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]/@SG:stereotype!='BO Service'">!</xsl:if>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose-->
	</xsl:template>
	
	<xsl:template match="aspect" mode="DataObject">
		<xsl:variable name="bad-bo">
			<xsl:apply-templates select=".." mode="bad-bo"/>
		</xsl:variable>
		<DataObject objectName="{@name}DO">
			<xsl:call-template name="DOContent">
				<xsl:with-param name="db-aware" select="'true'"/>
				<!--xsl:with-param name="id-suffix"><xsl:if test="$bad-bo!=''">_BO</xsl:if></xsl:with-param-->
			</xsl:call-template>
		</DataObject>
		<!--xsl:if test="$bad-bo!=''">
			<DataStructure objectName="{@name}ASDS" test="D">
				<xsl:call-template name="DOContent"/>
			</DataStructure>
		</xsl:if-->
	</xsl:template>
	
	<xsl:template match="aspect" mode="DataStructure">
		<DataStructure objectName="{@name}DS">
			<xsl:call-template name="DOContent"/>
		</DataStructure>
	</xsl:template>

	<xsl:template name="DOContent">
		<xsl:param name="id-suffix"/>
		<xsl:param name="db-aware"/>
		<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:attribute>
		<xsl:attribute name="REL:BaseObjectApplicationAssociation"><xsl:apply-templates select="../application" mode="id"/></xsl:attribute>
		<xsl:if test="$db-aware='true'">
			<xsl:attribute name="REL:MasterDataObjectTableAssociation">
				<xsl:apply-templates select="." mode="db-id"/>
			</xsl:attribute>
		</xsl:if>
		<!--xsl:if test="@primary='true'"-->
		<xsl:if test="not(property[@name='key'])">
			<xsl:attribute name="REL:ObjectCompoundAssociation"><xsl:apply-templates select="." mode="id"/>/KEY<xsl:value-of select="$id-suffix"/></xsl:attribute>
		</xsl:if>

		<xsl:if test="@SG:objectID">
			<xsl:attribute name="objectID"><xsl:value-of select="@SG:objectID"/></xsl:attribute>
			<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
		</xsl:if>
		<xsl:for-each select="property[not(@SG:base-property)]">
			<xsl:variable name="p-name" select="@name"/>
			<xsl:if test="not(ancestor::coolservice/aspect[@key='true']/property[@name=$p-name])">
				<xsl:variable name="asso">
					<xsl:choose>
						<xsl:when test="@name='key'">ObjectCompoundAssociation</xsl:when>
						<xsl:otherwise>ObjectAttributeAssociation</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:attribute name="REL:{$asso}.{@name}"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:attribute>
			</xsl:if>
		</xsl:for-each>
		<xsl:if test="@primary='true'">
			<xsl:for-each select="../aspect[@key='true']/aspectrelation">
				<xsl:variable name="targetservice" select="@targetservice"/>
				<xsl:variable name="targetaspect" select="@targetaspect"/>
				<xsl:if test="not($db-aware='true') or @SG:externalrelation or /MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]/@SG:stereotype='BO Service'">
					<xsl:attribute name="REL:ObjectAttributeAssociation.R{position()}"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$db-aware='true'">
					<xsl:attribute name="REL:SourceDataObjectTableAssociation.{position()}"><xsl:apply-templates select="." mode="db-id"/></xsl:attribute>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="$db-aware='true'">
			<xsl:variable name="curr-aspect" select="@name"/>
			<xsl:variable name="curr-service" select="../@name"/>
			<xsl:for-each select="//aspectrelation[@targetservice=$curr-service and @targetaspect=$curr-aspect]">
				<xsl:attribute name="REL:TargetDataObjectTableAssociation.{../@name}_{@name}"><xsl:apply-templates select="." mode="db-id"/></xsl:attribute>
			</xsl:for-each>
		</xsl:if>
		<xsl:attribute name="languageDependent">false</xsl:attribute>
		<xsl:if test="not(property[@name='key'])">
			<Property objectName="key" listType="0" minOccurs="0" maxOccurs="1" ShortText="Key" typeJavaDDic="com.sap.caf.core.id" hollow="false" languageDependent="false" timeDependent="false">
				<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/>/KEY<xsl:value-of select="$id-suffix"/></xsl:attribute>
				<xsl:if test="$db-aware='true'">
					<xsl:attribute name="REL:PropertyFieldAssociation"><xsl:apply-templates select="." mode="db-id"/>/FLD:key</xsl:attribute>
				</xsl:if>
			</Property>
		</xsl:if>
		<xsl:for-each select="property[not(@SG:base-property)]">
			<xsl:call-template name="Property">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="db-aware" select="$db-aware"/>
			</xsl:call-template>
		</xsl:for-each>
		<xsl:if test="@primary='true'">
			<xsl:for-each select="../aspect[@key='true']/aspectrelation">
				<xsl:variable name="targetservice" select="@targetservice"/>
				<xsl:variable name="targetaspect" select="@targetaspect"/>
				<xsl:if test="not($db-aware='true') or @SG:externalrelation or /MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]/@SG:stereotype='BO Service'">
					<xsl:call-template name="RelationProperty">
						<xsl:with-param name="id-suffix" select="$id-suffix"/>
						<xsl:with-param name="db-aware" select="$db-aware"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="RelationProperty">
		<xsl:param name="id-suffix"/>
		<xsl:param name="db-aware"/>
		<Property>
			<xsl:call-template name="RelationPropertyAttributes">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="db-aware" select="$db-aware"/>
			</xsl:call-template>
		</Property>
	</xsl:template>

	<xsl:template name="RelationAttribute">
		<xsl:param name="id-suffix"/>
		<Attribute>
			<xsl:call-template name="RelationPropertyAttributes">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
			</xsl:call-template>
		</Attribute>
	</xsl:template>

	<xsl:template name="RelationPropertyAttributes">
		<xsl:param name="id-suffix"/>
		<xsl:param name="db-aware"/>
		<xsl:variable name="targetservice" select="@targetservice"/>
		<xsl:variable name="targetaspect" select="@targetaspect"/>

		<xsl:attribute name="Shorttext"><xsl:value-of select="@name"/></xsl:attribute>
		<xsl:attribute name="minOccurs"><xsl:value-of select="substring(@cardinality,1,1)"/></xsl:attribute>
		<xsl:attribute name="languageDependent">false</xsl:attribute>
		<xsl:attribute name="listType">0</xsl:attribute>
		<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:attribute>
		<xsl:attribute name="objectName">
			<xsl:if test="string-length(@name)&gt;0">
				<xsl:value-of select="concat(translate(substring(@name,1,1),$upper-case,$lower-case),substring(@name,2,string-length(@name)-1))"/>
			</xsl:if>
		</xsl:attribute>
		<xsl:attribute name="maxOccurs">
			<xsl:choose>
				<xsl:when test="@cardinality='1'">1</xsl:when>
				<xsl:when test="substring(@cardinality,4,1)='n'">-1</xsl:when>
				<xsl:otherwise><xsl:value-of select="substring(@cardinality,4,1)"/></xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:attribute name="REL:AttributeObjectAssociation">
			<xsl:choose>
				<xsl:when test="@SG:externalrelation">
					<xsl:apply-templates select="/MetaData/SG:externalservice[@name=$targetservice]" mode="id"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="/MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]" mode="id"/>
					<xsl:if test="$db-aware='true'"><xsl:value-of select="$id-suffix"/></xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:if test="$db-aware='true'">
			<xsl:attribute name="REL:PropertyFieldAssociation">
				<xsl:apply-templates select="." mode="db-id"/>/primarykey<xsl:text/>
			</xsl:attribute>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Property">
		<xsl:param name="id-suffix"/>
		<xsl:param name="db-aware"/>
		<xsl:variable name="p-name" select="@name"/>
		<xsl:if test="not(ancestor::coolservice/aspect[@key='true']/property[@name=$p-name])">
			<Property>
				<xsl:call-template name="PropertyAttributes">
					<xsl:with-param name="id-suffix" select="$id-suffix"/>
					<xsl:with-param name="db-aware" select="$db-aware"/>
				</xsl:call-template>
			</Property>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="PropertyAttributes">
		<xsl:param name="id-suffix"/>
		<xsl:param name="db-aware"/>
		<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:attribute>
		<xsl:if test="@SG:objectID and @name!='key'">
			<xsl:attribute name="objectID"><xsl:value-of select="@SG:objectID"/></xsl:attribute>
			<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
		</xsl:if>
		<xsl:attribute name="listType">0</xsl:attribute>
		<xsl:attribute name="objectName"><xsl:value-of select="@name"/></xsl:attribute>
		<xsl:attribute name="minOccurs">
			<xsl:choose>
				<xsl:when test="@SG:not-null">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:attribute name="maxOccurs">
			<xsl:choose>
				<xsl:when test="@type='Collection'">-1</xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:attribute name="ShortText"><xsl:value-of select="@name"/></xsl:attribute>
		<xsl:if test="@text">
			<xsl:attribute name="LongText"><xsl:value-of select="@text"/></xsl:attribute>
		</xsl:if>
		<xsl:attribute name="typeJavaDDic">
			<xsl:choose>
				<xsl:when test="@name='lastChangedBy' or @name='createdBy'">com.sap.caf.core.userId</xsl:when>
				<xsl:when test="@custom_type"><xsl:value-of select="@custom_type"/></xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="type-java-to-ddic">
						<xsl:with-param name="java-type" select="@type"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		<xsl:if test="@SG:visibility!='protected' and ../@SG:stereotype='BO Service' and $db-aware">
			<xsl:attribute name="REL:PropertyFieldAssociation">
				<xsl:apply-templates select="." mode="db-id"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:attribute name="hollow">false</xsl:attribute>
		<xsl:attribute name="languageDependent">false</xsl:attribute>
		<xsl:attribute name="timeDependent">false</xsl:attribute>
	</xsl:template>
	
	<xsl:template name="Operation">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<Operation objectName="{@name}" transactionType="0">
			<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/></xsl:attribute>
			<xsl:variable name="mname"><xsl:value-of select="@name"/></xsl:variable>
			<xsl:if test="parameter">
				<xsl:attribute name="REL:OperationInputMessageAssociation"><xsl:apply-templates select="." mode="id"/>/Input<xsl:value-of select="$id-suffix"/></xsl:attribute>
			</xsl:if>
			<xsl:attribute name="REL:OperationPermissionAssociation"><xsl:apply-templates select="." mode="id"/>/permission<xsl:value-of select="$id-suffix"/></xsl:attribute>
			<xsl:if test="@SG:objectID and $id-suffix=''">
				<xsl:attribute name="objectID"><xsl:value-of select="@SG:objectID"/></xsl:attribute>
				<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="REL:OperationFaultMessageAssociation"><xsl:apply-templates select="." mode="id"/>/Fault<xsl:value-of select="$id-suffix"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="@methodType='0'">
					<xsl:apply-templates select="../query[@name=$mname]" mode="text-attrs"/>
					<xsl:variable name="aname" select="../query[@name=$mname]/@aspect"/>
					<xsl:attribute name="patternType">5</xsl:attribute>
					<xsl:if test="not($is-bei) and @SG:stereotype='Find-by query'">
						<xsl:attribute name="coding"><xsl:apply-templates select="." mode="delegation-code"/></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="REL:OperationOutputMessageAssociation"><xsl:apply-templates select="." mode="id"/>/Output<xsl:value-of select="$id-suffix"/></xsl:attribute>
					<xsl:if test="ancestor::coolservice[@SG:implemented-service]">
						<xsl:attribute name="coding">
							<xsl:apply-templates select="." mode="implemented-coding"/>
						</xsl:attribute>
					</xsl:if>
					<Message objectName="Output">
						<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/>/Output<xsl:value-of select="$id-suffix"/></xsl:attribute>
						<xsl:attribute name="REL:MessageAttributeAssociation"><xsl:apply-templates select="." mode="id"/>/Result<xsl:value-of select="$id-suffix"/></xsl:attribute>
						<xsl:if test="@SG:outputMessageID and $id-suffix=''">
							<xsl:attribute name="objectID"><xsl:value-of select="@SG:outputMessageID"/></xsl:attribute>
							<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
						</xsl:if>
						<Attribute objectName="{$aname}" minOccurs="0" maxOccurs="-1" listType="0">
							<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/>/Result<xsl:value-of select="$id-suffix"/></xsl:attribute>
							<xsl:attribute name="REL:AttributeObjectAssociation">
								<xsl:apply-templates select="//aspect[@name=$aname]" mode="id"/><!--xsl:value-of select="$id-suffix"/-->
							</xsl:attribute>
						</Attribute>
					</Message>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="..//action[@name='mname']" mode="text-attrs"/>
					<xsl:attribute name="patternType">5</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="parameter">
				<Message objectName="Input">
					<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/>/Input<xsl:value-of select="$id-suffix"/></xsl:attribute>
					<xsl:if test="@SG:inputMessageID and $id-suffix=''">
						<xsl:attribute name="objectID"><xsl:value-of select="@SG:inputMessageID"/></xsl:attribute>
						<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
					</xsl:if>
					<xsl:variable name="implemented-query" select="@SG:stereotype='Find-by query'"/>
					<!--xsl:variable name="implemented-query" select="false"/-->
					<xsl:variable name="a-name" select="../query[@name=$mname]/@aspect"/>
					<xsl:for-each select="parameter">
						<xsl:variable name="p-name" select="@name"/>
						<xsl:attribute name="REL:MessageAttributeAssociation.{position()}">
							<xsl:choose>
								<xsl:when test="$implemented-query and //aspect[@name=$a-name]/property[@name=$p-name]">
									<xsl:apply-templates select="//aspect[@name=$a-name]/property[@name=$p-name]" mode="id"/>
									<!--xsl:value-of select="$id-suffix"/-->
								</xsl:when>
								<xsl:otherwise>
									<xsl:apply-templates select="." mode="id"/>
									<xsl:value-of select="$id-suffix"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</xsl:for-each>
					<xsl:for-each select="parameter">
						<xsl:variable name="p-name" select="@name"/>
						<xsl:if test="not($implemented-query) or not(//aspect[@name=$a-name]/property[@name=$p-name])">
							<Attribute>
								<xsl:call-template name="PropertyAttributes">
									<xsl:with-param name="id-suffix" select="$id-suffix"/>
								</xsl:call-template>
							</Attribute>
						</xsl:if>
					</xsl:for-each>
				</Message>
			</xsl:if>
			<Permission name="permission" REL:SearchAttribute="name">
				<xsl:attribute name="implicitCheck">
					<xsl:choose>
						<xsl:when test="@SG:implicitCheck='true'">1</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/>/permission<xsl:value-of select="$id-suffix"/></xsl:attribute>
				<xsl:if test="@SG:permissionID and $id-suffix=''">
					<xsl:attribute name="objectID"><xsl:value-of select="@SG:permissionID"/></xsl:attribute>
					<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
				</xsl:if>
			</Permission>
			<FaultMessage objectName="com.sap.caf.rt.exception.ServiceException">
				<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="id"/>/Fault<xsl:value-of select="$id-suffix"/></xsl:attribute>
				<xsl:if test="@SG:FaultID and $id-suffix=''">
					<xsl:attribute name="objectID"><xsl:value-of select="@SG:FaultID"/></xsl:attribute>
					<xsl:attribute name="REL:SearchAttribute">objectID</xsl:attribute>
				</xsl:if>
			</FaultMessage>
		</Operation>
	</xsl:template>
	
	<xsl:template match="action|query" mode="text-attrs">
		<xsl:if test="@shortText">
			<xsl:attribute name="ShortText"><xsl:value-of select="@shortText"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="@longText">
			<xsl:attribute name="LongText"><xsl:value-of select="@longText"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="bo-common-methods">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<xsl:for-each select="aspect[@primary='true']">
			<xsl:call-template name="method-create">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template>
			<xsl:call-template name="method-update">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template>
			<xsl:call-template name="method-read">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template>
			<xsl:call-template name="method-delete">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template>
			<!--xsl:call-template name="method-findByMP">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template-->
		</xsl:for-each>
		<xsl:for-each select="aspect[SG:detail-services]">
		<!--xsl:for-each select="aspect[not(@primary='true') and SG:detail-services]"-->
			<!-- Composite services -->
			<xsl:call-template name="method-update">
				<xsl:with-param name="id-suffix" select="$id-suffix"/>
				<xsl:with-param name="is-bei" select="$is-bei"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="aspect" mode="key-ref">
		<xsl:choose>
			<xsl:when test="property[@name='key']">
				<xsl:apply-templates select="property[@name='key']" mode="id"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="." mode="id"/>/KEY<xsl:text/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="method-create">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<xsl:variable name="bo-id">
			<xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/>
		</xsl:variable>
		<xsl:variable name="do-id">
			<xsl:apply-templates select="." mode="id"/>
		</xsl:variable>
		<xsl:variable name="key-ref"><xsl:apply-templates select="." mode="key-ref"/><!--xsl:value-of select="$id-suffix"/--></xsl:variable>
		<xsl:variable name="name-suffix">
			<xsl:if test="not(@primary='true')"><xsl:value-of select="@name"/></xsl:if>
		</xsl:variable>
		<Operation objectName="create{$name-suffix}" patternType="1" REL:id="{$bo-id}/create" transactionType="0" REL:OperationOutputMessageAssociation="{$bo-id}/create/outputmessage" REL:OperationInputMessageAssociation="{$bo-id}/create/inputmessage" REL:OperationPermissionAssociation="{$bo-id}/create/permission" REL:OperationFaultMessageAssociation="{$bo-id}/create/fault">
			<xsl:if test="not($is-bei) and (@SG:stereotype='BO Service' or concat(@SG:parent,'AS')=@name)">
				<xsl:attribute name="coding">
					<xsl:call-template name="delegation-create"/>
				</xsl:attribute>
			</xsl:if>
			<Message objectName="Output" REL:id="{$bo-id}/create/outputmessage" REL:MessageAttributeAssociation="{$bo-id}/create/output">
				<Attribute objectName="{@name}" minOccurs="0" maxOccurs="1" REL:AttributeObjectAssociation="{$do-id}" REL:id="{$bo-id}/create/output" listType="0"/>
			</Message>
			<Message objectName="Input" REL:id="{$bo-id}/create/inputmessage">
				<xsl:for-each select="property[@SG:not-null]">
					<xsl:attribute name="REL:MessageAttributeAssociation.I{position()}">
						<xsl:apply-templates select="." mode="id"/><!--xsl:text>.cip</xsl:text--><!--xsl:value-of select="$id-suffix"/-->
					</xsl:attribute>
				</xsl:for-each>
				<xsl:if test="@primary='true'">
					<xsl:for-each select="../aspect[@key='true']/aspectrelation[substring(@cardinality,1,1)='1']">
						<xsl:variable name="targetservice" select="@targetservice"/>
						<xsl:variable name="targetaspect" select="@targetaspect"/>
						<xsl:if test="@SG:externalrelation or /MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]/@SG:stereotype='BO Service'">
							<xsl:attribute name="REL:MessageAttributeAssociation.IR{position()}">
								<xsl:apply-templates select="." mode="id"/><!--xsl:text>.cip</xsl:text--><!--xsl:value-of select="$id-suffix"/-->
							</xsl:attribute>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
				<!--xsl:for-each select="property[@SG:not-null]">
					<Attribute>
						<xsl:call-template name="PropertyAttributes">
							<xsl:text>.cip</xsl:text>
						</xsl:call-template>
					</Attribute>
				</xsl:for-each>
				<xsl:if test="@primary='true'">
					<xsl:for-each select="../aspect[@key='true']/aspectrelation[substring(@cardinality,1,1)='1']">
						<xsl:variable name="targetservice" select="@targetservice"/>
						<xsl:variable name="targetaspect" select="@targetaspect"/>
						<xsl:if test="@SG:externalrelation or /MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]/@SG:stereotype='BO Service'">
							<xsl:call-template name="RelationAttribute">
								<xsl:text>.cip</xsl:text>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:if-->
				<!--xsl:attribute name="REL:MessageAttributeAssociation">
					<xsl:choose>
						<xsl:when test="$key-ref!=''"><xsl:value-of select="$key-ref"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="concat($bo-id,'create/input/id')"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:if test="$key-ref=''">
					<Attribute objectName="id" minOccurs="0" maxOccurs="1" typeJavaDDic="com.sap.caf.base.rid" REL:id="{$bo-id}/create/input/id" listType="0"/>
				</xsl:if-->
			</Message>
			<Permission name="permission" implicitCheck="0" REL:id="{$bo-id}/create/permission" REL:SearchAttribute="name"/>
			<FaultMessage objectName="com.sap.caf.rt.exception.ServiceException" REL:id="{$bo-id}/create/fault"/>
		</Operation>
	</xsl:template>
	
	<xsl:template name="method-read">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<xsl:variable name="bo-id">
			<xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/>
		</xsl:variable>
		<xsl:variable name="do-id">
			<xsl:apply-templates select="." mode="id"/>
		</xsl:variable>
		<xsl:variable name="key-ref"><xsl:apply-templates select="." mode="key-ref"/><!--xsl:value-of select="$id-suffix"/--></xsl:variable>
		<xsl:variable name="name-suffix">
			<xsl:if test="not(@primary='true')"><xsl:value-of select="@name"/></xsl:if>
		</xsl:variable>
		<Operation objectName="read{$name-suffix}" patternType="2" REL:id="{$bo-id}/read" transactionType="0" REL:OperationOutputMessageAssociation="{$bo-id}/read/outputmessage" REL:OperationInputMessageAssociation="{$bo-id}/read/inputmessage" REL:OperationPermissionAssociation="{$bo-id}/read/permission" REL:OperationFaultMessageAssociation="{$bo-id}/read/fault">
			<xsl:if test="not($is-bei) and (@SG:stereotype='BO Service' or concat(@SG:parent,'AS')=@name)">
				<xsl:attribute name="coding">
					<xsl:call-template name="delegation-read"/>
				</xsl:attribute>
			</xsl:if>
			<Message objectName="Output" REL:id="{$bo-id}/read/outputmessage" REL:MessageAttributeAssociation="{$bo-id}/read/output">
				<Attribute objectName="{@name}" minOccurs="0" maxOccurs="1" REL:AttributeObjectAssociation="{$do-id}" REL:id="{$bo-id}/read/output" listType="0"/>
			</Message>
			<Message objectName="Input" REL:id="{$bo-id}/read/inputmessage">
				<xsl:attribute name="REL:MessageAttributeAssociation">
					<xsl:choose>
						<xsl:when test="$key-ref!=''"><xsl:value-of select="$key-ref"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="concat($bo-id,'read/input/id')"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:if test="$key-ref=''">
					<Attribute objectName="key" minOccurs="0" maxOccurs="1" typeJavaDDic="com.sap.caf.core.id" REL:id="{$bo-id}/read/input/id" listType="0"/>
				</xsl:if>
			</Message>
			<Permission name="permission" implicitCheck="0" REL:id="{$bo-id}/read/permission" REL:SearchAttribute="name"/>
			<FaultMessage objectName="com.sap.caf.rt.exception.ServiceException" REL:id="{$bo-id}/read/fault"/>
		</Operation>
	</xsl:template>
	
	<xsl:template name="method-findByMP">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<xsl:variable name="bo-id">
			<xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/>
		</xsl:variable>
		<xsl:variable name="do-id">
			<xsl:apply-templates select="." mode="id"/>
		</xsl:variable>
		<xsl:variable name="key-ref"><xsl:apply-templates select="." mode="key-ref"/><!--xsl:value-of select="$id-suffix"/--></xsl:variable>
		<xsl:variable name="name-suffix">
			<xsl:if test="not(@primary='true')"><xsl:value-of select="@name"/></xsl:if>
		</xsl:variable>
		<Operation objectName="find{$name-suffix}ByMultipleParameters" patternType="0" REL:id="{$bo-id}/findByMP" transactionType="0" REL:OperationOutputMessageAssociation="{$bo-id}/findByMP/outputmessage" REL:OperationInputMessageAssociation="{$bo-id}/findByMP/inputmessage" REL:OperationPermissionAssociation="{$bo-id}/findByMP/permission" REL:OperationFaultMessageAssociation="{$bo-id}/findByMP/fault">
			<xsl:if test="not($is-bei) and (@SG:stereotype='BO Service' or concat(@SG:parent,'AS')=@name)">
				<xsl:attribute name="coding">
					<xsl:call-template name="delegation-findByMP"/>
				</xsl:attribute>
			</xsl:if>
			<Message objectName="Output" REL:id="{$bo-id}/findByMP/outputmessage" REL:MessageAttributeAssociation="{$bo-id}/findByMP/output">
				<Attribute objectName="{@name}" minOccurs="0" maxOccurs="-1" REL:AttributeObjectAssociation="{$do-id}" REL:id="{$bo-id}/findByMP/output" listType="0"/>
			</Message>
			<Message objectName="Input" REL:id="{$bo-id}/findByMP/inputmessage">
				<xsl:attribute name="REL:MessageAttributeAssociation.params"><xsl:value-of select="$bo-id"/>/findByMP/input/params</xsl:attribute>
				<xsl:attribute name="REL:MessageAttributeAssociation.implCheck"><xsl:value-of select="$bo-id"/>/findByMP/input/implCheck</xsl:attribute>
				<Attribute objectName="params" minOccurs="0" maxOccurs="1" typeJavaDDic="*" REL:id="{$bo-id}/findByMP/input/params" listType="0"/>
				<Attribute objectName="implCheck" minOccurs="0" maxOccurs="1" typeJavaDDic="com.sap.caf.core.boolean" REL:id="{$bo-id}/findByMP/input/implCheck" listType="0"/>
			</Message>
			<Permission name="permission" implicitCheck="0" REL:id="{$bo-id}/findByMP/permission" REL:SearchAttribute="name"/>
			<FaultMessage objectName="com.sap.caf.rt.exception.ServiceException" REL:id="{$bo-id}/findByMP/fault"/>
		</Operation>
	</xsl:template>
	
	<xsl:template name="method-update">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<xsl:variable name="bo-id">
			<xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/>
		</xsl:variable>
		<xsl:variable name="do-id">
			<xsl:apply-templates select="." mode="id"/>
		</xsl:variable>
		<xsl:variable name="name-suffix">
			<xsl:if test="not(@primary='true')"><xsl:value-of select="@name"/></xsl:if>
		</xsl:variable>
		<Operation objectName="update{$name-suffix}" patternType="3" REL:id="{$bo-id}/update" transactionType="0" REL:OperationInputMessageAssociation="{$bo-id}/update/inputmessage" REL:OperationPermissionAssociation="{$bo-id}/update/permission" REL:OperationFaultMessageAssociation="{$bo-id}/update/fault">
			<xsl:variable name="param">
				<xsl:call-template name="java-id">
					<xsl:with-param name="id" select="@name"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="not($is-bei) and (@SG:stereotype='BO Service' or concat(@SG:parent,'AS')=@name)">
				<xsl:attribute name="coding">
					<xsl:call-template name="delegation-update"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="SG:detail-services">
				<xsl:attribute name="coding">
					<xsl:call-template name="composite-update"/>
				</xsl:attribute>
			</xsl:if>
			<Message objectName="Input" REL:id="{$bo-id}/update/inputmessage" REL:MessageAttributeAssociation="{$bo-id}/update/input">
				<Attribute objectName="{$param}" minOccurs="1" maxOccurs="1" REL:AttributeObjectAssociation="{$do-id}" REL:id="{$bo-id}/update/input" listType="0"/>
			</Message>
			<Permission name="permission" implicitCheck="0" REL:id="{$bo-id}/update/permission" REL:SearchAttribute="name"/>
			<FaultMessage objectName="com.sap.caf.rt.exception.ServiceException" REL:id="{$bo-id}/update/fault"/>
		</Operation>
	</xsl:template>
	
	<xsl:template name="method-delete">
		<xsl:param name="id-suffix"/>
		<xsl:param name="is-bei"/>
		<xsl:variable name="bo-id">
			<xsl:apply-templates select="." mode="id"/><xsl:value-of select="$id-suffix"/>
		</xsl:variable>
		<xsl:variable name="do-id">
			<xsl:apply-templates select="." mode="id"/>
		</xsl:variable>
		<xsl:variable name="key-ref"><xsl:apply-templates select="." mode="key-ref"/><!--xsl:value-of select="$id-suffix"/--></xsl:variable>
		<xsl:variable name="name-suffix">
			<xsl:if test="not(@primary='true')"><xsl:value-of select="@name"/></xsl:if>
		</xsl:variable>
		<Operation objectName="delete{$name-suffix}" patternType="4" REL:id="{$bo-id}/delete" transactionType="0" REL:OperationInputMessageAssociation="{$bo-id}/delete/inputmessage" REL:OperationPermissionAssociation="{$bo-id}/delete/permission" REL:OperationFaultMessageAssociation="{$bo-id}/delete/fault">
			<xsl:if test="not($is-bei) and (@SG:stereotype='BO Service' or concat(@SG:parent,'AS')=@name)">
				<xsl:attribute name="coding">
					<xsl:call-template name="delegation-delete"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:variable name="param">
				<xsl:call-template name="java-id">
					<xsl:with-param name="id" select="@name"/>
				</xsl:call-template>
			</xsl:variable>
			<Message objectName="Input" REL:id="{$bo-id}/delete/inputmessage" REL:MessageAttributeAssociation="{$bo-id}/delete/input">
				<Attribute objectName="{$param}" minOccurs="1" maxOccurs="1" REL:AttributeObjectAssociation="{$do-id}" REL:id="{$bo-id}/delete/input" listType="0"/>
				<!--xsl:attribute name="REL:MessageAttributeAssociation">
					<xsl:choose>
						<xsl:when test="$key-ref!=''"><xsl:value-of select="$key-ref"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="concat($bo-id,'delete/input/id')"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:if test="$key-ref=''">
					<Attribute objectName="key" minOccurs="0" maxOccurs="1" typeJavaDDic="com.sap.caf.core.id" REL:id="{$bo-id}/delete/input/id" listType="0"/>
				</xsl:if-->
			</Message>
			<Permission name="permission" implicitCheck="0" REL:id="{$bo-id}/delete/permission" REL:SearchAttribute="name"/>
			<FaultMessage objectName="com.sap.caf.rt.exception.ServiceException" REL:id="{$bo-id}/delete/fault"/>
		</Operation>
	</xsl:template>
	
	<xsl:template match="aspect" mode="db-table">
		<xsl:variable name="tableName">
			<xsl:choose>
				<xsl:when test="@SG:tableName"><xsl:value-of select="@SG:tableName"/></xsl:when>
				<xsl:otherwise>
					<xsl:variable name="gen-name">
						<xsl:variable name="app-id" select="ancestor-or-self::coolservice/application/@id"/>
						<xsl:value-of select="translate($app-id,concat($lower-case,'.'),concat($upper-case,'_'))"/>
						<xsl:text>_</xsl:text>
						<xsl:call-template name="trim-string">
							<xsl:with-param name="string" select="@name"/>
							<xsl:with-param name="minlength" select="(18)-string-length($app-id)-1"/>
							<xsl:with-param name="maxlength" select="(18)-string-length($app-id)-1"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select="string(XmlUtils:getUniqueName('tables',$gen-name))"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Table REL:SearchAttribute="tableName" tableName="{$tableName}">
			<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="db-id"/></xsl:attribute>
			<xsl:if test="not(property[@name='key'])">
				<xsl:attribute name="REL:TableFieldAssociation.KEY"><xsl:apply-templates select="." mode="db-id"/>/FLD:key</xsl:attribute>
			</xsl:if>
			<xsl:for-each select="property[not(@SG:visibility='protected') and (string-length(@cardinality)&gt;4 or substring(@cardinality,4,1)!='n')]">
				<xsl:variable name="p-name" select="@name"/>
				<xsl:if test="not(ancestor::coolservice/aspect[@key='true']/property[@name=$p-name])">
					<xsl:attribute name="REL:TableFieldAssociation.{position()}"><xsl:apply-templates select="." mode="db-id"/></xsl:attribute>
				</xsl:if>
			</xsl:for-each>
			<!--xsl:for-each select="../aspect[@key='true']/aspectrelation">
				<xsl:attribute name="REL:TableFieldAssociation.R{position()}"><xsl:apply-templates select="." mode="db-id"/></xsl:attribute>
			</xsl:for-each-->
			<xsl:if test="not(property[@name='key'])">
				<Field REL:SearchAttribute="fieldName" fieldName="OBJECTKEY">
					<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="db-id"/>/FLD:key</xsl:attribute>
					<xsl:apply-templates select="." mode="ref-pk-fk-asso"/>
				</Field>
			</xsl:if>
			<xsl:variable name="fields">
				<xsl:for-each select="property[not(@SG:visibility='protected') and @SG:fieldName]"><xsl:value-of select="@SG:fieldName"/></xsl:for-each>
			</xsl:variable>
			<xsl:variable name="X" select="XmlUtils:initUniqueNames('fields',$fields)"/>
			<xsl:apply-templates select="property[not(@SG:visibility='protected')]" mode="db-field"/>
			<!--xsl:apply-templates select="../aspect[@key='true']/aspectrelation[string-length(@cardinality)&gt;4 or substring(@cardinality,4,1)!='n']" mode="db-field"/-->
		</Table>
		<xsl:for-each select="../aspect[@key='true']/aspectrelation">
			<xsl:variable name="r-id"><xsl:apply-templates select="." mode="db-id"/></xsl:variable>
			<xsl:variable name="targetservice" select="@targetservice"/>
			<xsl:variable name="targetaspect" select="@targetaspect"/>
			<xsl:variable name="tableName">
				<xsl:choose>
					<xsl:when test="@SG:tableName"><xsl:value-of select="@SG:tableName"/></xsl:when>
					<xsl:otherwise>
						<xsl:variable name="gen-name">
							<xsl:variable name="app-id" select="ancestor-or-self::coolservice/application/@id"/>
							<xsl:value-of select="translate($app-id,concat($lower-case,'.'),concat($upper-case,'_'))"/>
							<xsl:text>_</xsl:text>
							<xsl:call-template name="trim-string">
								<xsl:with-param name="string" select="concat(../../@name,@name)"/>
								<xsl:with-param name="minlength" select="(18)-string-length($app-id)-1"/>
								<xsl:with-param name="maxlength" select="(18)-string-length($app-id)-1"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:value-of select="string(XmlUtils:getUniqueName('tables',$gen-name))"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<Table REL:SearchAttribute="tableName" REL:id="{$r-id}" tableName="{$tableName}">
				<xsl:attribute name="REL:TableFieldAssociation.1"><xsl:value-of select="$r-id"/>/primarykey</xsl:attribute>
				<xsl:attribute name="REL:TableFieldAssociation.2"><xsl:value-of select="$r-id"/>/parentkey</xsl:attribute>
				<xsl:attribute name="REL:TableFieldAssociation.3"><xsl:value-of select="$r-id"/>/objectkey</xsl:attribute>
				<Field fieldName="PRIMARYKEY" REL:id="{$r-id}/primarykey" REL:SearchAttribute="fieldName">
					<!--xsl:attribute name="REL:FieldFieldAssociation">
						<xsl:apply-templates select=".." mode="db-id"/>/FLD:key<xsl:text/>
					</xsl:attribute-->
				</Field>
				<Field fieldName="PARENTKEY" REL:id="{$r-id}/parentkey" REL:SearchAttribute="fieldName"/>
				<Field fieldName="OBJECTKEY" REL:id="{$r-id}/objectkey" REL:SearchAttribute="fieldName"/>
			</Table>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="aspect" mode="ref-pk-fk-asso">
		<xsl:for-each select="../aspect[@key='true']/aspectrelation">
			<xsl:variable name="r-id"><xsl:apply-templates select="." mode="db-id"/></xsl:variable>
			<xsl:attribute name="REL:FieldFieldAssociation.{position()}parentkey"><xsl:value-of select="$r-id"/>/parentkey</xsl:attribute>
			<xsl:attribute name="REL:FieldFieldAssociation.{position()}objectkey"><xsl:value-of select="$r-id"/>/objectkey</xsl:attribute>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="property" mode="db-field">
		<xsl:variable name="p-name" select="@name"/>
		<xsl:if test="not(ancestor::coolservice/aspect[@key='true']/property[@name=$p-name])">
			<Field REL:SearchAttribute="fieldName">
				<xsl:variable name="fieldName">
					<xsl:choose>
						<xsl:when test="@SG:fieldName"><xsl:value-of select="@SG:fieldName"/></xsl:when>
						<xsl:when test="@name='key'">OBJECTKEY</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="gen-name">
								<xsl:call-template name="trim-string">
									<xsl:with-param name="string" select="@name"/>
									<xsl:with-param name="maxlength" select="18"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:value-of select="string(XmlUtils:getUniqueName('fields',$gen-name))"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:attribute name="fieldName">
					<xsl:value-of select="$fieldName"/>
					<xsl:if test="$fieldName='TYPE' or $fieldName='VALUE'">_</xsl:if>
				</xsl:attribute>
				<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="db-id"/></xsl:attribute>
				<xsl:if test="@name='key'">
					<xsl:apply-templates select=".." mode="ref-pk-fk-asso"/>
				</xsl:if>
			</Field>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="aspectrelation" mode="db-field">
		<Field REL:SearchAttribute="fieldName">
			<xsl:attribute name="REL:id"><xsl:apply-templates select="." mode="db-id"/></xsl:attribute>
			<xsl:attribute name="fieldName">
				<xsl:call-template name="trim-string">
					<xsl:with-param name="string">
						<xsl:if test="string-length(@name)&gt;0">
							<xsl:value-of select="concat(translate(substring(@name,1,1),$upper-case,$lower-case),substring(@name,2,string-length(@name)-1))"/>
						</xsl:if>
					</xsl:with-param>
					<xsl:with-param name="maxlength" select="18"/>
				</xsl:call-template>
			</xsl:attribute>
		</Field>
	</xsl:template>
	
	<xsl:template name="type-java-to-ddic">
		<xsl:param name="java-type"/>
		<xsl:variable name="utype" select="translate($java-type,$lower-case,$upper-case)"/>
		<xsl:choose>
			<xsl:when test="$utype='INTEGER'">com.sap.caf.base.integer</xsl:when>
			<xsl:when test="$utype='STRING'">com.sap.caf.base.string</xsl:when>
			<xsl:when test="$utype='DOUBLE'">com.sap.caf.base.double</xsl:when>
			<xsl:when test="$java-type='int'">com.sap.caf.base.integer</xsl:when>
			<xsl:when test="$utype='BOOLEAN'">com.sap.caf.core.boolean</xsl:when>
			<xsl:when test="$utype='DATE'">com.sap.caf.core.date</xsl:when>
			<xsl:when test="$utype='TIMESTAMP'">com.sap.caf.core.timestamp</xsl:when>
			<xsl:when test="$utype='DECIMAL'">com.sap.caf.base.decimal</xsl:when>
			<xsl:when test="$utype='BINARY'">com.sap.caf.core.bytearray</xsl:when>
			<xsl:when test="$java-type='byte[]'">com.sap.caf.core.bytearray</xsl:when>
			<xsl:when test="$java-type='Collection'">com.sap.caf.core.id</xsl:when>
			<xsl:otherwise><xsl:value-of select="$java-type"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="id">
		<xsl:attribute name="REL:id">
			<xsl:apply-templates select="." mode="id"/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="*" mode="id">
		<xsl:choose>
			<xsl:when test="name()='application'">
				<xsl:text>APP:</xsl:text>
				<xsl:value-of select="@id"/>
			</xsl:when>
			<xsl:when test="name()='SG:externalservice'">
				<xsl:text>APP:caf.core/DAT:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:when test="name()='aspect' or name()='coolservice'">
				<xsl:apply-templates select="ancestor-or-self::coolservice/application" mode="id"/>
				<xsl:text>/DAT:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:when test="name()='property'">
				<xsl:apply-templates select=".." mode="id"/>
				<xsl:text>/PRP:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:when test="name()='aspectrelation'">
				<xsl:apply-templates select="ancestor::coolservice" mode="id"/>
				<xsl:text>/PRP:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:when test="name()='method'">
				<xsl:apply-templates select=".." mode="id"/>
				<xsl:text>/OPE:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:when test="name()='parameter'">
				<xsl:apply-templates select=".." mode="id"/>
				<xsl:text>/PAR:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="*" mode="db-id">
		<xsl:choose>
			<xsl:when test="name()='aspect' or name()='coolservice'">
				<xsl:text>TAB:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:when test="name()='property'">
				<xsl:apply-templates select=".." mode="db-id"/>
				<xsl:text>/FLD:</xsl:text>
				<xsl:value-of select="@name"/>
			</xsl:when>
			<xsl:when test="name()='aspectrelation'">
				<xsl:text>TAB:</xsl:text>
				<xsl:value-of select="concat(ancestor::coolservice/@name,'_',@name)"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="trim-string">
		<xsl:param name="string"/>
		<xsl:param name="minlength"/>
		<xsl:param name="maxlength"/>
		<xsl:variable name="str" select="translate($string,$lower-case,$upper-case)"/>
		<!-- trim to maxlength -->
		<xsl:variable name="str1">
			<xsl:choose>
				<xsl:when test="$maxlength and string-length($str)&gt;$maxlength">
					<xsl:variable name="str2">
						<xsl:call-template name="remove-vowels">
							<xsl:with-param name="string" select="$str"/>
							<xsl:with-param name="maxlength" select="$maxlength"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($str2)&gt;$maxlength">
							<xsl:variable name="start-cut" select="$maxlength div 2"/>
							<xsl:value-of select="concat(substring($str2,1,$start-cut),substring($str2,string-length($str2)-$maxlength+$start-cut+1,($maxlength)-$start-cut))"/>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="$str2"/></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="$str"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$str1"/>
		<!-- trim to minlength -->
		<xsl:if test="$minlength and string-length($str)&lt;$minlength">
			<xsl:call-template name="repeat-string">
				<xsl:with-param name="string" select="'_'"/>
				<xsl:with-param name="count" select="($minlength)-(string-length($str))"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="remove-vowels">
		<xsl:param name="string"/>
		<xsl:param name="maxlength"/>
		<xsl:variable name="vowels" select="'aeouiyAEOUIY'"/>
		<xsl:variable name="last-is-vowel" select="contains($vowels,substring($string,string-length($string),1))"/>
		<!--xsl:value-of select="concat('#',$string,'#',$last-is-vowel)"/-->
		<xsl:choose>
			<xsl:when test="string-length($string)&gt;1 and (not($last-is-vowel) or string-length($string)-1&gt;$maxlength)">
				<xsl:call-template name="remove-vowels">
					<xsl:with-param name="string" select="substring($string,1,string-length($string)-1)"/>
					<xsl:with-param name="maxlength" select="($maxlength)-1+number($last-is-vowel)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="substring($string,1,string-length($string)-1)"/></xsl:otherwise>
		</xsl:choose>
		<xsl:if test="not($last-is-vowel)"><xsl:value-of select="substring($string,string-length($string),1)"/></xsl:if>
	</xsl:template>

	<xsl:template name="repeat-string">
		<xsl:param name="string"/>
		<xsl:param name="count"/>
		<xsl:if test="$count&gt;0">
			<xsl:value-of select="$string"/>
		</xsl:if>
		<xsl:if test="$count&gt;1">
			<xsl:call-template name="repeat-string">
				<xsl:with-param name="string" select="$string"/>
				<xsl:with-param name="count" select="($count)-1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
