<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="JavaTemplate.xslt"/>
	<xsl:import href="AspectTemplate.xslt"/>
	<xsl:include href="WDModelCommon.xslt"/>

	<xsl:param name="collection-classes" select="'#Collection#java.util.Collection#ArrayList#Set#SortedSet#SortedList#List#Vector#'"/>

	<xsl:template name="class-imports">
		<xsl:text>import java.util.Collection;
import java.sql.Date;

</xsl:text>
		<xsl:if test="property[@type='DECIMAL']">import java.math.BigDecimal;

</xsl:if>
		<xsl:if test="property[@type='TIMESTAMP']">import java.sql.Timestamp;

</xsl:if>
	</xsl:template>

	<xsl:template name="class-declaration">
		<xsl:text>public interface </xsl:text>
		<xsl:apply-templates select="." mode="modelclass-aspect"/>
		<xsl:text> extends com.sap.tc.col.client.generic.api.IAspectRow</xsl:text>
	</xsl:template>

	<xsl:template name="class-content">
		<xsl:call-template name="prop-getters-setters"/>
		<xsl:call-template name="prop-getters-setters-collection"/>
		<xsl:if test="@primary='true'">
			<xsl:apply-templates select="ancestor::coolservice/aspect[@key='true']/aspectrelation" mode="getter"/>
		</xsl:if>
		<xsl:if test="@primary='true'">
			<xsl:apply-templates select="ancestor::coolservice/aspect[@key='true']/aspectrelation" mode="setter"/>
		</xsl:if>
		<xsl:if test="@primary='true'">
			<xsl:apply-templates select="ancestor::coolservice/aspect[@key='true']/aspectrelation" mode="adder"/>
		</xsl:if>
		<xsl:if test="@primary='true'">
			<xsl:apply-templates select="ancestor::coolservice/aspect[@key='true']/aspectrelation" mode="remover"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="prop-type">
		<xsl:param name="prop-class"/>
		<xsl:variable name="prop-class-mod">
			<xsl:choose>
				<xsl:when test="starts-with($prop-class,'java.lang.')">
					<xsl:value-of select="substring($prop-class,11,string-length($prop-class)-10)"/>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="$prop-class"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$prop-class-mod='Integer'">int</xsl:when>
			<xsl:when test="$prop-class-mod='Double'">double</xsl:when>
			<xsl:when test="$prop-class-mod='Boolean'">boolean</xsl:when>
			<xsl:when test="$prop-class-mod='Byte'">byte</xsl:when>
			<xsl:when test="$prop-class-mod='Character'">char</xsl:when>
			<xsl:when test="$prop-class-mod='Short'">short</xsl:when>
			<xsl:when test="$prop-class-mod='Long'">long</xsl:when>
			<xsl:when test="$prop-class-mod='Float'">float</xsl:when>
			<xsl:when test="$prop-class-mod='DECIMAL'">BigDecimal</xsl:when>
			<xsl:when test="$prop-class-mod='BINARY'">byte[]</xsl:when>
			<xsl:when test="$prop-class-mod='TIME'">Date</xsl:when>
			<xsl:when test="$prop-class-mod='TIMESTAMP'">Timestamp</xsl:when>
			<xsl:otherwise><xsl:value-of select="$prop-class"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="prop-getters-setters">
		<xsl:for-each select="property[not(contains($collection-classes,concat('#',@type,'#')))]">
		        <xsl:if test="not(@name='key')">
				<xsl:call-template name="prop-getter"/>
				<xsl:if test="not(@SG:visibility='protected' or contains($readonly-props,concat('#',@name,'#')))">
					<xsl:call-template name="prop-setter"/>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
		<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @return guid',$crlf,$tab,' */',$crlf)"/>
		<xsl:text>	public String getGuid();

</xsl:text>
	</xsl:template>
	
	<xsl:template name="prop-getters-setters-collection">
		<xsl:for-each select="property[contains($collection-classes,concat('#',@type,'#'))]">
			<xsl:call-template name="prop-getter"/>
			<xsl:call-template name="prop-adder"/>
			<xsl:call-template name="prop-remover"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="prop-getter">
		<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @return ',@text,$crlf,$tab,' */',$crlf)"/>
		<xsl:value-of select="concat($tab,'public ')"/>
		<xsl:call-template name="prop-type">
			<xsl:with-param name="prop-class" select="@type"/>
		</xsl:call-template>
		<xsl:text> </xsl:text>
		<xsl:call-template name="getter-name">
			<xsl:with-param name="prop-name" select="@name"/>
		</xsl:call-template>
		<xsl:text>();
	
</xsl:text>
	</xsl:template>
	
	<xsl:template match="aspectrelation" mode="getter">
		<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @return ',@name,$crlf,$tab,' */',$crlf)"/>
		<xsl:value-of select="concat($tab,'public ')"/>
		<xsl:variable name="target-service">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="string" select="@targetservice"/>
				<xsl:with-param name="substring" select="'.'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="substring(@cardinality,4,1)='1'">
				<xsl:variable name="target-aspect" select="@targetaspect"/>
				<xsl:for-each select="//coolservice[@name=$target-service]/aspect[@name=$target-aspect][1]">
					<xsl:apply-templates select="." mode="package"/>.<xsl:apply-templates select="." mode="modelclass-aspect"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>Collection</xsl:otherwise>
		</xsl:choose>
		<xsl:text> </xsl:text>
		<xsl:call-template name="getter-name">
			<xsl:with-param name="prop-name" select="@name"/>
		</xsl:call-template>
		<xsl:text disable-output-escaping="yes">();
	
</xsl:text>
	</xsl:template>

	<xsl:template match="aspectrelation" mode="setter">
		<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @return ',@name,$crlf,$tab,' */',$crlf)"/>
		<xsl:text>	public void </xsl:text>
		<xsl:call-template name="setter-name">
			<xsl:with-param name="prop-name" select="@name"/>
		</xsl:call-template>
		<xsl:text>(</xsl:text>
		<xsl:variable name="target-service">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="string" select="@targetservice"/>
				<xsl:with-param name="substring" select="'.'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="substring(@cardinality,4,1)='1'">
				<xsl:variable name="target-aspect" select="@targetaspect"/>
				<xsl:for-each select="//coolservice[@name=$target-service]/aspect[@name=$target-aspect][1]">
					<xsl:apply-templates select="." mode="package"/>.<xsl:apply-templates select="." mode="modelclass-aspect"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>Collection</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="concat(' related',@targetaspect)"/>
		<xsl:text disable-output-escaping="yes">);
	
</xsl:text>
	</xsl:template>

	<xsl:template match="aspectrelation" mode="remover">
		<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @return ',@name,$crlf,$tab,' */',$crlf)"/>
		<xsl:text>	public boolean </xsl:text>
		<xsl:call-template name="removerelation-name">
			<xsl:with-param name="prop-name" select="@name"/>
		</xsl:call-template>
		<xsl:text>(</xsl:text>
		<xsl:variable name="target-service">
			<xsl:call-template name="substring-after-last">
				<xsl:with-param name="string" select="@targetservice"/>
				<xsl:with-param name="substring" select="'.'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="target-aspect" select="@targetaspect"/>
		<xsl:for-each select="//coolservice[@name=$target-service]/aspect[@name=$target-aspect][1]">
			<xsl:apply-templates select="." mode="package"/>.<xsl:apply-templates select="." mode="modelclass-aspect"/>
		</xsl:for-each>
		<xsl:value-of select="concat(' related',@targetaspect, 'Row')"/>
		<xsl:text disable-output-escaping="yes">);	

</xsl:text>
	</xsl:template>

	<xsl:template match="aspectrelation" mode="adder">
	        <xsl:if test="not(substring(@cardinality,4,1)='1')">
			<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @return ',@name,$crlf,$tab,' */',$crlf)"/>
		<xsl:text>	public boolean </xsl:text>
			<xsl:call-template name="addrelation-name">
				<xsl:with-param name="prop-name" select="@name"/>
			</xsl:call-template>
		<xsl:text>(</xsl:text>
			<xsl:variable name="target-service">
				<xsl:call-template name="substring-after-last">
					<xsl:with-param name="string" select="@targetservice"/>
					<xsl:with-param name="substring" select="'.'"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="target-aspect" select="@targetaspect"/>
			<xsl:for-each select="//coolservice[@name=$target-service]/aspect[@name=$target-aspect][1]">
				<xsl:apply-templates select="." mode="package"/>.<xsl:apply-templates select="." mode="modelclass-aspect"/>
			</xsl:for-each>
		<xsl:value-of select="concat(' related',@targetaspect, 'Row')"/>
		<xsl:text disable-output-escaping="yes">);
	
</xsl:text>
	        </xsl:if>
	</xsl:template>
	
	<xsl:template name="prop-setter">

			<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @param ',@name,' ',@text,$crlf,$tab,' */',$crlf)"/>
			<xsl:text>	public void </xsl:text>
			<xsl:call-template name="setter-name">
				<xsl:with-param name="prop-name" select="@name"/>
			</xsl:call-template>
			<xsl:text>(</xsl:text>
			<xsl:call-template name="prop-type">
				<xsl:with-param name="prop-class" select="@type"/>
			</xsl:call-template>
			<xsl:value-of select="concat(' ',@name)"/>
			<xsl:text>);	
	
</xsl:text>
	</xsl:template>
	
	<xsl:template name="prop-adder">
			<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @param item item to add to ',@text,$crlf,$tab,' */',$crlf)"/>
			<xsl:text>	public void </xsl:text>
			<xsl:call-template name="adder-name">
				<xsl:with-param name="prop-name" select="@name"/>
			</xsl:call-template>
			<xsl:text disable-output-escaping="yes">(Object item);
	
</xsl:text>
	</xsl:template>
	
	<xsl:template name="prop-remover">
			<xsl:value-of select="concat($tab,'/**',$crlf,$tab,' * @param item item to remove from ',@text,$crlf,$tab,' */',$crlf)"/>
			<xsl:text>	public void </xsl:text>
			<xsl:call-template name="remover-name">
				<xsl:with-param name="prop-name" select="@name"/>
			</xsl:call-template>
			<xsl:text disable-output-escaping="yes">(Object item);
	
</xsl:text>
	</xsl:template>
	
</xsl:stylesheet>
