<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">
	<xsl:import href="JavaTemplate.xslt"/>
	<xsl:import href="WDModelCommon.xslt"/>
	<xsl:import href="ActionTemplate.xslt"/>

	<xsl:template name="class-imports">
		<xsl:text>import java.util.Collection;
import java.sql.Date;

</xsl:text>
		<xsl:variable name="name" select="@name"/>
		<xsl:if test="../method[@name=$name]/parameter[@type='TIMESTAMP']">import java.sql.Timestamp;

</xsl:if>
	</xsl:template>

	<xsl:template name="class-declaration">
		<xsl:text>public interface </xsl:text>
		<xsl:apply-templates select="." mode="modelclass-actionIP"/>
		<xsl:text> extends com.sap.tc.col.client.generic.api.IStructure</xsl:text>
	</xsl:template>

	<xsl:template name="class-content">
		<xsl:variable name="name" select="@name"/>
		<xsl:for-each select="../../method[@name=$name]/parameter">
			<xsl:call-template name="param-getter"/>
			<xsl:call-template name="param-setter"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="getter-name">
		<xsl:param name="param-name"/>
		<xsl:text>get</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$param-name"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="setter-name">
		<xsl:param name="param-name"/>
		<xsl:text>set</xsl:text>
		<xsl:call-template name="title-case">
			<xsl:with-param name="string" select="$param-name"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="param-type">
		<xsl:param name="param-class"/>
		<xsl:variable name="param-class-mod">
			<xsl:choose>
				<xsl:when test="starts-with($param-class,'java.lang.')">
					<xsl:value-of select="substring($param-class,11,string-length($param-class)-10)"/>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="translate($param-class,$upper-case,$lower-case)"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$param-class-mod='integer'">int</xsl:when>
			<xsl:when test="$param-class-mod='double'">double</xsl:when>
			<xsl:when test="$param-class-mod='boolean'">boolean</xsl:when>
			<xsl:when test="$param-class-mod='byte'">byte</xsl:when>
			<xsl:when test="$param-class-mod='character'">char</xsl:when>
			<xsl:when test="$param-class-mod='short'">short</xsl:when>
			<xsl:when test="$param-class-mod='long'">long</xsl:when>
			<xsl:when test="$param-class-mod='float'">float</xsl:when>
			<xsl:when test="$param-class-mod='string'">String</xsl:when>
			<xsl:when test="$param-class-mod='decimal'">BigDecimal</xsl:when>
			<xsl:when test="$param-class-mod='binary'">byte[]</xsl:when>
			<xsl:when test="$param-class-mod='date'">Date</xsl:when>
			<xsl:when test="$param-class-mod='timestamp' or $param-class-mod='time'">Date</xsl:when>
			<xsl:otherwise><xsl:value-of select="$param-class"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="param-getter">
		<xsl:value-of select="concat($tab,'public ')"/>
		<xsl:call-template name="param-type">
			<xsl:with-param name="param-class" select="@type"/>
		</xsl:call-template>
		<xsl:text> </xsl:text>
		<xsl:call-template name="getter-name">
			<xsl:with-param name="param-name" select="@name"/>
		</xsl:call-template>
		<xsl:text>();
</xsl:text>
	</xsl:template>
	
	<xsl:template name="param-setter">
			<xsl:text>	public void </xsl:text>
			<xsl:call-template name="setter-name">
				<xsl:with-param name="param-name" select="@name"/>
			</xsl:call-template>
			<xsl:text>(</xsl:text>
			<xsl:call-template name="param-type">
				<xsl:with-param name="param-class" select="@type"/>
			</xsl:call-template>
			<xsl:value-of select="concat(' ',@name)"/>
			<xsl:text>);
</xsl:text>
	</xsl:template>
	
</xsl:stylesheet>
