<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="SimpleTypeTemplate.xslt"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>
	
	<xsl:template match="simple-type">
		<DtSimpleType xmlns="http://xml.sap.com/2002/10/metamodel/dictionary" xmlns:IDX="urn:sap.com:DtDictionary.DtSimpleType:2.0" mmRelease="6.30" mmVersion="2.0" mmTimestamp="1063191691918" name="{@name}" typeName="{@name}" package="{@package}" masterLanguage="en">
			<xsl:attribute name="builtInType">
				<xsl:choose>
					<xsl:when test="@enum='true'">string</xsl:when>
					<xsl:when test="@base-type='Integer'">integer</xsl:when>
					<xsl:when test="@base-type='BigDecimal'">decimal</xsl:when>
					<xsl:when test="@base-type='Double'">double</xsl:when>
					<xsl:when test="@base-type='Date'">date</xsl:when>
					<xsl:when test="@base-type='TIME'">time</xsl:when>
					<xsl:when test="@base-type='TIMESTAMP'">timestamp</xsl:when>
					<xsl:when test="@base-type='Binary'">binary</xsl:when>
					<xsl:otherwise>string</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:variable name="jdbc-type">
				<xsl:choose>
					<xsl:when test="@enum='true'">VARCHAR</xsl:when>
					<xsl:when test="@base-type='Integer'">INTEGER</xsl:when>
					<xsl:when test="@base-type='BigDecimal'">DECIMAL</xsl:when>
					<xsl:when test="@base-type='Double'">DOUBLE</xsl:when>
					<xsl:when test="@base-type='Date'">DATE</xsl:when>
					<xsl:when test="@base-type='TIME'">TIME</xsl:when>
					<xsl:when test="@base-type='TIMESTAMP'">TIMESTAMP</xsl:when>
					<xsl:when test="@base-type='Binary'">BLOB</xsl:when>
					<xsl:otherwise>VARCHAR</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<DtSimpleType.DbProperty>
				<DtDbProperty dbDefault="{@dbDefault}" name="DbProperty" notNull="{@notNull}" jdbcTypeName="{$jdbc-type}"/>
			</DtSimpleType.DbProperty>
			<DtSimpleType.ExternalRepresentation>
				<DtExternalRepresentation format="{@format}" name="ExternalRepresentation" readOnly="false">
				</DtExternalRepresentation>
			</DtSimpleType.ExternalRepresentation>
			<DtSimpleType.SchemaType>
				<DtSchemaType name="SchemaType">
					<xsl:if test="$jdbc-type='VARCHAR'">
						<xsl:attribute name="maxLength">
							<xsl:choose>
								<xsl:when test="string-length(@maxlength)=0">15</xsl:when>
								<xsl:otherwise><xsl:value-of select="@maxlength"/></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</xsl:if>
					<xsl:if test="@minInclusive!=''">
						<xsl:attribute name="minInclusive"><xsl:value-of select="@minInclusive"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@maxInclusive!=''">
						<xsl:attribute name="maxInclusive"><xsl:value-of select="@maxInclusive"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@minExclusive!=''">
						<xsl:attribute name="minExclusive"><xsl:value-of select="@minExclusive"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@maxExclusive!=''">
						<xsl:attribute name="maxExclusive"><xsl:value-of select="@maxExclusive"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="enumeration">
						<DtSchemaType.EnumerationValues>
							<xsl:for-each select="enumeration/option">
								<DtEnumerationValue name="{position()-1}" value="{@key}"/>
							</xsl:for-each>
						</DtSchemaType.EnumerationValues>
					</xsl:if>
				</DtSchemaType>
			</DtSimpleType.SchemaType>
			<DtSimpleType.TechnicalInfo>
				<DtTechnicalInfo name="TechnicalInfo">
				</DtTechnicalInfo>
			</DtSimpleType.TechnicalInfo>
			<DtSimpleType.Texts>
				<DtTextObject name="Texts">
				</DtTextObject>
			</DtSimpleType.Texts>
		</DtSimpleType>
	</xsl:template>
</xsl:stylesheet>
