<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="SimpleTypeTemplate.xslt"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>
	<xsl:template match="simple-type">
		<xliff version="1.1">
			<file source-language="en" product-name="DtSimpleType:{@name}[{@package}]" datatype="s2x">
				<header>
					<skl></skl>
					<phase-group></phase-group>
					<s2x xmlns="http://www.sap.com">
						<dtr>
							<sc/>
						</dtr>
						<giltDirectives>
							<develContact>Automatic generation</develContact>
							<domain/>
							<originalLocale xml:lang="en"/>
							<maxLength>255</maxLength>
						</giltDirectives>
					</s2x>
				</header>
				<body>
					<xsl:if test="enumeration">
						<group restype="description">
							<xsl:for-each select="enumeration/option">
								<trans-unit id="{$simple-type-name}_{position()}" resname="SchemaType/EnumerationValue:{position()-1}@description" maxwidth="255" translate="yes">
									<source><xsl:value-of select="@value"/></source>
								</trans-unit>
							</xsl:for-each>
						</group>
					</xsl:if>
				</body>
			</file>
		</xliff>
	</xsl:template>
</xsl:stylesheet>
