<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="JavaTemplate.xslt"/>
	<xsl:import href="SimpleTypeTemplate.xslt"/>
	<xsl:param name="package"/>
	<xsl:param name="use-ui-types"/>
	<xsl:variable name="digits" select="'0123456789'"/>
	<xsl:output method="text" version="1.0" encoding="UTF-8"/>

	<xsl:template name="class-declaration">
		<xsl:value-of select="concat('public interface ',substring(@name,1,1),translate(substring(@name,2,string-length(@name)-1),$upper-case,$lower-case),'Values')"/>
	</xsl:template>
	
	<xsl:template name="class-package">
		<xsl:choose>
			<xsl:when test="string-length($package)!=0"><xsl:value-of select="$package"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="@package"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="class-content">
		<xsl:call-template name="value-consts"/>
	</xsl:template>
	
	<xsl:template name="value-consts">
		<xsl:variable name="var-type">
			<xsl:choose>
				<xsl:when test="@enum='true' and $use-ui-types='true'">String</xsl:when>
				<xsl:otherwise><xsl:value-of select="@base-type"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="line-start">
			<xsl:value-of select="concat($tab,'public static final ')"/>
			<xsl:choose>
				<xsl:when test="$var-type='Integer'">int</xsl:when>
				<xsl:when test="$var-type='Double'">double</xsl:when>
				<xsl:otherwise><xsl:value-of select="$var-type"/></xsl:otherwise>
			</xsl:choose>
			<xsl:text> </xsl:text>
		</xsl:variable>
		<xsl:for-each select="enumeration/option">
			<xsl:value-of select="$line-start"/>
			<xsl:call-template name="java-name">
				<xsl:with-param name="string" select="translate(@value,$lower-case,$upper-case)"/>
			</xsl:call-template>
			<xsl:text> = </xsl:text>
			<xsl:call-template name="java-const">
				<xsl:with-param name="value" select="@key"/>
				<xsl:with-param name="type" select="$var-type"/>
			</xsl:call-template>
			<xsl:value-of select="concat(';',$crlf)"/>
		</xsl:for-each>
		<xsl:value-of select="$crlf"/>
	</xsl:template>

	<xsl:template name="java-name">
		<xsl:param name="string"/>
		<xsl:if test="string-length($string)&gt;0">
			<xsl:variable name="first-char" select="substring($string,1,1)"/>
			<xsl:choose>
				<xsl:when test="contains($lower-case,$first-char) or contains($upper-case,$first-char) or contains($digits,$first-char)">
					<xsl:value-of select="$first-char"/>
				</xsl:when>
				<xsl:when test="$first-char!='('">
					<xsl:text>_</xsl:text>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$first-char!='('">
				<xsl:call-template name="java-name">
					<xsl:with-param name="string" select="substring($string,2,string-length($string)-1)"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
