<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="functions.xslt"/>
	<xsl:param name="pp-purpose" select="Assembly"/>
	<xsl:param name="pp-name" select="concat('DictionaryValues',$pp-purpose)"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>
	<xsl:template match="dictionary">
		<public-part version="1.0.1" xmlns:IDX="urn:sap.com:PublicPart:1.0" xmlns="http://xml.sap.com/2002/11/PublicPart" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
			<xsl:attribute name="xsi:schemaLocation">http://xml.sap.com/2002/11/PublicPart ppdef.xsd</xsl:attribute>
			<name><xsl:value-of select="$pp-name"/></name>
			<purpose><xsl:value-of select="translate($pp-purpose,$upper-case,$lower-case)"/></purpose>
			<caption/>
			<entities>
				<xsl:for-each select="simple-type[@gen-consts]">
					<xsl:variable name="c-name" select="concat(substring(@name,1,1),translate(substring(@name,2,string-length(@name)-1),$upper-case,$lower-case),'Values')"/>
					<entity>
						<name><xsl:value-of select="$c-name"/></name>
						<package><xsl:value-of select="$package-prefix"/>ui.dictionary</package>
						<caption><xsl:value-of select="$c-name"/></caption>
						<description><xsl:value-of select="$c-name"/></description>
						<entity-type>Java Class</entity-type>
						<entity-sub-type>Class</entity-sub-type>
					</entity>
				</xsl:for-each>
			</entities>
		</public-part>
	</xsl:template>
</xsl:stylesheet>
