<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="functions.xslt"/>
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>
	<xsl:template match="dictionary">
		<public-part version="1.0.1" xmlns:IDX="urn:sap.com:PublicPart:1.0" xmlns="http://xml.sap.com/2002/11/PublicPart" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
			<xsl:attribute name="xsi:schemaLocation">http://xml.sap.com/2002/11/PublicPart ppdef.xsd</xsl:attribute>
			<name>MABackendTypesAssembly</name>
			<purpose>assembly</purpose>
			<caption/>
			<entities>
				<xsl:for-each select="simple-type[not(@location='Database')]">
					<entity>
						<name><xsl:value-of select="@name"/></name>
						<package><xsl:value-of select="translate(@package,'.','/')"/></package>
						<caption><xsl:value-of select="@name"/></caption>
						<description><xsl:value-of select="@name"/></description>
						<entity-type>Dictionary Simple Type</entity-type>
						<entity-sub-type>Source</entity-sub-type>
					</entity>
				</xsl:for-each>
			</entities>
		</public-part>
	</xsl:template>
</xsl:stylesheet>
