<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:SG="http://www.sap.com/xapps/xslt_generation/">

	<xsl:include href="TypeAccess.xslt"/>
	
	<xsl:variable name="gen-code-start">//-- XMI2JMI tool generated code begin
</xsl:variable>
	<xsl:variable name="gen-code-finish">//-- XMI2JMI tool generated code end
</xsl:variable>
	<xsl:variable name="no-gen-code">	//No generated code
</xsl:variable>

	<xsl:variable name="common-props" select="';key;createdAt;createdBy;lastChangedAt;lastChangedBy;'"/>
	
	<xsl:template match="method" mode="delegation-code">
		<xsl:choose>
			<xsl:when test="@methodType='1'">		<xsl:apply-templates select="." mode="delegation-call"/>;
</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="m-name" select="@name"/>
				<xsl:text/>		java.util.Collection resultDO = <xsl:apply-templates select="." mode="delegation-call"/>;
		retValue = resultDO;//convert<xsl:value-of select="../query[@name=$m-name]/@aspect"/>Collection(resultDO);
<xsl:text/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="coolservice" mode="be-service">
		<xsl:choose>
			<xsl:when test="@SG:stereotype='BO Service'"><xsl:value-of select="@name"/></xsl:when>
			<xsl:otherwise>
				<xsl:variable name="p-aspect" select="aspect[@primary='true']/@SG:parent"/>
				<xsl:value-of select="../coolservice[aspect[@name=$p-aspect]]/@name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="method" mode="delegation-call">
		<xsl:text/>get<xsl:apply-templates select=".." mode="be-service"/>().<xsl:value-of select="@name"/>(<xsl:text/>
		<xsl:for-each select="parameter">
			<xsl:variable name="u-type" select="translate(@type,$lower-case,$upper-case)"/>
			<xsl:text>new com.sap.caf.rt.bol.util.QueryFilter(</xsl:text>
			<xsl:if test="$u-type='DECIMAL' or $u-type='DOUBLE'">new java.math.BigDecimal(</xsl:if>
			<xsl:value-of select="@name"/>
			<xsl:if test="$u-type='DECIMAL' or $u-type='DOUBLE'">), "=="</xsl:if>
			<xsl:text>)</xsl:text>
			<xsl:if test="position()!=last()">, </xsl:if>
		</xsl:for-each>
		<xsl:text>)</xsl:text>
	</xsl:template>
	
	<!--xsl:template match="aspect" mode="function-convertCollection">
		<xsl:variable name="dataobject"><xsl:apply-templates select="." mode="dataobject"/></xsl:variable>
		<xsl:text/>	protected java.util.List convert<xsl:value-of select="@name"/>Collection(java.util.Collection doCollection) {
		java.util.List result = new java.util.ArrayList();
		for(java.util.Iterator it = doCollection.iterator(); it.hasNext(); ) {
			<xsl:value-of select="$dataobject"/> obj = (<xsl:value-of select="$dataobject"/>) it.next();
			result.add(convert<xsl:value-of select="@name"/>DataObject(obj));
		}
		return result;
	}

<xsl:text/>
	</xsl:template>
	
	<xsl:template match="aspect" mode="function-convertDatatype">
		<xsl:variable name="dataobject"><xsl:apply-templates select="." mode="dataobject"/></xsl:variable>
		<xsl:text/>	protected <xsl:value-of select="$dataobject"/> convert<xsl:value-of select="@name"/>Datatype(<xsl:apply-templates select="." mode="datatype"/> item) throws ServiceException {
		<xsl:value-of select="$dataobject"/> resultDO = get<xsl:apply-templates select=".." mode="be-service"/>().read(item.getKey());
<xsl:text/>
		<xsl:call-template name="synch-code">
			<xsl:with-param name="source" select="'item'"/>
			<xsl:with-param name="dest" select="'resultDO'"/>
		</xsl:call-template>
		<xsl:text/>		return resultDO;
	}
	
<xsl:text/>
	</xsl:template>
	
	<xsl:template match="aspect" mode="function-convertDataObject">
		<xsl:variable name="dataobject"><xsl:apply-templates select="." mode="dataobject"/></xsl:variable>
		<xsl:variable name="datatype"><xsl:apply-templates select="." mode="datatype"/></xsl:variable>
		<xsl:text/>	protected <xsl:value-of select="$datatype"/> convert<xsl:value-of select="@name"/>DataObject(<xsl:value-of select="$dataobject"/> obj) {
		<xsl:value-of select="$datatype"/> resultDT = new <xsl:value-of select="$datatype"/>();
<xsl:text/>
		<xsl:call-template name="synch-code">
			<xsl:with-param name="source" select="'obj'"/>
			<xsl:with-param name="dest" select="'resultDT'"/>
			<xsl:with-param name="synch-common" select="'true'"/>
		</xsl:call-template>
		<xsl:text/>		return resultDT;
	}
	
<xsl:text/>
	</xsl:template-->
	
	<!--xsl:template name="synch-code">
		<xsl:param name="source"/>
		<xsl:param name="dest"/>
		<xsl:param name="synch-common"/>
		<xsl:if test="$synch-common">
			<xsl:value-of select="concat($tab,$tab,$dest,'.setKey(',$source,'.getKey());',$crlf)"/>
		</xsl:if>
		<xsl:for-each select="property[@SG:visibility='public' and ($synch-common or not(contains($common-props,concat(';',@name,';'))))]">
			<xsl:variable name="p-name" select="@name"/>
			<xsl:if test="not(ancestor::coolservice/aspect[@key='true']/property[@name=$p-name])">
				<xsl:variable name="t-name">
					<xsl:call-template name="title-case">
						<xsl:with-param name="string" select="@name"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($tab,$tab,$dest,'.set',$t-name,'(',$source,'.get',$t-name,'());',$crlf)"/>
			</xsl:if>
		</xsl:for-each>
		<xsl:for-each select="../aspect[@key='true']/aspectrelation">
			<xsl:variable name="targetservice" select="@targetservice"/>
			<xsl:variable name="targetaspect" select="@targetaspect"/>
			<xsl:if test="@SG:externalrelation or /MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]/@SG:stereotype='BO Service'">
				<xsl:variable name="t-name">
					<xsl:call-template name="title-case">
						<xsl:with-param name="string" select="@name"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($tab,$tab,$dest,'.set',$t-name,'(',$source,'.get',$t-name,'());',$crlf)"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template-->
	
	<xsl:template name="xapp-package">
		<xsl:for-each select="ancestor-or-self::coolservice">
			<xsl:call-template name="revert">
				<xsl:with-param name="path" select="application/@provider"/>
			</xsl:call-template>
			<xsl:text>.</xsl:text>
			<xsl:value-of select="application/@id"/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="service-name">
		<xsl:for-each select="ancestor-or-self::coolservice">
			<xsl:value-of select="application/@provider"/>/<xsl:value-of select="application/@id"/>/<xsl:value-of select="@name"/>
			<xsl:variable name="s-name" select="aspect[@primary='true']/@name"/>
			<xsl:if test="@SG:stereotype!='BO Service' or not(../coolservice[aspect[@name=concat($s-name,'AS') and @SG:parent=$s-name]])">AS</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="aspect" mode="datatype">
		<xsl:call-template name="xapp-package"/>.appsrv.datatypes.<xsl:value-of select="@name"/>
		<xsl:variable name="s-name" select="@name"/>
		<xsl:if test="not(/MetaData/coolservice[aspect[@name=concat($s-name,'AS') and @SG:parent=$s-name]])">AS</xsl:if>
		<xsl:text>DS</xsl:text>
	</xsl:template>
	
	<xsl:template match="aspect" mode="dataobject">
		<xsl:variable name="do-name">
			<xsl:choose>
				<xsl:when test="@SG:stereotype='BO Service'"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="@SG:parent"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="xapp-package"/>.besrv.<xsl:value-of select="translate($do-name,$upper-case,$lower-case)"/>do.<xsl:value-of select="$do-name"/>DO<xsl:text/>
	</xsl:template>
	
	<xsl:template name="delegation-create">
		<xsl:value-of select="concat($tab,$tab)"/><xsl:apply-templates select="." mode="dataobject"/> newObj = get<xsl:apply-templates select=".." mode="be-service"/>().create(<xsl:call-template name="create-params"/>);
		retValue = newObj;//convert<xsl:value-of select="@name"/>DataObject(newObj);<xsl:text/>
	</xsl:template>
	
	<xsl:template name="create-params">
		<xsl:variable name="props" select="property[@SG:not-null]"/>
		<xsl:for-each select="property[@SG:not-null]">
			<xsl:if test="position()!=1">, </xsl:if>
			<xsl:value-of select="@name"/>
		</xsl:for-each>
		<xsl:if test="@primary='true'">
			<xsl:for-each select="../aspect[@key='true']/aspectrelation[substring(@cardinality,1,1)='1']">
				<xsl:variable name="targetservice" select="@targetservice"/>
				<xsl:variable name="targetaspect" select="@targetaspect"/>
				<xsl:if test="@SG:externalrelation or /MetaData/coolservice[@name=$targetservice]/aspect[@name=$targetaspect]/@SG:stereotype='BO Service'">
					<xsl:if test="$props or position()!=1">, </xsl:if>
					<xsl:call-template name="java-id">
						<xsl:with-param name="id" select="@name"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="delegation-read">
		<xsl:value-of select="concat($tab,$tab)"/><xsl:apply-templates select="." mode="dataobject"/> obj = get<xsl:apply-templates select=".." mode="be-service"/>().read(key);
		retValue = obj;//convert<xsl:value-of select="@name"/>DataObject(obj);<xsl:text/>
	</xsl:template>
	
	<xsl:template name="delegation-findByMP">
		<xsl:text/>		retValue = get<xsl:apply-templates select=".." mode="be-service"/>().findByMultipleParameters(params, implCheck);<xsl:text/>
	</xsl:template>
	
	<xsl:template name="delegation-update">
		<xsl:variable name="param">
			<xsl:call-template name="java-id">
				<xsl:with-param name="id" select="@name"/>
			</xsl:call-template>
		</xsl:variable>
		<!--xsl:text/>		get<xsl:apply-templates select=".." mode="be-service"/>().update(convert<xsl:value-of select="@name"/>Datatype(<xsl:value-of select="$param"/>));<xsl:text/-->
		<xsl:text/>		get<xsl:apply-templates select=".." mode="be-service"/>().update(<xsl:value-of select="$param"/>);<xsl:text/>
	</xsl:template>
	
	<xsl:template name="delegation-delete">
		<xsl:variable name="param">
			<xsl:call-template name="java-id">
				<xsl:with-param name="id" select="@name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:text>		</xsl:text><xsl:value-of select="../@name"/>Local besrv<xsl:value-of select="../@name"/> = get<xsl:apply-templates select=".." mode="be-service"/>();
		besrv<xsl:value-of select="../@name"/>.delete(<xsl:value-of select="$param"/>);<xsl:text/>
	</xsl:template>
	
	<xsl:template name="remove-gen-code">
		<xsl:param name="code"/>
		<xsl:choose>
			<xsl:when test="contains($code,$gen-code-start) and contains($code,$gen-code-finish)">
				<xsl:variable name="start" select="substring-before($code,$gen-code-start)"/>
				<xsl:variable name="finish" select="substring-after($code,$gen-code-finish)"/>
				<xsl:choose>
					<xsl:when test="string-length($start)+string-length($finish)&lt;string-length($code)">
						<xsl:value-of select="concat($start,$finish)"/>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$code"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$code"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="composite-update">
		<xsl:variable name="bean">
			<xsl:call-template name="java-id">
				<xsl:with-param name="id" select="@name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="indent" select="concat($tab,$tab)"/>
		<xsl:for-each select="SG:detail-services/detail-service">
			<xsl:variable name="sname" select="@name"/>
			<xsl:variable name="bean-class">
				<xsl:apply-templates select="/MetaData/coolservice[@name=$sname]/aspect[@primary='true']" mode="dataobject"/>
			</xsl:variable>
			
			<xsl:value-of select="concat($indent,@name,'Local srv',@name,' = get',@name,'();',$crlf)"/>
			<xsl:value-of select="concat($indent,'String key',@name,' = ',$bean,'.get',@name,'Key();',$crlf)"/>
			<xsl:value-of select="concat($indent,'if (key',@name,' != null) {',$crlf)"/>
			<xsl:value-of select="concat($indent,$tab,$bean-class,' db',@name,' = ',$crlf)"/>
			<xsl:value-of select="concat($indent,$tab,$tab,'(',$bean-class,') srv',@name,'.read(key',@name,');',$crlf)"/>
			<xsl:for-each select="ancestor::aspect//property[@SG:parent-service=$sname]">
				<xsl:variable name="t-name">
					<xsl:call-template name="title-case">
						<xsl:with-param name="string" select="@SG:parent-property"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($indent,$tab,'db',$sname,'.set',$t-name,'(',$bean,'.get',$t-name,'());',$crlf)"/>
			</xsl:for-each>
			<xsl:value-of select="concat($indent,$tab,'srv',@name,'.update(db',@name,');',$crlf)"/>
			<xsl:value-of select="concat($indent,'}',$crlf)"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="aspect" mode="setAssociatedFields">
		<xsl:variable name="bean">
			<xsl:call-template name="java-id">
				<xsl:with-param name="id" select="@name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="indent" select="concat($tab,$tab)"/>
		<xsl:text>	private void set</xsl:text>
		<xsl:if test="not(@primary='true')"><xsl:value-of select="@name"/></xsl:if>
		<xsl:text>AssociatedFields(</xsl:text><xsl:apply-templates select="." mode="datatype"/><xsl:text> item) throws ServiceException {
</xsl:text>
		<xsl:for-each select="SG:detail-services/detail-service">
			<xsl:variable name="sname" select="@name"/>
			<xsl:variable name="bean-var" select="'item'"/>
			
			<xsl:value-of select="concat($tab,$tab,@name,'Local srv',@name,' = get',@name,'();',$crlf)"/>
			<xsl:value-of select="concat($tab,$tab,'String key',@name,' = ',$bean-var,'.get',$sname,'Key();',$crlf)"/>
			<xsl:value-of select="concat($tab,$tab,'if (key',@name,' != null) {',$crlf)"/>
			<xsl:variable name="do"><xsl:apply-templates select="/MetaData/coolservice[@name=$sname]/aspect[@primary='true']" mode="dataobject"/></xsl:variable>
			<xsl:value-of select="concat($tab,$tab,$tab,$do,' do',@name,' = ',$crlf,$tab,$tab,$tab,$tab,'(',$do,') srv',@name,'.read(key',@name,');',$crlf)"/>
			<xsl:for-each select="ancestor::aspect//property[@SG:parent-service=$sname]">
				<xsl:variable name="getter">
					<xsl:text>get</xsl:text>
					<xsl:call-template name="title-case">
						<xsl:with-param name="string" select="@SG:parent-property"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="setter">
					<xsl:text>set</xsl:text>
					<xsl:call-template name="title-case">
						<xsl:with-param name="string" select="@name"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($tab,$tab,$tab,$bean-var,'.',$setter,'(do',$sname,'.',$getter,'());',$crlf)"/>
			</xsl:for-each>
			<xsl:value-of select="concat($tab,$tab,'}',$crlf)"/>
		</xsl:for-each>
		<xsl:text>	}

</xsl:text>
	</xsl:template>
	
	<!--xsl:template name="function-copyCollection">	protected void copyCollection(Collection dstn, Collection src) throws Exception {
		if (null == dstn) {
			dstn = (null == src) ? new ArrayList() : (Collection)src.getClass().newInstance();
		} else {
			dstn.clear();
		}
		if (null != src) {
			dstn.addAll(src);
		}
	}
	
</xsl:template-->

	<xsl:template match="coolservice" mode="implemented-imports">
		<xsl:choose>
			<xsl:when test="@SG:implemented-service='type-access'">
				<xsl:call-template name="type-access-imports"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="coolservice" mode="implemented-internalCoding">
		<xsl:choose>
			<xsl:when test="@SG:implemented-service='type-access'">
				<xsl:call-template name="type-access-internalCoding"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="method" mode="implemented-coding">
		<xsl:choose>
			<xsl:when test="ancestor::coolservice/@SG:implemented-service='type-access'">
				<xsl:call-template name="type-access-provideTypeValues"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
