/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.objecttypehandler;

/**
 * This class reflects the "ResourceType" element from the ObjectTypeHandler.dtd
 * It holds the elements attribute and mode. If no mode is set in the OTH, the
 * implementation must set its mode value to <code>SOURCE_EXCLUSIVE</code> .
 */
public interface IResourceType {

  /**
   * a resourcetype with this value as handling-attribute will only match for
   * the link that points to an <code>IResource</code> with this resourcetype
   */
  public final static String TARGET_EXCLUSIVE = "target_exclusive";

  /**
   * a resourcetype with this value as handling-attribute will only match for
   * the <code>IResource</code> with this resourcetype, not for a link that
   * points to it. This is the default behavior.
   */
  public final static String SOURCE_EXCLUSIVE = "source_exclusive";

  /**
   * a resourcetype with this value as handling-attribute will match for both
   * the <code>IResource</code> with this resourcetype, and for a link that
   * points to it.
   */
  public final static String BOTH = "source_or_target";

  /**
   * get the handling-attribute of the class.
   *
   * @return the handling-attribute. Must not be <code>null</code>
   */
  public String getHandling();

  /**
   * get the resourcetype-attribute of the class.
   *
   * @return the resourcetype-attribute. Must not be <code>null</code>
   */
  public String getResourceType();

  /**
   * sets the resourcetype-attribute of the class.
   *
   * @param type the resourcetype-attribute. Must not be <code>null</code>
   */
  public void setResourceType(String type);

}
