/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.objecttypehandler;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.service.IService;
import java.util.Vector;

/**
 * @todo: Description of the interface.
 */
public interface IObjectTypeHandlerService extends IService {

  /**
   * @return an empty instance of the IObjectTypeHandlerList
   * @exception WcmException Exception raised in failure situation
   */
  IObjectTypeHandlerList getEmptyObjectTypeHandlerList()
    throws WcmException;

  /**
   * Get the ObjectTypeHandler attribute of the IObjectTypeHandlerService
   * object.
   *
   * @return The ObjectTypeHandler value
   * @exception WcmException Exception raised in failure situation
   */
  IObjectTypeHandlerList getObjectTypeHandler()
    throws WcmException;

  /**
   * Get the ObjectTypeHandlerList that matches for this resource. If in the
   * Handler resourcetype, mimetype or extension are defined and the given
   * <code>IResource</code> does not provide values for these attributes this
   * handler will not be included in the list. The path-validation is done the
   * following way: A path specified in the oth ending wihtout a "*" means, only
   * exact matches are used -> this handler will only be valid for one resource
   * A path specified in the oth ending with a "/" followed by one "*" means,
   * that all direct children of this resource will match A path specified in
   * the oth ending with a "/" followed by two "*" means, that all children and
   * childrens children of this resource will match <pre>
   *   resource is "/example/level_1/myresource.gif"
   *
   * OTH_A specifies the path "/example/level_1"
   * OTH_A is not valid for the resource, because its URI does not match the given path
   *
   * OTH_B specifies the path "/example/level_1/*" -> matches!
   *
   * OTH_C specifies the path "/example/*"
   * OTH_C is not valid for the resource, because only children of "/example" would match
   *
   * OTH_D specifies the path "/example/**" -> matches!
   *
   * </pre>
   *
   * @param resource TODO: Description of the incoming method parameter
   * @return The ObjectTypeHandler value
   * @exception WcmException Exception raised in failure situation
   */
  IObjectTypeHandlerList getObjectTypeHandler(IResource resource)
    throws WcmException;

  /**
   * Gets the List of ObjectTypeHandlers which are valid for the given resource
   * and which implement the wanted <code>IActionType</code> There are several
   * internal filters realized a) resourceType b) mimeType (not for ICollection
   * objects) c) extension (not for ICollection objects) d) actiontype In a
   * first step, all ObjectTypeHandler for the RID of the resource are returned.
   * Then the filters are applied in order a), b), c). If a resource doesn't
   * have a resourcetype set, only oths that don't have a resource type
   * specified are returned. If a resource has one or several resource types
   * defined, the oths that have none or one matching resource tpye are valid.
   * Other ones are filtered out. If the oths does not specify the <code>
   * IActionType</code> requested, it will be filtered out The returned list of
   * oths is not sorted.
   *
   * @param resource the resource that the action is needed for
   * @param actionType the action requested
   * @return The ObjectTypeHandler value
   * @exception WcmException Exception raised in failure situation
   */
  IObjectTypeHandlerList getObjectTypeHandler(IResource resource, IActionType actionType)
    throws WcmException;

  /**
   * Reloads all oth definitions.
   *
   * @exception WcmException Exception raised in failure situation
   */
  void reload()
    throws WcmException;

  IObjectTypeHandlerList getObjectTypeHandlerList(Vector resourceTypes)
    throws WcmException;
}
