/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.objecttypehandler;
import com.sapportals.wcm.util.uri.*;

import java.util.Comparator;

import java.util.Vector;

/**
 * @todo: Description of the interface.
 */
public interface IObjectTypeHandlerList extends Cloneable {

  /**
   * TODO: Description of the Method.
   *
   * @return TODO: Description of the outgoing return value
   */
  public int size();

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean containsObjectTypeHandler(IObjectTypeHandler handler);

  /**
   * TODO: Description of the Method.
   *
   * @param handlerList TODO: Description of the incoming method parameter
   */
  public void add(IObjectTypeHandlerList handlerList);

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean add(IObjectTypeHandler handler);

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean remove(IObjectTypeHandler handler);

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandler get(int index);

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandler set(int index, IObjectTypeHandler handler);

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @param resource TODO: Description of the incoming method parameter
   */
  public void add(int index, IObjectTypeHandler resource);

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandler remove(int index);

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public int indexOf(IObjectTypeHandler handler);

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public int lastIndexOf(IObjectTypeHandler handler);

  /**
   * TODO: Description of the Method.
   *
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandlerListIterator listIterator();

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandlerListIterator listIterator(int index);

  /**
   * TODO: Description of the Method.
   *
   * @param index1 TODO: Description of the incoming method parameter
   * @param index2 TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandlerList subList(int index1, int index2);

  /**
   * TODO: Description of the Method.
   *
   * @param path TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   * @depricated
   */
  public IObjectTypeHandlerList sublistForPath(URI path);

  /**
   * @param path
   * @return
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  public IObjectTypeHandlerList sublistForPath(RID path);

  /**
   * TODO: Description of the Method.
   *
   * @param mimeType TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandlerList sublistForMimetype(String mimeType);

  /**
   * returns a sublist of <code>IObjectTypeHandler</code> that match for the
   * given mimetype or targetmimetype. This method should be used, if a list of
   * OTHs is needed for an <code>IResource</code> for an internal link.
   * Depending on the oth's attributes, an oth might also be valid for a link,
   * if the targetmimetype supplied matches the mimetype defined for the oth.
   * See <code>IMimeType</code> for details
   *
   * @param mimeType the mimetype of the internal link, might be <code>null
   *      </code>
   * @param targetMimeType the mimetype of the <code>IResource</code> the link
   *      points at, might be <code>null</code>
   * @return a new instance of the <code>IObjectTypeHandlerList</code> ,
   *      containing a subset of the oths in this list
   */
  public IObjectTypeHandlerList sublistForMimetype(String mimeType, String targetMimeType);

  /**
   * TODO: Description of the Method.
   *
   * @param extension TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandlerList sublistForExtension(String extension);

  /**
   * TODO: Description of the Method.
   *
   * @param actionType TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IObjectTypeHandlerList sublistForAction(IActionType actionType);

  /**
   * TODO: Description of the Method.
   *
   * @param resourceTypes TBD: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   * @depricated
   */
  public IObjectTypeHandlerList sublistForResourceTypes(Vector resourceTypes);

  /**
   * returns a sublist of <code>IObjectTypeHandler</code> that match for the
   * given resourcetypes or targetresourcetypes. This method should be used, if
   * a list of OTHs is needed for an <code>IResource</code> for an internal
   * link. Depending on the oth's attributes, an oth might also be valid for a
   * link, if the targeresourcetypes supplied matches the resourcetypes defined
   * for the oth. See <code>IResourceType</code> for details
   *
   * @param resourceTypes TBD: Description of the incoming method parameter
   * @param targetTypes TBD: Description of the incoming method parameter
   * @return a new instance of the <code>IObjectTypeHandlerList</code> ,
   *      containing a subset of the oths in this list
   */
  public IObjectTypeHandlerList sublistForResourceTypes(Vector resourceTypes, Vector targetTypes);

  /**
   * filters out all oths, that have a resourcetype defined. The underlying
   * resource doesn't have a resource type defined, so oths with one or several
   * resource types set as filter criteria cannot be applied on that resource
   * and are therefore filtered out by this method.
   *
   * @return a new instance of the <code>IObjectTypeHandlerList</code> ,
   *      containing a subset of the oths in this list
   */
  public IObjectTypeHandlerList sublistForNoResourceTypeGiven();
}
