/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.objecttypehandler;
import com.sapportals.wcm.WcmException;

import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.util.uri.URI;
import com.sapportals.wcm.util.uri.URL;
import java.util.Properties;
import java.util.Vector;

/**
 * TODO: Description of the interface.
 *
 * @author d029266
 */
public interface IObjectTypeHandler {

  /**
   * TODO: Description of the Method.
   *
   * @param name TODO: Description of the incoming method parameter
   * @param extensions TODO: Description of the incoming method parameter
   * @param mimeTypes TODO: Description of the incoming method parameter
   * @param paths TODO: Description of the incoming method parameter
   * @param actionList TODO: Description of the incoming method parameter
   * @param props TODO: Description of the incoming method parameter
   * @param resourceTypes TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   */
  public void initialize(String name, Vector extensions, Vector mimeTypes, Vector paths, IActionList actionList, Vector resourceTypes, Properties props)
    throws WcmException;

  /**
   * Get the Name attribute of the IObjectTypeHandler object.
   *
   * @return The Name value
   * @exception WcmException Exception raised in failure situation
   */
  public String getName()
    throws WcmException;

  /**
   * Get the URL attribute of the IObjectTypeHandler object.
   *
   * @param resource TODO: Description of the incoming method parameter
   * @param actionType TODO: Description of the incoming method parameter
   * @return The URL value
   * @exception WcmException Exception raised in failure situation
   */
  public URL getURL(IResource resource, IActionType actionType)
    throws WcmException;

  /**
   * Get the URL attribute of the IObjectTypeHandler object.
   *
   * @param resource TODO: Description of the incoming method parameter
   * @param actionType TODO: Description of the incoming method parameter
   * @param props TODO: Description of the incoming method parameter
   * @return The URL value
   * @exception WcmException Exception raised in failure situation
   */
  public URL getURL(IResource resource, IActionType actionType, Properties props)
    throws WcmException;

  /**
   * Get the ActionList attribute of the IObjectTypeHandler object.
   *
   * @return The ActionList value
   */
  public IActionList getActionList();

  /**
   * Get the Extensions attribute of the IObjectTypeHandler object.
   *
   * @return The Extensions value
   */
  public String[] getExtensions();

  /**
   * Get the MimeTypes attribute of the IObjectTypeHandler object. The return
   * vector holds instances of <code>IMimeType</code>
   *
   * @return The MimeTypes value, must not return <code>null</code>
   */
  public Vector getMimeTypes();

  /**
   * Get the Paths attribute of the IObjectTypeHandler object.
   *
   * @return The Paths value
   */
  public String[] getPaths();

  /**
   * Checks if the input string matches the paths of the object.
   *
   * @param needle The input string.
   * @return
   */
  public boolean matches(String needle);

  /**
   * Checks if <code>testResourceType<\code> matches the <code>othResourceType
   * <\code>. Therefore <code>othResourceType<\code> has to be one of the
   * resource types of the object type handler.
   *
   * @param testResourceType resource type to be tested.
   * @param othResourceType resource type against which to check.
   * @return
   */
  public boolean matchesResourceType(String testResourceType, String othResourceType);

  /**
   * Returns identical values for identical paths arrays.
   *
   * @return
   */
  public Integer getPathsHashCode();

  /**
   * Get the Properties attribute of the IObjectTypeHandler object.
   *
   * @return The Properties value
   */
  public Properties getProperties();

  /**
   * Get the ResourceTypes attribute of the IObjectTypeHandler object. The
   * return vector holds instances of <code>IResourceType</code>
   *
   * @return The ResourceTypes value, must not return <code>null</code>
   */
  public Vector getResourceTypes();

  /**
   * Get the resource types exclusively for a source. The return vector holds
   * instances of <code>IResourceType</code>
   *
   * @return The ResourceTypes value, must not return <code>null</code>
   */
  public Vector getSourceResourceTypes();

  /**
   * Get the resource types exclusively for a target. The return vector holds
   * instances of <code>IResourceType</code>
   *
   * @return The ResourceTypes value, must not return <code>null</code>
   */
  public Vector getTargetResourceTypes();

  /**
   * @supplierCardinality 0..*
   */
  /*
   * #IAction lnkIAction;
   */
}
