/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.objecttypehandler;

import java.util.Locale;
import java.util.Properties;

/**
 * @todo: Description of the interface.
 */
public interface IAction {

  /**
   * Get the ActionType attribute of the IAction object.
   *
   * @return The ActionType value
   */
  public IActionType getActionType();

  /**
   * Get the URLTemplate attribute of the IAction object.
   *
   * @return The URLTemplate value
   */
  public String getURLTemplate();

  /**
   * Get the Properties attribute of the IAction object.
   *
   * @return The Properties value
   */
  public Properties getProperties();

  /**
   * Get the Description attribute of the IAction object.
   *
   * @return The Description value
   */
  public String getDescription();

  /**
   * Get the Description attribute of the IAction object.
   *
   * @param language TODO: Description of the incoming method parameter
   * @return The Description value
   */
  public String getDescription(Locale language);

  /**
   * @supplierCardinality 1
   */
  /*
   * #IActionType lnkIActionType;
   */
}
