/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.objecttypehandler;
import com.sapportals.wcm.IWcmConst;
import com.sapportals.wcm.WcmObject;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * @todo: Description of the class.
 */
public class ActionType extends WcmObject implements IActionType {

  protected String namespace;
  protected String actionType;

  public final static ActionType CREATE = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "create");
  public final static ActionType EDIT = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "edit");
  public final static ActionType DELETE = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "delete");
  public final static ActionType VIEW = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "view");
  public final static ActionType EXECUTE = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "execute");
  public final static ActionType SHOW_PROPERTIES = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "show_properties");
  public final static ActionType UI_COMMAND = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "uicommand");
  public final static ActionType UI_MASS_COMMAND = new ActionType(IWcmConst.SAP_WCM_NAMESPACE, "uimasscommand");

  /**
   * Construct object of class ActionType.
   *
   * @param namespace TODO: Description of the incoming method parameter
   * @param actionType TODO: Description of the incoming method parameter
   */
  public ActionType(String namespace, String actionType) {
    this.namespace = namespace;
    this.actionType = actionType;
  }

  /**
   * Get the Namespace attribute of the ActionType object.
   *
   * @return The Namespace value
   */
  public String getNamespace() {
    return this.namespace;
  }

  /**
   * Get the ActionType attribute of the ActionType object.
   *
   * @return The ActionType value
   */
  public String getActionType() {
    return this.actionType;
  }

  /**
   * TODO: Description of the Method.
   *
   * @param actionType TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean equals(Object actionType) {
    IActionType at = (IActionType)actionType;

    if ((at.getNamespace().equals(this.namespace)) &&
      (at.getActionType().equals(this.actionType))) {
      return true;
    }
    else {
      return false;
    }
  }

  public String toString() {
    return this.getActionType();
  }
}
