/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.objecttypehandler;

import com.sapportals.wcm.WcmObject;
import java.util.LinkedList;
import java.util.ListIterator;

/**
 * @todo: Description of the class.
 */
public final class ActionList extends WcmObject implements IActionList {

  private LinkedList m_list = null;

  /**
   * Construct object of class ActionList.
   *
   * @param handlerList TODO: Description of the incoming method parameter
   */
  public ActionList(ActionList handlerList) {
    m_list = new LinkedList(handlerList.m_list);
  }

  /**
   * Construct object of class ActionList.
   */
  public ActionList() {
    m_list = new LinkedList();
  }

  /**
   * Construct object of class ActionList.
   *
   * @param list TODO: Description of the incoming method parameter
   */
  protected ActionList(LinkedList list) {
    m_list = list;
  }

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IAction set(int index, IAction handler) {
    return (IAction)m_list.set(index, handler);
  }

  /**
   * Get the Action attribute of the ActionList object.
   *
   * @param actionType TODO: Description of the incoming method parameter
   * @return The Action value
   */
  public IAction getAction(IActionType actionType) {
    ListIterator iter = m_list.listIterator();

    while (iter.hasNext()) {
      IAction action = (IAction)iter.next();
      if (action.getActionType().equals(actionType)) {
        return action;
      }
    }

    return null;
  }

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IAction get(int index) {
    return (IAction)m_list.get(index);
  }

  /**
   * TODO: Description of the Method.
   *
   * @return TODO: Description of the outgoing return value
   */
  public int size() {
    return m_list.size();
  }

  /**
   * TODO: Description of the Method.
   *
   * @param action TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean containsAction(IAction action) {
    return m_list.contains(action);
  }

  /**
   * TODO: Description of the Method.
   *
   * @param actionType TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean containsAction(IActionType actionType) {
    /**
     * check precondition
     */
    if (actionType == null) {
      return false;
    }

    ListIterator iter = m_list.listIterator();
    while (iter.hasNext()) {
      IAction curAction = (IAction)iter.next();
      if (actionType.equals(curAction.getActionType())) {
        return true;
      }
    }

    return false;
  }

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean add(IAction handler) {
    return m_list.add(handler);
  }

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public boolean remove(IAction handler) {
    return m_list.remove(handler);
  }

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @param handler TODO: Description of the incoming method parameter
   */
  public void add(int index, IAction handler) {
    m_list.add(index, handler);
  }

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IAction remove(int index) {
    return (IAction)m_list.remove(index);
  }

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public int indexOf(IAction handler) {
    return m_list.indexOf(handler);
  }

  /**
   * TODO: Description of the Method.
   *
   * @param handler TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public int lastIndexOf(IAction handler) {
    return m_list.lastIndexOf(handler);
  }

  /**
   * TODO: Description of the Method.
   *
   * @return TODO: Description of the outgoing return value
   */
  public IActionListIterator listIterator() {
    return new ActionListIterator(m_list.listIterator());
  }

  /**
   * TODO: Description of the Method.
   *
   * @param index TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IActionListIterator listIterator(int index) {
    return new ActionListIterator(m_list.listIterator(index));
  }

  /**
   * TODO: Description of the Method.
   *
   * @param index1 TODO: Description of the incoming method parameter
   * @param index2 TODO: Description of the incoming method parameter
   * @return TODO: Description of the outgoing return value
   */
  public IActionList subList(int index1, int index2) {
    return (IActionList)new ActionList(new LinkedList(m_list.subList(index1, index2)));
  }
}
