/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

import java.util.Collection;
import java.util.Iterator;

/**
 * Represents the metadata of an instance of {@link com.sap.tc.cmi.model.ICMIModelObjectCollection} at runtime.
 * Implementing this class and providing instances of this class for each model object collection
 * is optional for a model implementation.
 * This type can be called, extendeded or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Stephan Ritter, Frank Weigel
 * @since 6.30 Beta 3
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/ICMIModelObjectCollectionInfo.java#1 $
 */
public interface ICMIModelObjectCollectionInfo extends ICMIAbstractInfo {

  /**
   * Returns meta info that describes the elements of the collection.
   * If there is no such meta info available, <code>null</node> is 
   * returned.</p>
   * 
   * There may be several different reasons, why null is returned:
   * <ul>
   * <li>model implementation doesn't provide meta info for classes at all
   * <li>model implementation didn't implement this method (as it is optional)
   * <li>a model implementation doesn't know a meta info that is 
   *     valid for all elements in the collection.
   * </ul>
   * 
   * The only guarantee is, that if a model class info is returned, all
   * elements in the collection must be compatible with that meta info.
   * That is an element may either implement IWDGenericModelClass and provide
   * access to all attributes and roles described in the class meta info
   * or an element may be a typed model class with typed accessors for 
   * all these attributes and roles. Both cases can even occur in a single 
   * collection.</p>
   *
   * A first class model implementation should always return a 
   * model class info for collections with a single type of elements. 
   * For collections that contain multiple types of elements, it should
   * provide meta info describing the "greatest common denominator"
   * (eg. describing a common baseclass).</p>
   */
  ICMIModelClassInfo getElementModelClassInfo();

  /**
   * @supplierCardinality 0..1
   * @directed
   * @label / 
   */
  /*# ICMIModelClassInfo lnkICMIModelClassInfo; */
}
