/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 */
package com.sap.tc.cmi.metadata;

import com.sap.dictionary.runtime.IDataType;
import com.sap.tc.cmi.model.*;

/**
 * Represents the metadata of a model class property at runtime.
 * This type can be called, extended or implemented by applications or frameworks using CMI.
 *
 * @SAPCMIPart 1
 * @author Markus Cherdron, Stephan Ritter
 * @version $Id: //tc/CommonModelInterface/630_VAL_REL/src/_cmi_api/java/com/sap/tc/cmi/metadata/ICMIModelClassPropertyInfo.java#1 $
 */
public interface ICMIModelClassPropertyInfo extends ICMIAbstractInfo {
	
  /**
   * Returns the metadata of the model class to which this property belongs.
   */
  ICMIModelClassInfo getModelClassInfo();

  /**
   * Returns the IDataType of the property or <code>null</code>, if there is none.
   */
  IDataType getDataType();

  /**
   * Returns <code>true</code>, if the property is read only and can not be modified at runtime
   * through the means of the CMI. This does not necessarily mean that the value of the
   * property is never changed in the model internally.
   * (Imagine a model class UTCClock with a read only property currentTime).
   */
  boolean isReadOnly();

}
