/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.resource;

import java.text.*;
import java.util.*;

/**
 * A helper class to load resource bundles.
 *
 * @author Jens Kaiser
 * @created 20. Mrz 2003
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/resource/ResourceBundles.java#9
 *      $
 */
public class ResourceBundles {
  private String m_baseName = null;

  private static HashMap m_bundles = new HashMap(5);

  private static List m_classloaders = new ArrayList();


  /**
   * Construct object of class ResourceBundles.
   *
   * @param baseName TBD: Description of the incoming method parameter
   */
  private ResourceBundles(String baseName) {
    m_baseName = baseName;
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @param objs TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key, Locale locale, Object[] objs)
    throws MissingResourceException {
    String bundle = getBundle(m_baseName, locale, true).getString(key);

    if (objs != null) {
      MessageFormat msg = new MessageFormat(bundle);
      msg.setLocale(locale);
      StringBuffer replacement = new StringBuffer();
      msg.format(objs, replacement, null);
      bundle = replacement.toString();
    }
    return bundle;
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param objs TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key, Object[] objs)
    throws MissingResourceException {
    return getString(key, Locale.getDefault(), objs);
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param obj TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key, Object obj)
    throws MissingResourceException {
    return getString(key, Locale.getDefault(), new Object[]{obj});
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param obj1 TBD: Description of the incoming method parameter
   * @param obj2 TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key, Object obj1, Object obj2)
    throws MissingResourceException {
    return getString(key, Locale.getDefault(), new Object[]{obj1, obj2});
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key, Locale locale)
    throws MissingResourceException {
    return getBundle(m_baseName, locale, true).getString(key);
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @param obj TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key, Locale locale, Object obj)
    throws MissingResourceException {
    return getString(key, locale, new Object[]{obj});
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @param obj1 TBD: Description of the incoming method parameter
   * @param obj2 TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key, Locale locale, Object obj1, Object obj2)
    throws MissingResourceException {
    return getString(key, locale, new Object[]{obj1, obj2});
  }


  /**
   * Get the string attribute of the ResourceBundles object.
   *
   * @param key TBD: Description of the incoming method parameter
   * @return The string value
   * @exception MissingResourceException Exception raised in failure situation
   */
  public String getString(String key)
    throws MissingResourceException {
    return this.getString(key, Locale.getDefault());
  }


  /**
   * TBD: Description of the Method.
   *
   * @param key TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public boolean exists(String key, Locale locale) {
    try {
      this.getString(key, locale);
    }
    catch (Exception ex) {
      //$JL-EXC$ 
      return false;
    }
    return true;
  }


  /**
   * TBD: Description of the Method.
   *
   * @param key TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public boolean exists(String key) {
    try {
      this.getString(key);
    }
    catch (Exception ex) {
      //$JL-EXC$ 
      return false;
    }
    return true;
  }


  /**
   * TBD: Description of the Method.
   *
   * @param cl TBD: Description of the incoming method parameter
   */
  public static void registerClassLoader(ClassLoader cl) {
    m_classloaders.add(cl);
  }


  /**
   * Get the bundle attribute of the ResourceBundles class.
   *
   * @param baseName TBD: Description of the incoming method parameter
   * @return The bundle value
   */
  public static ResourceBundles getBundle(String baseName) {
    return new ResourceBundles(baseName);
  }


  /**
   * Get the bundles attribute of the ResourceBundles class.
   *
   * @param baseName TBD: Description of the incoming method parameter
   * @return The bundles value
   */
  private static HashMap getBundles(String baseName) {
    if (m_bundles.containsKey(baseName)) {
      return (HashMap)(m_bundles.get(baseName));
    }
    else {
      return null;
    }
  }


  /**
   * Set the bundles attribute of the ResourceBundles class.
   *
   * @param baseName The new bundles value
   * @param bundles The new bundles value
   */
  private static void setBundles(String baseName, HashMap bundles) {
    m_bundles.put(baseName, bundles);
  }


  /**
   * Get the bundle attribute of the ResourceBundles class.
   *
   * @param baseName TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @param load TBD: Description of the incoming method parameter
   * @param cl TBD: Description of the incoming method parameter
   * @return The bundle value
   */
  private static ResourceBundle getBundle(String baseName, Locale locale, boolean load, ClassLoader cl) {
    HashMap baseMap = getBundles(baseName);

    try {
      if (baseMap == null) {
        if (false == load) {
          return null;
        }
        ResourceBundle res = ResourceBundle.getBundle(baseName, locale, cl);
        baseMap = new HashMap(5);
        baseMap.put(new Integer(locale.hashCode()), res);
        setBundles(baseName, baseMap);
        return res;
      }
      else {
        ResourceBundle res = (ResourceBundle)baseMap.get(new Integer(locale.hashCode()));
        if (res == null) {
          if (false == load) {
            return null;
          }
          res = ResourceBundle.getBundle(baseName, locale, cl);
          baseMap.put(new Integer(locale.hashCode()), res);
          return res;
        }
        else {
          return res;
        }
      }
    }
    catch (MissingResourceException ex) {
      //$JL-EXC$ 
      return null;
    }
  }


  /**
   * Get the bundle attribute of the ResourceBundles class.
   *
   * @param baseName TBD: Description of the incoming method parameter
   * @param locale TBD: Description of the incoming method parameter
   * @param load TBD: Description of the incoming method parameter
   * @return The bundle value
   */
  private static ResourceBundle getBundle(String baseName, Locale locale, boolean load) {
    Iterator clIter = m_classloaders.iterator();
    ResourceBundle res = null;
    while (null == res && clIter.hasNext()) {
      res = getBundle(baseName, locale, load, (ClassLoader)clIter.next());
    }

    if (res == null) {
      ResourceBundle.getBundle(baseName, locale, (ClassLoader)m_classloaders.get(0));
    }
    return res;
  }

  static {
    // Todo:
    // m_classloaders.add( CrtClassLoaderRegistry.getClassLoader() );
  }
}
