/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.namespace;

import java.io.*;

/**
 * Interface describing a namespace-qualified name with a namespace prefix.
 * Please see <a href="http://www.w3.org/TR/1999/REC-xml-names-19990114/#NT-NCName">
 * here</a> .
 *
 * @created 29. Januar 2003
 */

public interface IName extends Serializable {
  public final static String NAMESPACE_SEPARATOR = "/";

  /**
   * Get full name, i.e. including namespace and local name.
   *
   * @return full name, i.e. including namespace and local name
   */
  public String getFullName();

  /**
   * Get local name, i.e. the part behind the namespace.
   *
   * @return local name, i.e. the part behind the namespace.
   */
  public String getLocalName();

  /**
   * Get namespace of the name or an empty string if there is no namespace
   * within the name.
   *
   * @return namespace of the name or an empty string if there is no namespace
   *      within the name
   */
  public String getNamespace();

  /**
   * Get namespace of the name or null if there is no namespace within the name,
   * e.g. used when the value is going to be passed to a XML DOM level 2 method.
   *
   * @return namespace of the name or null if there is no namespace within the
   *      name
   */
  public String getNamespaceOrNull();
}
