/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.exception;

import com.sap.localization.*;

import java.text.*;
import java.util.*;

/**
 * Class implementing a resource message wrapping the standard exception
 * location class due to the bad implementation and bad name scheme in that
 * package and the fact that the package seems to be totally misnamed as
 * com.sap.localization being just a localization package for the exception
 * framework. This class also allows to store messages not necesssarily being
 * localized in order to support easy exception creation.
 *
 * @created 19. Mrz 2003
 */
public class ResourceMessage extends LocalizableTextFormatter {
  private String message = null;

  /**
   * Construct object of class ResourceMessage.
   *
   * @param message not localized message
   */
  public ResourceMessage(String message) {
    this.message = message;
  }

  /**
   * Construct object of class ResourceMessage.
   *
   * @param message not localized message
   * @param args message arguments inserted by MessageFormat means
   */
  public ResourceMessage(String message, Object[] args) {
    this.message = MessageFormat.format(message, args);
  }

  /**
   * Construct object of class ResourceMessage.
   *
   * @param resourceBundleClassLoader class loader having access to the resource
   *      bundle
   * @param resourceBundleName resource bundle name used to look up resource
   *      bundle
   * @param key resource identifier for localized message
   */
  public ResourceMessage(
    ClassLoader resourceBundleClassLoader,
    String resourceBundleName,
    String key) {
    super(
      ResourceAccessor.getInstance(
      resourceBundleClassLoader,
      resourceBundleName),
      key,
      null,
      null);
  }

  /**
   * Construct object of class ResourceMessage.
   *
   * @param resourceBundleClassLoader class loader having access to the resource
   *      bundle
   * @param resourceBundleName resource bundle name used to look up resource
   *      bundle
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   */
  public ResourceMessage(
    ClassLoader resourceBundleClassLoader,
    String resourceBundleName,
    String key,
    Object[] args) {
    super(
      ResourceAccessor.getInstance(
      resourceBundleClassLoader,
      resourceBundleName),
      key,
      args,
      null);
  }

  /**
   * Construct object of class ResourceMessage.
   *
   * @param resourceAccessor resource accessor for localized message
   * @param key resource identifier for localized message
   */
  public ResourceMessage(
    ResourceAccessor resourceAccessor,
    String key) {
    super(resourceAccessor, key, null, null);
  }

  /**
   * Construct object of class ResourceMessage.
   *
   * @param resourceAccessor resource accessor for localized message
   * @param key resource identifier for localized message
   * @param args message arguments inserted by MessageFormat means
   */
  public ResourceMessage(
    ResourceAccessor resourceAccessor,
    String key,
    Object[] args) {
    super(resourceAccessor, key, args, null);
  }

  /**
   * Set actual locale to be used for the message.
   *
   * @param locale actual locale to be used for the message
   */
  public void setLocale(Locale locale) {
    if (message == null) {
      super.setLocale(locale);
    }
    else {
      ;
    }
  }

  /**
   * Get actual locale to be used for the message.
   *
   * @return actual locale to be used for the message
   */
  public Locale getLocale() {
    if (message == null) {
      return super.getLocale();
    }
    else {
      return Locale.getDefault();
    }
  }

  /**
   * Set actual time zone to be used for the message.
   *
   * @param timeZone actual time zone to be used for the message
   */
  public void setTimeZone(TimeZone timeZone) {
    if (message == null) {
      super.setTimeZone(timeZone);
    }
    else {
      ;
    }
  }

  /**
   * Get actual time zone to be used for the message.
   *
   * @return actual time zone to be used for the message
   */
  public TimeZone getTimeZone() {
    if (message == null) {
      return super.getTimeZone();
    }
    else {
      return TimeZone.getDefault();
    }
  }

  /**
   * Format message according to locale and timezone.
   *
   * @return localized message
   * @exception LocalizationException Exception raised in failure situation
   */
  public String format()
    throws LocalizationException {
    if (message == null) {
      return super.format();
    }
    else {
      return message;
    }
  }

  /**
   * Format message according to locale and timezone.
   *
   * @param locale locale
   * @return localized message
   * @exception LocalizationException Exception raised in failure situation
   */
  public String format(Locale locale)
    throws LocalizationException {
    if (message == null) {
      return super.format(locale);
    }
    else {
      return message;
    }
  }

  /**
   * Format message according to locale and timezone.
   *
   * @param timeZone time zone
   * @return localized message
   * @exception LocalizationException Exception raised in failure situation
   */
  public String format(TimeZone timeZone)
    throws LocalizationException {
    if (message == null) {
      return super.format(timeZone);
    }
    else {
      return message;
    }
  }

  /**
   * Format message according to locale and timezone.
   *
   * @param locale locale
   * @param timeZone time zone
   * @return localized message
   * @exception LocalizationException Exception raised in failure situation
   */
  public String format(Locale locale, TimeZone timeZone)
    throws LocalizationException {
    if (message == null) {
      return super.format(locale, timeZone);
    }
    else {
      return message;
    }
  }

  /**
   * Finally localize the message according to locale and timezone. The ability
   * to do localization on demand gets lost.
   *
   * @exception LocalizationException Exception raised in failure situation
   */
  public void finallyLocalize()
    throws LocalizationException {
    if (message == null) {
      super.finallyLocalize();
    }
    else {
      ;
    }
  }

  /**
   * Finally localize the message according to locale and timezone. The ability
   * to do localization on demand gets lost.
   *
   * @param locale locale
   * @exception LocalizationException Exception raised in failure situation
   */
  public void finallyLocalize(Locale locale)
    throws LocalizationException {
    if (message == null) {
      super.finallyLocalize(locale);
    }
    else {
      ;
    }
  }

  /**
   * Finally localize the message according to locale and timezone. The ability
   * to do localization on demand gets lost.
   *
   * @param timeZone time zone
   * @exception LocalizationException Exception raised in failure situation
   */
  public void finallyLocalize(TimeZone timeZone)
    throws LocalizationException {
    if (message == null) {
      super.finallyLocalize(timeZone);
    }
    else {
      ;
    }
  }

  /**
   * Finally localize the message according to locale and timezone. The ability
   * to do localization on demand gets lost.
   *
   * @param locale locale
   * @param timeZone time zone
   * @exception LocalizationException Exception raised in failure situation
   */
  public void finallyLocalize(Locale locale, TimeZone timeZone)
    throws LocalizationException {
    if (message == null) {
      super.finallyLocalize(locale, timeZone);
    }
    else {
      ;
    }
  }
}
