/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

import com.sap.netweaver.bc.rf.util.enum.*;

/**
 * Enumeration of event receiver modes.
 *
 * @author Markus Breitenfelder
 * @created 23. Januar 2003
 * @see IEventReceiver
 */
public final class ReceiverMode extends EnumWithDescription {
  public final static ReceiverMode OFF = new ReceiverMode(1, "Off");
  public final static ReceiverMode SENDING = new ReceiverMode(2, "Sending");
  public final static ReceiverMode SUSPEND = new ReceiverMode(3, "Suspended");
  public final static ReceiverMode HOLD = new ReceiverMode(4, "Hold");

  /**
   * Construct object of class ReceiverMode.
   *
   * @param id enumeration id
   * @param description enumeration description
   */
  private ReceiverMode(final int id, final String description) {
    super(id, description, false);
  }
}
