/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

/**
 * Interface describing an event sender which produces (instanciates) events.
 * Event senders must be registered at an {@link IEventBroker}. After
 * successfull registration this sender is allowed to use the broker's {@link
 * IEventBroker#send} method to send new events.
 *
 * @author Markus Breitenfelder
 * @created 23. Januar 2003
 */
public interface IEventSender {
  /**
   * Returns a list of event templates for all possible events this sender can
   * send. The event instances contained in the list are "templates", that means
   * the event parameter is not relevant. The broker will call it to build a
   * list of all possible events of all registered event senders.
   *
   * @return list of event templates for all possible events this sender can
   *      send
   */
  public IEventList getEvents();
}
