/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

/**
 * Interface describing an event receiver. Receivers must be registered at an
 * {@link IEventBroker} and will receive specific incoming events from it, when
 * registered for them.
 *
 * @author Markus Breitenfelder
 * @created 23. Januar 2003
 */
public interface IEventReceiver {
  /**
   * Method that will be called by the broker to notify the receiver about a new
   * incoming event it has registered for.
   *
   * @param event event sent by the sender (maybe mapped, see {@link
   *      IEventMapper})
   */
  public void received(IEvent event);
}
