/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

import java.util.*;

/**
 * An event mapper maps events to other events. This mapping takes place inside
 * the event broker for receivers that have registered an event mapper. It moves
 * the need to transform events from one kind to another from the event receiver
 * to the broker, but it is more a hack than anything else, because the mapper
 * is totally specific and will be used only in conjunction with the registered
 * receiver.
 *
 * @author Paul Goetz
 * @created 23. Januar 2003
 */
public interface IEventMapper {
  /**
   * Get the mapper's unique system id.
   *
   * @return mapper's unique system id
   */
  public String getID();

  /**
   * Get the mapper's displayable name.
   *
   * @return mapper's displayable name
   */
  public String getDescription();

  /**
   * Get the mapper's localized displayable name.
   *
   * @param locale locale
   * @return mapper's localized displayable name
   */
  public String getDescription(Locale locale);

  /**
   * Map or transform an event prior to sending it to the receiver from one kind
   * to another which then is sent to the receiver. It might be a good idea to
   * put the orginal event in the user defined parameter of the new mapped and
   * sent event.
   *
   * @param event event to be mapped
   * @return mapped event
   */
  public IEvent map(IEvent event);

  /**
   * Returns a list of mapped event templates for all possible events this
   * mapper can send. The event instances contained in the list are "templates",
   * that means the event parameter is not relevant. An implementation of this
   * method should call the broker and ask it to call all its senders to get the
   * list of all possible event templates which can possibly be handed over to a
   * mapper/receiver. Then the mapper should check, which of these event
   * templates are supported and can be mapped and should return these mapped
   * event templates in a list.
   *
   * @param broker broker to be asked for all possible events of all of its
   *      senders
   * @return list of event templates for all possible events this mapper can
   *      return in conjunction with the broker
   */
  public IEventList getEvents(IEventBroker broker);
}
