/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

/**
 * Interface describing a special list iterator for event lists without any
 * modifying operations. Therefore this iterator isn't derived from the standard
 * list iterator interface.
 *
 * @author Markus Breitenfelder
 * @created 23. Januar 2003
 */
public interface IEventListIterator {
  /**
   * Check for next event in list.
   *
   * @return true if another event is in list
   */
  public boolean hasNext();

  /**
   * Get next event from list.
   *
   * @return next event from list
   */
  public IEvent next();
}
