/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

import com.sap.netweaver.bc.rf.util.enum.*;

import java.util.*;

/**
 * Interface describing an event with a type and an arbitrary parameter.
 *
 * @author Markus Breitenfelder
 * @created 23. Januar 2003
 */
public interface IEvent {
  /**
   * Get unique id of event.
   *
   * @return unique id of event
   */
  public String getUniqueId();

  /**
   * Get correlation id of event.
   *
   * @return correlation id of event
   */
  public String getCorrelationId();

  /**
   * Get type of event.
   *
   * @return type of event
   */
  public EnumWithDescription getType();

  /**
   * Get arbitrary parameter of event.
   *
   * @return arbitrary parameter of event
   */
  public Object getParameter();

  /**
   * Get description of event.
   *
   * @return description of event
   */
  public String getDescription();

  /**
   * Get localized description of event.
   *
   * @param locale locale to be used for localization
   * @return localized description of event
   */
  public String getDescription(Locale locale);

  /**
   * Compares this event with another event for equality or some kind of
   * "similarity". Normally an event equals another if it is of the same
   * instance and type. There might be implementations that want to match one
   * event type with many others.
   *
   * @param template event to compare against
   * @return true, if the specified event template is equal to this event,
   *      according to the implemented matching rules
   */
  public boolean isLike(IEvent template);
}
