/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sap.netweaver.bc.rf.util.event;

import com.sap.tc.logging.*;

/**
 * Consumes events from the queue an calls the receivers received() method.
 *
 * @created 23. Januar 2003
 */
public class EventSenderThread extends Thread {
  private static Location logger =
    Location.getLocation(com.sap.netweaver.bc.rf.util.event.EventSenderThread.class);

  private boolean stop = false;
  private EventQueue queue = null;
  private IEventReceiver receiver = null;

  /**
   * Construct event sender thread based on given parameters.
   *
   * @param queue event queue
   * @param receiver event receiver
   */
  EventSenderThread(EventQueue queue, IEventReceiver receiver) {
    if (queue == null) {
      throw new NullPointerException("parameter queue is null");
    }
    if (receiver == null) {
      throw new NullPointerException("parameter receiver is null");
    }
    this.queue = queue;
    this.receiver = receiver;
    //setDaemon(false); // No deamon, all events in the queue should be logged on exit
    this.setDaemon(true);
    this.setPriority(Thread.NORM_PRIORITY);
    this.start();
    logger.debugT("EventSenderThread(52)", "EventSenderThread(50)");
  }

  /**
   * Dequeue and send events to the receiver, i.e. calls a receivers received()
   * method.
   */
  public void run() {
    while (!terminated()) {
      IEvent event = this.queue.dequeue();
      try {
        this.receiver.received(event);
      }
      catch (Throwable t) {
        //$JL-EXC$ 
        logger.errorT("run(66)",
          "run(69)");
      }
    }
    logger.debugT("run(70)", "run(72)");
  }

  /**
   * Will cause the thread to stop (if it is not waiting on a empty queue).
   */
  void terminate() {
    this.stop = true;
    logger.debugT("terminate(78)", "terminate(81)");
  }

  /**
   * Returns true when the thread is stopped.
   *
   * @return true when the thread is stopped
   */
  private boolean terminated() {
    return this.stop;
  }
}
